/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.TransportDefinition;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.hamcrest.Matchers;

public class ServiceUris {
    public static URI internal(Class<? extends ComponentId> idClass, InetAddress host, String ... pathParts) {
        return ServiceUris.internal(Components.lookup(idClass), host, pathParts);
    }

    public static URI internal(ComponentId compId, String ... pathParts) {
        return ServiceUris.internal(compId, Internets.localHostInetAddress(), pathParts);
    }

    public static URI internal(Component comp, InetAddress host, String ... pathParts) {
        return ServiceUris.internal(comp.getComponentId(), host, pathParts);
    }

    public static URI internal(Class<? extends ComponentId> idClass, String ... pathParts) {
        return ServiceUris.internal(Components.lookup(idClass), Internets.localHostInetAddress(), pathParts);
    }

    public static URI internal(Component comp, String ... pathParts) {
        return ServiceUris.internal(comp.getComponentId(), Internets.localHostInetAddress(), pathParts);
    }

    public static URI internal(ServiceConfiguration config, String ... pathParts) {
        return ServiceUris.internal(config.getComponentId(), config.getInetAddress(), config.getPort(), pathParts);
    }

    public static URI internal(ComponentId compId, InetAddress host, String ... pathParts) {
        return ServiceUris.internal(compId, host, compId.getPort(), pathParts);
    }

    public static URI internal(ComponentId compId, InetAddress host, Integer port, String ... pathParts) {
        return ServiceUris.makeInternal(compId, host, port, pathParts).get();
    }

    public static URI remote(Class<? extends ComponentId> idClass, InetAddress host, String ... pathParts) {
        return ServiceUris.remote(Components.lookup(idClass), host, pathParts);
    }

    public static URI remote(Component comp, InetAddress host, String ... pathParts) {
        return ServiceUris.remote(comp.getComponentId(), host, pathParts);
    }

    public static URI remote(Class<? extends ComponentId> idClass, String ... pathParts) {
        return ServiceUris.remote(Components.lookup(idClass), Internets.localHostInetAddress(), pathParts);
    }

    public static URI remote(Component comp, String ... pathParts) {
        return ServiceUris.remote(comp.getComponentId(), Internets.localHostInetAddress(), pathParts);
    }

    public static URI remote(ComponentId compId, String ... pathParts) {
        return ServiceUris.remote(compId, Internets.localHostInetAddress(), pathParts);
    }

    public static URI remote(ServiceConfiguration config, String ... pathParts) {
        return ServiceUris.remote(config.getComponentId(), config.getInetAddress(), config.getPort(), pathParts);
    }

    public static URI remote(ComponentId compId, InetAddress host, String ... pathParts) {
        return ServiceUris.remote(compId, host, compId.getPort(), pathParts);
    }

    public static URI remote(ComponentId compId, InetAddress host, Integer port, String ... pathParts) {
        return ServiceUris.make(compId, host, port, pathParts).query(compId.getServiceQueryParameters()).get();
    }

    public static URI remotePublicify(ServiceConfiguration config, String ... pathParts) {
        return ServiceUris.make(config.getComponentId(), config.getInetAddress(), config.getPort(), pathParts).getPublicify();
    }

    public static URI remotePublicify(Class<? extends ComponentId> idClass, String ... pathParts) {
        Component comp = Components.lookup(idClass);
        return ServiceUris.make(comp.getComponentId(), Internets.localHostInetAddress(), comp.getComponentId().getPort(), pathParts).getPublicify();
    }

    private static UriParserBuilder makeInternal(ComponentId compId, InetAddress host, Integer port, String ... pathParts) {
        return new UriParserBuilder(compId).scheme(compId.getTransports().iterator().next()).host(host).port(port).path(compId.getInternalServicePath(pathParts));
    }

    private static UriParserBuilder make(ComponentId compId, InetAddress host, Integer port, String ... pathParts) {
        return new UriParserBuilder(compId).scheme(compId.getTransports().iterator().next()).host(host).port(port).path(compId.getServicePath(pathParts));
    }

    public static class UriParserBuilder {
        private ComponentId componentId;
        private TransportDefinition scheme;
        private InetAddress address;
        private Integer port;
        private String path = null;
        private Map<String, String> query = Maps.newTreeMap();
        private boolean internal = false;
        private String fragment;

        UriParserBuilder(ComponentId componentId) {
            this.componentId = componentId;
        }

        public UriParserBuilder scheme(TransportDefinition uriScheme) {
            this.scheme = uriScheme;
            return this;
        }

        public UriParserBuilder host(InetAddress address) {
            this.address = address;
            return this;
        }

        public UriParserBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public UriParserBuilder path(String ... path) {
            this.path = (path != null && path.length > 0 ? "/" + Joiner.on((String)"/").join((Object[])path) : "/").replaceAll("^//*", "/");
            return this;
        }

        public UriParserBuilder query(Map<String, String> query) {
            if (query != null) {
                this.query.putAll(query);
            }
            return this;
        }

        public UriParserBuilder fragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public UriParserBuilder internal() {
            this.internal = true;
            return this;
        }

        public URI get() {
            Parameters.checkParam(this.address, Matchers.notNullValue());
            Parameters.checkParam(this.path, Matchers.notNullValue());
            if (this.scheme == null) {
                this.scheme = StackConfiguration.BasicTransport.HTTP;
            }
            if (this.port == null) {
                this.port = this.componentId.getPort();
            }
            if (this.internal) {
                this.path = this.componentId.getInternalServicePath(this.path);
            }
            String schemeString = StackConfiguration.DEFAULT_HTTPS_ENABLED != false ? this.scheme.getSecureScheme() : this.scheme.getScheme();
            String hostNameString = this.address.getHostAddress();
            try {
                URI u = new URI(schemeString, null, hostNameString, this.port, ("/" + this.path).replaceAll("^//", "/"), Lexemes.QUERY.format(this.query), null);
                u.parseServerAuthority();
                return u;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to construct URI: " + this.toString() + " because of: " + e, e);
            }
        }

        public URI getPublicify() {
            String hostNameString;
            String schemeString;
            Parameters.checkParam(this.address, Matchers.notNullValue());
            Parameters.checkParam(this.path, Matchers.notNullValue());
            if (this.scheme == null) {
                this.scheme = StackConfiguration.BasicTransport.HTTP;
            }
            if (this.port == null) {
                this.port = this.componentId.getPort();
            }
            if (this.internal) {
                this.path = this.componentId.getInternalServicePath(this.path);
            }
            String string = schemeString = StackConfiguration.DEFAULT_HTTPS_ENABLED != false ? this.scheme.getSecureScheme() : this.scheme.getScheme();
            String string2 = this.componentId.isPublicService() ? (StackConfiguration.USE_DNS_DELEGATION.booleanValue() ? this.componentId.name() + "." + StackConfiguration.lookupDnsDomain() : this.address.getHostAddress()) : (hostNameString = this.address.getHostAddress());
            String pathString = this.componentId.isPublicService() ? (StackConfiguration.USE_DNS_DELEGATION.booleanValue() ? "/" : "/" + this.path) : "/" + this.path;
            try {
                URI u = new URI(schemeString, null, hostNameString, this.port, pathString.replaceAll("^//", "/"), Lexemes.QUERY.format(this.query), null);
                u.parseServerAuthority();
                return u;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to construct URI: " + this.toString() + " because of: " + e, e);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UriParserBuilder:");
            if (this.componentId != null) {
                builder.append("componentId=").append(this.componentId.name()).append(":");
            }
            if (this.scheme != null) {
                builder.append("scheme=").append(this.scheme).append(":");
            }
            if (this.address != null) {
                builder.append("address=").append(this.address).append(":");
            }
            if (this.port != null) {
                builder.append("port=").append(this.port).append(":");
            }
            if (this.path != null) {
                builder.append("path=").append(this.path).append(":");
            }
            if (this.query != null) {
                builder.append("query=").append(this.query).append(":");
            }
            builder.append("internal=").append(this.internal).append(":");
            if (this.fragment != null) {
                builder.append("fragment=").append(this.fragment);
            }
            return builder.toString();
        }

        static enum Lexemes {
            SCHEME{

                @Override
                String format(Object ... args) {
                    Parameters.checkParam(args, Matchers.arrayWithSize((int)1));
                    return "" + args[0];
                }
            }
            ,
            HOST{

                @Override
                String format(Object ... args) {
                    Parameters.checkParam(args, Matchers.arrayWithSize((int)1));
                    Parameters.checkParam(args[0].getClass(), Matchers.typeCompatibleWith(InetAddress.class));
                    return "" + ((InetAddress)args[0]).getCanonicalHostName();
                }
            }
            ,
            PORT{

                @Override
                String format(Object ... args) {
                    Parameters.checkParam(args, Matchers.arrayWithSize((int)1));
                    Parameters.checkParam(args[0].getClass(), Matchers.typeCompatibleWith(Integer.class));
                    return COLON.format(new Object[0]) + args[0];
                }
            }
            ,
            SERVICEPATH{

                @Override
                String format(Object ... args) {
                    Parameters.checkParam(args, Matchers.arrayWithSize((int)1));
                    Parameters.checkParam(args[0].getClass(), Matchers.typeCompatibleWith(String.class));
                    return SLASH.format(new Object[0]) + args[0];
                }
            }
            ,
            QUERY{
                Function<Map.Entry<String, String>, String> transform = new Function<Map.Entry<String, String>, String>(){

                    public String apply(Map.Entry<String, String> input) {
                        return input.getKey() + EQUALS.format(new Object[0]) + input.getValue();
                    }
                };

                @Override
                String format(Object ... args) {
                    if (args != null && args.length > 0) {
                        Parameters.checkParam(args[0].getClass(), Matchers.typeCompatibleWith(Map.class));
                        Map queryArgs = (Map)args[0];
                        if (!queryArgs.isEmpty()) {
                            Iterable argPairString = Iterables.transform(queryArgs.entrySet(), this.transform);
                            return Joiner.on((String)AMPERSAND.format(new Object[0])).join(argPairString);
                        }
                        return null;
                    }
                    return null;
                }
            }
            ,
            FRAGMENT{

                @Override
                final String format(Object ... args) {
                    return "#" + args[0];
                }
            }
            ,
            QUESTIONMARK{

                @Override
                final String format(Object ... args) {
                    return "?";
                }
            }
            ,
            AMPERSAND{

                @Override
                final String format(Object ... args) {
                    return "&";
                }
            }
            ,
            EQUALS{

                @Override
                final String format(Object ... args) {
                    return "=";
                }
            }
            ,
            COLON{

                @Override
                final String format(Object ... args) {
                    return ":";
                }
            }
            ,
            SLASH{

                @Override
                final String format(Object ... args) {
                    return "/";
                }
            };


            abstract String format(Object ... var1);
        }
    }
}

