/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.events.ServiceEvents;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.MultiDatabasePropertyEntry;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.configurable.SingletonDatabasePropertyEntry;
import com.eucalyptus.configurable.StaticPropertyEntry;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.DisableServiceResponseType;
import com.eucalyptus.empyrean.DisableServiceType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.EmpyreanMessage;
import com.eucalyptus.empyrean.EnableServiceResponseType;
import com.eucalyptus.empyrean.EnableServiceType;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.empyrean.StartServiceResponseType;
import com.eucalyptus.empyrean.StartServiceType;
import com.eucalyptus.empyrean.StopServiceResponseType;
import com.eucalyptus.empyrean.StopServiceType;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.util.fsm.Automata;
import com.eucalyptus.util.fsm.HasStateMachine;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ServiceTransitions {
    static Logger LOG = Logger.getLogger(ServiceTransitions.class);
    private static final Component.State[] EMPTY = new Component.State[0];
    private static final Supplier<Void> STATIC_PROPERTIES_SUPPLIER = Suppliers.memoizeWithExpiration((Supplier)StaticPropertiesAdd.INSTANCE, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    LoadingCache<TransitionActions, ServiceTransitionCallback> hi = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransitionActions, ServiceTransitionCallback>(){

        public ServiceTransitionCallback load(TransitionActions input) {
            return null;
        }
    });

    private static Component.State[] sequence(Component.State ... states) {
        return states;
    }

    public static CheckedListenableFuture<ServiceConfiguration> pathTo(ServiceConfiguration configuration, Component.State goalState) {
        try {
            Object[] path = null;
            Component.State initialState = configuration.lookupState();
            switch (goalState) {
                case LOADED: {
                    path = ServiceTransitions.pathToLoaded(initialState);
                    break;
                }
                case DISABLED: {
                    path = ServiceTransitions.pathToDisabled(initialState);
                    break;
                }
                case ENABLED: {
                    path = ServiceTransitions.pathToEnabled(initialState);
                    break;
                }
                case STOPPED: {
                    path = ServiceTransitions.pathToStopped(initialState);
                    break;
                }
                case NOTREADY: {
                    path = ServiceTransitions.pathToStarted(initialState);
                    break;
                }
                case PRIMORDIAL: {
                    path = ServiceTransitions.pathToPrimordial(initialState);
                    break;
                }
                case BROKEN: {
                    path = ServiceTransitions.pathToBroken(initialState);
                    break;
                }
                case INITIALIZED: {
                    path = ServiceTransitions.pathToInitialized(initialState);
                }
            }
            if (!initialState.equals(goalState)) {
                Logs.extreme().debug((Object)(configuration.getName() + " transitioning " + initialState + "->" + goalState + " using path " + Joiner.on((String)"->").join(path)));
            }
            CheckedListenableFuture<ServiceConfiguration> result = ServiceTransitions.executeTransition(configuration, Automata.sequenceTransitions((HasStateMachine)configuration, (Automata.State[])path));
            return result;
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)(configuration.getName() + " failed to transition to " + goalState + " because of: " + Exceptions.causeString(ex)));
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
    }

    private static Component.State[] pathToBroken(Component.State fromState) {
        Component.State[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case BROKEN: {
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToPrimordial(fromState), (Object)Component.State.BROKEN);
            }
        }
        return transition;
    }

    private static Component.State[] pathToPrimordial(Component.State fromState) {
        Component.State[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case PRIMORDIAL: {
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToStopped(fromState), (Object)Component.State.PRIMORDIAL);
            }
        }
        return transition;
    }

    private static Component.State[] pathToLoaded(Component.State fromState) {
        Component.State[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case LOADED: {
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToInitialized(fromState), (Object)Component.State.LOADED);
            }
        }
        return transition;
    }

    private static final Component.State[] pathToInitialized(Component.State fromState) {
        Object[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case LOADED: {
                transition = (Component.State[])ObjectArrays.concat((Object)fromState, (Object[])ServiceTransitions.pathToInitialized(Component.State.NOTREADY));
                break;
            }
            case ENABLED: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.DISABLED);
            }
            case DISABLED: 
            case NOTREADY: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.STOPPED);
            }
            case STOPPED: 
            case PRIMORDIAL: 
            case BROKEN: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.INITIALIZED);
                break;
            }
        }
        return transition;
    }

    private static Component.State[] pathToStarted(Component.State fromState) {
        Object[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case NOTREADY: {
                break;
            }
            case LOADED: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.NOTREADY);
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToLoaded(fromState), (Object)Component.State.NOTREADY);
            }
        }
        return transition;
    }

    private static final Component.State[] pathToDisabled(Component.State fromState) {
        Object[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case DISABLED: 
            case ENABLED: 
            case NOTREADY: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.DISABLED);
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToStarted(fromState), (Object)Component.State.DISABLED);
            }
        }
        return transition;
    }

    private static final Component.State[] pathToEnabled(Component.State fromState) {
        Object[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case ENABLED: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.ENABLED);
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToDisabled(fromState), (Object)Component.State.ENABLED);
            }
        }
        return transition;
    }

    private static final Component.State[] pathToStopped(Component.State fromState) {
        Object[] transition = new Component.State[]{fromState};
        switch (fromState) {
            case ENABLED: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.DISABLED);
            }
            case DISABLED: 
            case NOTREADY: 
            case BROKEN: {
                transition = (Component.State[])ObjectArrays.concat((Object[])transition, (Object)Component.State.STOPPED);
                break;
            }
            case STOPPED: {
                break;
            }
            default: {
                transition = (Component.State[])ObjectArrays.concat((Object[])ServiceTransitions.pathToStarted(fromState), (Object)Component.State.STOPPED);
            }
        }
        return transition;
    }

    private static CheckedListenableFuture<ServiceConfiguration> executeTransition(ServiceConfiguration config, Callable<CheckedListenableFuture<ServiceConfiguration>> transition) {
        if (transition != null) {
            try {
                return transition.call();
            }
            catch (Exception ex) {
                return Futures.predestinedFailedFuture(ex);
            }
        }
        return Futures.predestinedFuture(config);
    }

    private static <T extends EmpyreanMessage> T sendEmpyreanRequest(ServiceConfiguration parent, EmpyreanMessage msg) throws Exception {
        ServiceConfiguration config = ServiceConfigurations.createEphemeral(Empyrean.INSTANCE, parent.getInetAddress());
        Logs.extreme().debug((Object)("Sending request " + msg.getClass().getSimpleName() + " to " + parent.getFullName()));
        try {
            if (BootstrapArgs.debugTopology() == null) {
                EmpyreanMessage reply = (EmpyreanMessage)AsyncRequests.sendSync(config, msg);
                return (T)reply;
            }
            return (T)((EmpyreanMessage)msg.getReply());
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)(parent.getFullName() + " failed request because of: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
    }

    private static void processTransition(ServiceConfiguration parent, Callback.Completion transitionCallback, TransitionActions transitionAction) {
        TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> transitionRecord = parent.lookupStateMachine().getTransitionRecord();
        Enum trans = null;
        try {
            trans = Hosts.isServiceLocal(parent) ? ServiceLocalTransitionCallbacks.valueOf(transitionAction.name()) : (Hosts.isCoordinator() ? CloudRemoteTransitionCallbacks.valueOf(transitionAction.name()) : ServiceRemoteTransitionNotification.valueOf(transitionAction.name()));
            if (trans != null) {
                Logs.extreme().debug((Object)("Executing transition: " + trans.getClass() + "." + transitionAction.name() + " for " + parent));
                trans.fire(parent);
            }
            transitionCallback.fire();
            Faults.flush(parent);
        }
        catch (Exception ex) {
            Logs.extreme().info((Object)(parent.getName() + " failed " + transitionAction.name() + ": " + ex.getMessage()));
            if (Faults.filter(parent, ex)) {
                transitionCallback.fireException(ex);
                Faults.submit(parent, transitionRecord, Faults.failure(parent, ex));
                throw Exceptions.toUndeclared(ex);
            }
            transitionCallback.fire();
            Faults.submit(parent, transitionRecord, Faults.advisory(parent, ex));
        }
    }

    private static enum StaticPropertiesAdd implements Supplier<Void>
    {
        INSTANCE;


        public Void get() {
            for (ConfigurableProperty prop : Iterables.filter(PropertyDirectory.getPendingPropertyValues(), (Predicate)Predicates.instanceOf(StaticPropertyEntry.class))) {
                try {
                    PropertyDirectory.addProperty(prop);
                    try {
                        if (Databases.isVolatile().booleanValue()) continue;
                        prop.getValue();
                    }
                    catch (Exception ex) {
                        Logs.extreme().error((Object)ex);
                    }
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
            return null;
        }
    }

    public static enum StateCallbacks implements Callback<ServiceConfiguration>
    {
        FIRE_STATE_EVENT{

            @Override
            public void fire(ServiceConfiguration config) {
                if (Hosts.isCoordinator() && !config.isVmLocal().booleanValue() && config.getComponentId().isRegisterable() && !config.getComponentId().isAlwaysLocal().booleanValue() && !config.getComponentId().isCloudLocal().booleanValue()) {
                    ServiceEvents.fire(config, (Component.State)config.getStateMachine().getState());
                }
            }
        }
        ,
        PROPERTIES_ADD{

            @Override
            public void fire(ServiceConfiguration config) {
                if (Bootstrap.isFinished().booleanValue()) {
                    try {
                        List<ConfigurableProperty> props = PropertyDirectory.getPendingPropertyEntrySet(config.getComponentId().name());
                        for (ConfigurableProperty prop : props) {
                            if (prop instanceof SingletonDatabasePropertyEntry) {
                                PropertyDirectory.addProperty(prop);
                                continue;
                            }
                            if (!(prop instanceof MultiDatabasePropertyEntry)) continue;
                            MultiDatabasePropertyEntry addProp = ((MultiDatabasePropertyEntry)prop).getClone(config.getPartition());
                            PropertyDirectory.addProperty(addProp);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }
        }
        ,
        STATIC_PROPERTIES_ADD{

            @Override
            public void fire(ServiceConfiguration config) {
                if (Bootstrap.isOperational().booleanValue() && !Databases.isVolatile().booleanValue()) {
                    STATIC_PROPERTIES_SUPPLIER.get();
                }
            }
        }
        ,
        PROPERTIES_REMOVE{

            @Override
            public void fire(ServiceConfiguration config) {
                try {
                    String prefix = config.getPartition() + "." + config.getComponentId().name();
                    List<ConfigurableProperty> props = PropertyDirectory.getPropertyEntrySet(prefix);
                    for (ConfigurableProperty prop : props) {
                        if (prop instanceof SingletonDatabasePropertyEntry || !(prop instanceof MultiDatabasePropertyEntry)) continue;
                        ((MultiDatabasePropertyEntry)prop).setIdentifierValue(config.getPartition());
                        PropertyDirectory.removeProperty(prop);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        ENSURE_DISABLED{

            @Override
            public void fire(ServiceConfiguration input) {
                if (Component.State.ENABLED.apply(input) && Hosts.isServiceLocal(input)) {
                    try {
                        LOG.debug((Object)("Ensuring .disable()/.fireDisable() have been called for service entering NOTREADY: " + input.getFullName()));
                        ServiceLocalTransitionCallbacks.DISABLE.fire(input);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }
        };

    }

    static enum ServiceRemoteTransitionNotification implements ServiceTransitionCallback
    {
        LOAD{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
            }
        }
        ,
        DESTROY{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
            }
        }
        ,
        CHECK{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireCheck(parent);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        START{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireStart(parent);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        ENABLE{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireEnable(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        DISABLE{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireDisable(parent);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        STOP{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireStop(parent);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
        };

        private static LoadingCache<TransitionActions, ServiceTransitionCallback> map;

        public static ServiceTransitionCallback map(TransitionActions transition) {
            return (ServiceTransitionCallback)map.getUnchecked((Object)transition);
        }

        static {
            map = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransitionActions, ServiceTransitionCallback>(){

                public ServiceTransitionCallback load(TransitionActions input) {
                    return ServiceRemoteTransitionNotification.valueOf(input.name());
                }
            });
        }
    }

    static enum ServiceLocalTransitionCallbacks implements ServiceTransitionCallback
    {
        LOAD{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                parent.lookupBootstrapper().load();
                ServiceBuilders.lookup(parent.getComponentId()).fireLoad(parent);
            }
        }
        ,
        DESTROY{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                parent.lookupBootstrapper().destroy();
                if (Bootstrap.isFinished().booleanValue()) {
                    Components.lookup(parent.getComponentId()).destroy(parent);
                }
            }
        }
        ,
        CHECK{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                if (parent.isVmLocal().booleanValue() && Faults.isFailstop()) {
                    if (Component.State.ENABLED.apply(parent)) {
                        try {
                            DISABLE.fire(parent);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw new IllegalStateException("Failed to CHECK service " + parent.getFullName() + " because the host is currently fail-stopped.");
                }
                if (Component.State.ENABLED.apply(parent)) {
                    try {
                        parent.lookupBootstrapper().check();
                        ServiceBuilders.lookup(parent.getComponentId()).fireCheck(parent);
                    }
                    catch (Exception ex) {
                        if (Exceptions.isCausedBy(ex, Faults.CheckException.class)) {
                            Faults.CheckException checkEx = Exceptions.findCause(ex, Faults.CheckException.class);
                            Faults.failstop(parent, checkEx);
                        }
                        if (Faults.filter(parent, ex)) {
                            try {
                                DISABLE.fire(parent);
                            }
                            catch (Exception ex1) {
                                LOG.error((Object)("Failed to call DISABLE on an ENABLED service after CHECK failure: " + parent.getFullName() + " due to: " + ex.getMessage() + ". With current service info: " + parent));
                                Logs.extreme().error((Object)ex1, (Throwable)ex1);
                            }
                        }
                        throw ex;
                    }
                }
                try {
                    parent.lookupBootstrapper().check();
                    ServiceBuilders.lookup(parent.getComponentId()).fireCheck(parent);
                }
                catch (Exception ex) {
                    if (Exceptions.isCausedBy(ex, Faults.CheckException.class)) {
                        Faults.CheckException checkEx = Exceptions.findCause(ex, Faults.CheckException.class);
                        Faults.failstop(parent, checkEx);
                    }
                    throw ex;
                }
            }
        }
        ,
        START{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                if (!Bootstrap.isShuttingDown().booleanValue()) {
                    parent.lookupBootstrapper().start();
                    ServiceBuilders.lookup(parent.getComponentId()).fireStart(parent);
                }
            }
        }
        ,
        ENABLE{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                if (parent.isVmLocal().booleanValue() && Faults.isFailstop()) {
                    throw new IllegalStateException("Failed to ENABLE service " + parent.getFullName() + " because the host is currently fail-stopped.");
                }
                parent.lookupBootstrapper().enable();
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireEnable(parent);
                }
                catch (Exception ex) {
                    try {
                        parent.lookupBootstrapper().disable();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
        }
        ,
        DISABLE{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                try {
                    parent.lookupBootstrapper().disable();
                    ServiceBuilders.lookup(parent.getComponentId()).fireDisable(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        STOP{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
                parent.lookupBootstrapper().stop();
                ServiceBuilders.lookup(parent.getComponentId()).fireStop(parent);
            }
        };

        private static LoadingCache<TransitionActions, ServiceTransitionCallback> map;

        public static ServiceTransitionCallback map(TransitionActions transition) {
            return (ServiceTransitionCallback)map.getUnchecked((Object)transition);
        }

        static {
            map = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransitionActions, ServiceTransitionCallback>(){

                public ServiceTransitionCallback load(TransitionActions input) {
                    return ServiceLocalTransitionCallbacks.valueOf(input.name());
                }
            });
        }
    }

    static enum CloudRemoteTransitionCallbacks implements ServiceTransitionCallback
    {
        LOAD{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
            }
        }
        ,
        DESTROY{

            @Override
            public void fire(ServiceConfiguration parent) throws Exception {
            }
        }
        ,
        CHECK{

            @Override
            public void fire(final ServiceConfiguration parent) throws Exception {
                if (!parent.getComponentId().isDistributedService()) {
                    return;
                }
                Faults.CheckException errors = null;
                Host h = Hosts.lookup(parent.getHostName());
                if (h == null) {
                    UnknownHostException ex = new UnknownHostException("Failed to lookup host " + parent.getHostName() + " for service " + parent.getFullName() + ".  Current hosts are: " + Hosts.list());
                    errors = Faults.failure(parent, ex);
                } else if (!h.hasBootstrapped().booleanValue()) {
                    UnknownHostException ex = new UnknownHostException("Host " + parent.getHostName() + " not yet bootstrapped for service " + parent.getFullName() + ".");
                    errors = Faults.failure(parent, ex);
                } else {
                    DescribeServicesResponseType response = (DescribeServicesResponseType)ServiceTransitions.sendEmpyreanRequest(parent, new DescribeServicesType(){
                        {
                            this.getServices().add(TypeMappers.transform(parent, ServiceId.class));
                        }
                    });
                    ServiceStatusType status = (ServiceStatusType)Iterables.find(response.getServiceStatuses(), (Predicate)new Predicate<ServiceStatusType>(){

                        public boolean apply(ServiceStatusType arg0) {
                            return parent.getName().equals(arg0.getServiceId().getName());
                        }
                    });
                    errors = (Faults.CheckException)Faults.transformToExceptions().apply((Object)status);
                }
                if (Faults.Severity.FATAL.equals((Object)errors.getSeverity())) {
                    throw errors;
                }
                if (Faults.Severity.TRACE.equals((Object)errors.getSeverity())) {
                    Logs.extreme().error((Object)errors, (Throwable)errors);
                    return;
                }
                if (errors.getSeverity().ordinal() >= Faults.Severity.ERROR.ordinal()) {
                    throw errors;
                }
                Logs.extreme().error((Object)errors, (Throwable)errors);
            }
        }
        ,
        START{

            @Override
            public void fire(final ServiceConfiguration parent) throws Exception {
                StartServiceResponseType msg = (StartServiceResponseType)ServiceTransitions.sendEmpyreanRequest(parent, new StartServiceType(){
                    {
                        this.getServices().add(TypeMappers.transform(parent, ServiceId.class));
                    }
                });
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireStart(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        ENABLE{

            @Override
            public void fire(final ServiceConfiguration parent) throws Exception {
                EnableServiceResponseType msg = (EnableServiceResponseType)ServiceTransitions.sendEmpyreanRequest(parent, new EnableServiceType(){
                    {
                        this.getServices().add(TypeMappers.transform(parent, ServiceId.class));
                    }
                });
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireEnable(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        DISABLE{

            @Override
            public void fire(final ServiceConfiguration parent) throws Exception {
                DisableServiceResponseType msg = (DisableServiceResponseType)ServiceTransitions.sendEmpyreanRequest(parent, new DisableServiceType(){
                    {
                        this.getServices().add(TypeMappers.transform(parent, ServiceId.class));
                    }
                });
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireDisable(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        STOP{

            @Override
            public void fire(final ServiceConfiguration parent) throws Exception {
                StopServiceResponseType msg = (StopServiceResponseType)ServiceTransitions.sendEmpyreanRequest(parent, new StopServiceType(){
                    {
                        this.getServices().add(TypeMappers.transform(parent, ServiceId.class));
                    }
                });
                try {
                    ServiceBuilders.lookup(parent.getComponentId()).fireStop(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        };

        private static LoadingCache<TransitionActions, ServiceTransitionCallback> map;

        public static ServiceTransitionCallback map(TransitionActions transition) {
            return (ServiceTransitionCallback)map.getUnchecked((Object)transition);
        }

        static {
            map = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransitionActions, ServiceTransitionCallback>(){

                public ServiceTransitionCallback load(TransitionActions input) {
                    return CloudRemoteTransitionCallbacks.valueOf(input.name());
                }
            });
        }
    }

    public static enum TransitionActions implements TransitionAction<ServiceConfiguration>
    {
        ENABLE,
        CHECK,
        DISABLE,
        START,
        LOAD,
        STOP,
        DESTROY;


        @Override
        public boolean before(ServiceConfiguration parent) {
            try {
                EventRecord.here(ServiceBuilder.class, EventType.SERVICE_TRANSITION_BEFORE, this.name(), parent.lookupState().toString(), parent.getFullName().toString(), parent.toString()).exhaust();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            return true;
        }

        @Override
        public void leave(ServiceConfiguration parent, Callback.Completion transitionCallback) {
            try {
                EventRecord.here(ServiceBuilder.class, EventType.SERVICE_TRANSITION, this.name(), parent.lookupState().toString(), parent.getFullName().toString(), parent.toString()).exhaust();
                ServiceTransitions.processTransition(parent, transitionCallback, this);
            }
            catch (Exception ex) {
                transitionCallback.fireException(ex);
            }
        }

        @Override
        public void enter(ServiceConfiguration parent) {
            try {
                EventRecord.here(ServiceBuilder.class, EventType.SERVICE_TRANSITION_ENTER_STATE, this.name(), parent.lookupState().toString(), parent.getFullName().toString(), parent.toString()).exhaust();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public void after(ServiceConfiguration parent) {
            try {
                EventRecord.here(ServiceBuilder.class, EventType.SERVICE_TRANSITION_AFTER_STATE, this.name(), parent.lookupState().toString(), parent.getFullName().toString(), parent.toString()).exhaust();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    static interface ServiceTransitionCallback {
        public void fire(ServiceConfiguration var1) throws Exception;
    }
}

