/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceTransitions;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.fsm.ExistingTransitionException;
import com.eucalyptus.util.fsm.StateMachine;
import com.eucalyptus.util.fsm.StateMachineBuilder;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.TransitionHandler;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.eucalyptus.util.fsm.Transitions;
import com.google.common.collect.ImmutableList;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.log4j.Logger;

public class ServiceState
implements StateMachine<ServiceConfiguration, Component.State, Component.Transition> {
    static Logger LOG = Logger.getLogger(ServiceState.class);
    private final StateMachine<ServiceConfiguration, Component.State, Component.Transition> stateMachine;
    private final ServiceConfiguration parent;
    private Component.State goal = Component.State.DISABLED;
    private final NavigableSet<String> details = new ConcurrentSkipListSet<String>();

    public ServiceState(ServiceConfiguration parent) {
        this.parent = parent;
        this.stateMachine = this.buildStateMachine();
    }

    @Override
    public Component.State getState() {
        return this.stateMachine.getState();
    }

    public String getDetails() {
        return this.details.toString();
    }

    private StateMachine<ServiceConfiguration, Component.State, Component.Transition> buildStateMachine() {
        final TransitionAction noop = Transitions.noop();
        return new StateMachineBuilder<ServiceConfiguration, Component.State, Component.Transition>(this.parent, Component.State.PRIMORDIAL){
            {
                super(x0, x1);
                this.in(Component.State.NOTREADY).run(ServiceTransitions.StateCallbacks.ENSURE_DISABLED).run(ServiceTransitions.StateCallbacks.FIRE_STATE_EVENT);
                this.from(Component.State.PRIMORDIAL).to(Component.State.INITIALIZED).error(Component.State.BROKEN).on(Component.Transition.INITIALIZING).run(noop);
                this.from(Component.State.PRIMORDIAL).to(Component.State.BROKEN).error(Component.State.BROKEN).on(Component.Transition.FAILED_TO_PREPARE).run(noop);
                this.from(Component.State.INITIALIZED).to(Component.State.LOADED).error(Component.State.BROKEN).on(Component.Transition.LOAD).addListener(ServiceTransitions.StateCallbacks.STATIC_PROPERTIES_ADD).addListener(ServiceTransitions.StateCallbacks.PROPERTIES_ADD).run(ServiceTransitions.TransitionActions.LOAD);
                this.from(Component.State.LOADED).to(Component.State.NOTREADY).error(Component.State.BROKEN).on(Component.Transition.START).addListener(ServiceTransitions.StateCallbacks.FIRE_STATE_EVENT).addListener(ServiceTransitions.StateCallbacks.STATIC_PROPERTIES_ADD).addListener(ServiceTransitions.StateCallbacks.PROPERTIES_ADD).run(ServiceTransitions.TransitionActions.START);
                this.from(Component.State.NOTREADY).to(Component.State.DISABLED).error(Component.State.NOTREADY).on(Component.Transition.READY_CHECK).addListener(ServiceTransitions.StateCallbacks.STATIC_PROPERTIES_ADD).addListener(ServiceTransitions.StateCallbacks.PROPERTIES_ADD).run(ServiceTransitions.TransitionActions.CHECK);
                this.from(Component.State.DISABLED).to(Component.State.ENABLED).error(Component.State.NOTREADY).on(Component.Transition.ENABLE).addListener(ServiceTransitions.StateCallbacks.FIRE_STATE_EVENT).run(ServiceTransitions.TransitionActions.ENABLE);
                this.from(Component.State.DISABLED).to(Component.State.STOPPED).error(Component.State.NOTREADY).on(Component.Transition.STOP).addListener(ServiceTransitions.StateCallbacks.FIRE_STATE_EVENT).run(ServiceTransitions.TransitionActions.STOP);
                this.from(Component.State.NOTREADY).to(Component.State.STOPPED).error(Component.State.NOTREADY).on(Component.Transition.STOPPING_NOTREADY).addListener(ServiceTransitions.StateCallbacks.FIRE_STATE_EVENT).run(ServiceTransitions.TransitionActions.STOP);
                this.from(Component.State.DISABLED).to(Component.State.DISABLED).error(Component.State.NOTREADY).on(Component.Transition.DISABLED_CHECK).addListener(ServiceTransitions.StateCallbacks.STATIC_PROPERTIES_ADD).run(ServiceTransitions.TransitionActions.CHECK);
                this.from(Component.State.ENABLED).to(Component.State.DISABLED).error(Component.State.NOTREADY).on(Component.Transition.DISABLE).addListener(ServiceTransitions.StateCallbacks.FIRE_STATE_EVENT).run(ServiceTransitions.TransitionActions.DISABLE);
                this.from(Component.State.ENABLED).to(Component.State.ENABLED).error(Component.State.NOTREADY).on(Component.Transition.ENABLED_CHECK).addListener(ServiceTransitions.StateCallbacks.STATIC_PROPERTIES_ADD).run(ServiceTransitions.TransitionActions.CHECK);
                this.from(Component.State.STOPPED).to(Component.State.INITIALIZED).error(Component.State.BROKEN).on(Component.Transition.DESTROY).run(noop);
                this.from(Component.State.BROKEN).to(Component.State.STOPPED).error(Component.State.BROKEN).on(Component.Transition.STOPPING_BROKEN).run(noop);
                this.from(Component.State.BROKEN).to(Component.State.INITIALIZED).error(Component.State.BROKEN).on(Component.Transition.RELOAD).run(noop);
                this.from(Component.State.STOPPED).to(Component.State.PRIMORDIAL).error(Component.State.BROKEN).on(Component.Transition.REMOVING).run(ServiceTransitions.TransitionActions.DESTROY);
            }
        }.newAtomicMarkedState();
    }

    @Override
    public CheckedListenableFuture<ServiceConfiguration> transition(Component.State state) throws IllegalStateException, NoSuchElementException, ExistingTransitionException {
        try {
            return this.stateMachine.transition(state);
        }
        catch (IllegalStateException ex) {
            throw Exceptions.trace(ex);
        }
        catch (NoSuchElementException ex) {
            throw Exceptions.trace(ex);
        }
        catch (ExistingTransitionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.trace(new RuntimeException("Failed to perform transition from " + this.getState() + " to " + state + " for " + this.parent.getName() + ".\nCAUSE: " + ex.getMessage() + "\nSTATE: " + this.stateMachine.toString(), ex));
        }
    }

    public Component.State getGoal() {
        return this.goal;
    }

    void setGoal(Component.State goal) {
        this.goal = goal;
    }

    @Override
    public boolean isBusy() {
        return this.stateMachine.isBusy();
    }

    protected boolean checkTransition(Component.Transition transition) {
        return this.parent.getComponentId().isAvailableLocally() != false && this.stateMachine.isLegalTransition(transition);
    }

    @Override
    public ImmutableList<Component.State> getStates() {
        return this.stateMachine.getStates();
    }

    @Override
    public ImmutableList<TransitionHandler<ServiceConfiguration, Component.State, Component.Transition>> getTransitions() {
        return this.stateMachine.getTransitions();
    }

    @Override
    public boolean isLegalTransition(Component.Transition transitionName) {
        return this.stateMachine.isLegalTransition(transitionName);
    }

    @Override
    public ServiceConfiguration getParent() {
        return this.stateMachine.getParent();
    }

    public String toString() {
        return this.parent.getFullName().toString();
    }

    @Override
    public TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> getTransitionRecord() {
        return this.stateMachine.getTransitionRecord();
    }
}

