/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.ServiceConfiguration;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;

public class ServiceOrderings {
    static Ordering<ServiceConfiguration> partition = Ordering.natural().nullsFirst().onResultOf((Function)new Function<ServiceConfiguration, String>(){

        public String apply(ServiceConfiguration input) {
            return input.getPartition();
        }
    });
    static Ordering<ServiceConfiguration> name = Ordering.natural().nullsFirst().onResultOf((Function)new Function<ServiceConfiguration, String>(){

        public String apply(ServiceConfiguration input) {
            return input.getName();
        }
    });
    static Ordering<ServiceConfiguration> hostname = Ordering.natural().nullsFirst().onResultOf((Function)new Function<ServiceConfiguration, Integer>(){

        public Integer apply(ServiceConfiguration input) {
            return InetAddresses.coerceToInteger((InetAddress)input.getInetAddress());
        }
    });
    static Ordering<ServiceConfiguration> defaultOrdering = partition.compound(hostname).compound(name);

    public static Ordering<ServiceConfiguration> defaultOrdering() {
        return defaultOrdering;
    }

    public static Ordering<ServiceConfiguration> byPartition() {
        return partition;
    }

    public static Ordering<ServiceConfiguration> byHostname() {
        return hostname;
    }

    public static Ordering<ServiceConfiguration> byName() {
        return name;
    }
}

