/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.annotation.ServiceOperation;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceContext;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Timers;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.util.RequestQueue;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ServiceOperations {
    private static Logger LOG = Logger.getLogger(ServiceOperations.class);
    private static final Map<Class<? extends BaseMessage>, Function<?, ?>> serviceOperations = Maps.newHashMap();
    private static Boolean ASYNCHRONOUS = Boolean.FALSE;

    public static <T extends BaseMessage, I, O> Function<I, O> lookup(Class<T> msgType) {
        return serviceOperations.get(msgType);
    }

    public static boolean isUserOperation(BaseMessage msg) {
        return serviceOperations.containsKey(msg.getClass()) ? Ats.from(serviceOperations.get(msg.getClass())).get(ServiceOperation.class).user() : false;
    }

    public static <I extends BaseMessage, O extends BaseMessage> void dispatch(final I request) {
        if (!serviceOperations.containsKey(request.getClass()) || !StackConfiguration.OOB_INTERNAL_OPERATIONS.booleanValue()) {
            try {
                ServiceContext.dispatch(RequestQueue.ENDPOINT, request);
            }
            catch (Exception ex) {
                Contexts.responseError(request.getCorrelationId(), ex);
            }
        } else {
            try {
                final Context ctx = Contexts.lookup(request.getCorrelationId());
                final Function<?, ?> op = serviceOperations.get(request.getClass());
                Timers.loggingWrapper(new Callable(){

                    public Object call() throws Exception {
                        if (StackConfiguration.ASYNC_INTERNAL_OPERATIONS.booleanValue()) {
                            Threads.enqueue(Empyrean.class, ServiceOperations.class, new Callable<Boolean>(){

                                @Override
                                public Boolean call() {
                                    ServiceOperations.executeOperation(request, ctx, op);
                                    return Boolean.TRUE;
                                }
                            });
                        } else {
                            ServiceOperations.executeOperation(request, ctx, op);
                        }
                        return null;
                    }

                    public String toString() {
                        return super.toString();
                    }
                }).call();
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                Contexts.responseError(request.getCorrelationId(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <I extends BaseMessage, O extends BaseMessage> void executeOperation(I request, Context ctx, Function<I, O> op) {
        Contexts.threadLocal(ctx);
        try {
            BaseMessage reply = (BaseMessage)op.apply(request);
            Contexts.response(reply);
        }
        catch (Exception ex) {
            LOG.debug((Object)ex);
            LOG.trace((Object)ex, (Throwable)ex);
            Contexts.responseError(request.getCorrelationId(), ex);
        }
        finally {
            Contexts.removeThreadLocal();
        }
    }

    public static class ServiceOperationDiscovery
    extends ServiceJarDiscovery {
        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (Ats.from(candidate).has(ServiceOperation.class) && Function.class.isAssignableFrom(candidate)) {
                ServiceOperation opInfo = Ats.from(candidate).get(ServiceOperation.class);
                Function op = (Function)Classes.newInstance(candidate, new Object[0]);
                List<Class> msgTypes = Classes.genericsToClasses(op);
                LOG.info((Object)("Registered @ServiceOperation:       " + msgTypes.get(0).getSimpleName() + "," + msgTypes.get(1).getSimpleName() + " => " + candidate));
                serviceOperations.put(msgTypes.get(0), op);
                return true;
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 0.3;
        }
    }
}

