/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.EphemeralConfiguration;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceStatusDetail;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.EventClass;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;

public class ServiceConfigurations {
    static Logger LOG = Logger.getLogger(ServiceConfigurations.class);

    public static <T extends ServiceConfiguration> List<ServiceConfiguration> list() throws PersistenceException {
        Predicate alwaysTrue = Predicates.alwaysTrue();
        return Lists.newArrayList(ServiceConfigurations.filter(alwaysTrue));
    }

    public static <T extends ServiceConfiguration> Iterable<ServiceConfiguration> filter(Predicate<T> pred) throws PersistenceException {
        ArrayList configs = Lists.newArrayList();
        for (ComponentId compId : ComponentIds.list()) {
            Iterables.addAll((Collection)configs, ServiceConfigurations.filter(compId.getClass(), pred));
        }
        return configs;
    }

    public static Function<ServiceConfiguration, ServiceStatusType> asServiceStatus() {
        return ServiceConfigurations.asServiceStatus(false, false);
    }

    public static Function<ServiceConfiguration, ServiceStatusType> asServiceStatus(final boolean showEvents, final boolean showEventStacks) {
        return new Function<ServiceConfiguration, ServiceStatusType>(){

            public ServiceStatusType apply(final ServiceConfiguration config) {
                return new ServiceStatusType(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.setServiceId(TypeMappers.transform(config, ServiceId.class));
                        this.setLocalEpoch(Topology.epoch());
                        try {
                            this.setLocalState(config.lookupState().toString());
                        }
                        catch (Exception ex) {
                            this.setLocalState("n/a: " + ex.getMessage());
                        }
                        if (showEvents) {
                            this.getStatusDetails().addAll(Collections2.transform(Faults.lookup(config), TypeMappers.lookup(Faults.CheckException.class, ServiceStatusDetail.class)));
                            if (!showEventStacks) {
                                for (ServiceStatusDetail a : this.getStatusDetails()) {
                                    a.setStackTrace("");
                                }
                            }
                        }
                    }
                };
            }
        };
    }

    public static ServiceConfiguration createEphemeral(ComponentId compId, String partition, String name, URI remoteUri) {
        return new EphemeralConfiguration(compId, partition, name, remoteUri);
    }

    public static ServiceConfiguration createEphemeral(ComponentId compId) {
        return ServiceConfigurations.createEphemeral(compId, Internets.localHostInetAddress());
    }

    public static ServiceConfiguration createEphemeral(ComponentId compId, InetAddress host) {
        return new EphemeralConfiguration(compId, compId.getPartition(), host.getHostAddress(), ServiceUris.remote(compId, host, new String[0]));
    }

    public static ServiceConfiguration createEphemeral(Component component, InetAddress host) {
        return ServiceConfigurations.createEphemeral(component.getComponentId(), host);
    }

    public static ServiceConfiguration createBogus(Class<? extends ComponentId> compIdClass, Class<?> ownerType) {
        ComponentId compId = ComponentIds.lookup(compIdClass);
        return new EphemeralConfiguration(compId, compId.getPartition(), ownerType.getCanonicalName(), ServiceUris.internal(compId, Internets.localHostInetAddress(), ownerType.getSimpleName()));
    }

    public static ServiceConfiguration createBogus(ServiceConfiguration serviceConfiguration, Class<?> ownerType) {
        ComponentId compId = serviceConfiguration.getComponentId();
        return new EphemeralConfiguration(compId, compId.getPartition(), ownerType.getCanonicalName() + "-" + serviceConfiguration.getHostName() + "-" + serviceConfiguration.getName(), ServiceUris.internal(compId, Internets.localHostInetAddress(), ownerType.getSimpleName()));
    }

    public static <T extends ServiceConfiguration, C extends ComponentId> Iterable<T> filter(Class<C> type, Predicate<T> pred) throws PersistenceException {
        List<Class<C>> list = ServiceConfigurations.list(type);
        return Iterables.filter(list, pred);
    }

    public static <T extends ServiceConfiguration, C extends ComponentId> List<T> list(Class<C> type) throws PersistenceException {
        if (!ComponentId.class.isAssignableFrom(type)) {
            throw new PersistenceException("Unknown configuration type passed: " + type.getCanonicalName());
        }
        Object example = ServiceBuilders.lookup(type).newInstance();
        return ServiceConfigurations.list(example);
    }

    public static <T extends ServiceConfiguration, C extends ComponentId> List<T> listPartition(Class<C> type, String partition) throws PersistenceException, NoSuchElementException {
        if (!ComponentId.class.isAssignableFrom(type)) {
            throw new PersistenceException("Unknown configuration type passed: " + type.getCanonicalName());
        }
        Object example = ServiceBuilders.lookup(type).newInstance();
        example.setPartition(partition);
        return ServiceConfigurations.list(example);
    }

    public static <T extends ServiceConfiguration> T lookupByName(String name) {
        for (ComponentId c : ComponentIds.list()) {
            Object example = ServiceBuilders.lookup(c.getClass()).newInstance();
            example.setName(name);
            try {
                return ServiceConfigurations.lookup(example);
            }
            catch (Exception exception) {
            }
        }
        throw new NoSuchElementException("Failed to lookup any registered component with the name: " + name);
    }

    public static <T extends ServiceConfiguration, C extends ComponentId> T lookupByName(Class<C> type, String name) {
        if (!ComponentId.class.isAssignableFrom(type)) {
            throw new PersistenceException("Unknown configuration type passed: " + type.getCanonicalName());
        }
        Object example = ServiceBuilders.lookup(type).newInstance();
        example.setName(name);
        return ServiceConfigurations.lookup(example);
    }

    public static <T extends ServiceConfiguration, C extends ComponentId> T lookupByHost(Class<C> type, String host) {
        if (!ComponentId.class.isAssignableFrom(type)) {
            throw new PersistenceException("Unknown configuration type passed: " + type.getCanonicalName());
        }
        Object example = ServiceBuilders.lookup(type).newInstance();
        example.setHostName(host);
        return ServiceConfigurations.lookup(example);
    }

    public static <T extends ServiceConfiguration, C extends ComponentId> T lookupByAliasHost(Class<C> type, String host) {
        if (!ComponentId.class.isAssignableFrom(type)) {
            throw new PersistenceException("Unknown configuration type passed: " + type.getCanonicalName());
        }
        Object example = ServiceBuilders.lookup(type).newInstance();
        example.setHostName(host);
        return ServiceConfigurations.lookup(example);
    }

    public static <T extends ServiceConfiguration> List<T> list(T type) {
        return DatabaseProvider.INSTANCE.list(type);
    }

    public static <T extends ServiceConfiguration> T store(T t) {
        return DatabaseProvider.INSTANCE.store(t);
    }

    public static <T extends ServiceConfiguration> T remove(T t) {
        return DatabaseProvider.INSTANCE.remove(t);
    }

    public static <T extends ServiceConfiguration> T lookup(T type) {
        return DatabaseProvider.INSTANCE.lookup(type);
    }

    static void update(ServiceConfiguration destination, ServiceConfiguration source) {
        ServiceConfigurations.update(destination, source.getHostName(), source.getPort());
    }

    static void update(ServiceConfiguration configuration, String host, Integer port) {
        configuration.setHostName(host);
        configuration.setPort(port);
    }

    public static final <T extends ServiceConfiguration> Predicate<T> filterEnabled() {
        return EnabledServiceConfiguration.INSTANCE;
    }

    public static Predicate<ServiceConfiguration> filterHostLocal() {
        return ServiceIsHostLocal.INSTANCE;
    }

    public static Predicate<ServiceConfiguration> filterVmLocal() {
        return ServiceIsVmLocal.INSTANCE;
    }

    public static Predicate<ServiceConfiguration> filterByPartition(final Partition partition) {
        return new Predicate<ServiceConfiguration>(){

            public boolean apply(ServiceConfiguration arg0) {
                return partition.getName().equals(arg0.getPartition()) && Component.State.ENABLED.equals(arg0.lookupState());
            }
        };
    }

    @TypeMapper
    public static enum CheckExceptionRecordMapper implements Function<Faults.CheckException, ServiceStatusDetail>
    {
        INSTANCE;


        public ServiceStatusDetail apply(final Faults.CheckException input) {
            String checkName;
            HasFullName config;
            block5: {
                config = null;
                String serviceFullName = Strings.nullToEmpty((String)input.getServiceFullName());
                checkName = Strings.nullToEmpty((String)input.getServiceName());
                try {
                    config = (HasFullName)ServiceConfigurations.lookupByName(checkName);
                    if (!serviceFullName.equals(config.getFullName().toString())) {
                        throw Exceptions.toUndeclared((String)"Mismatched service fullnames, do full component service search", (Throwable[])new Throwable[0]);
                    }
                }
                catch (RuntimeException e) {
                    block2: for (Component c : Components.list()) {
                        for (ServiceConfiguration s : c.services()) {
                            if (!serviceFullName.equals(s.getFullName().toString())) continue;
                            config = s;
                            checkName = s.getName();
                            continue block2;
                        }
                    }
                    if (config != null) break block5;
                    throw e;
                }
            }
            String serviceName = checkName;
            HasFullName finalConfig = config;
            return new ServiceStatusDetail((ServiceConfiguration)finalConfig, serviceName){
                final /* synthetic */ ServiceConfiguration val$finalConfig;
                final /* synthetic */ String val$serviceName;
                {
                    this.val$finalConfig = serviceConfiguration;
                    this.val$serviceName = string;
                    this.setSeverity(input.getSeverity().toString());
                    this.setUuid(input.getCorrelationId());
                    this.setTimestamp(input.getTimestamp().toString());
                    this.setMessage(input.getMessage() != null ? input.getMessage() : "No summary information available.");
                    this.setStackTrace(input.getStackString() != null ? input.getStackString() : Exceptions.string(new RuntimeException("Error while mapping service event record:  No stack information available")));
                    this.setServiceFullName(this.val$finalConfig.getFullName().toString());
                    this.setServiceHost(this.val$finalConfig.getHostName());
                    this.setServiceName(this.val$serviceName);
                }
            };
        }
    }

    static enum EnabledServiceConfiguration implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration arg0) {
            return Component.State.ENABLED.equals(arg0.lookupState());
        }
    }

    static enum ServiceIsVmLocal implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration input) {
            return input != null && input.isVmLocal() != false;
        }
    }

    static enum ServiceIsHostLocal implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration input) {
            return Hosts.isServiceLocal(input);
        }
    }

    @TypeMapper
    public static enum ServiceConfigurationToServiceId implements Function<ServiceConfiguration, ServiceId>
    {
        INSTANCE;

        private static final Function<InetAddress, Cidr> cidrLookup;

        public ServiceId apply(final ServiceConfiguration config) {
            return new ServiceId(){
                private static final long serialVersionUID = 1L;
                {
                    this.setPartition(config.getPartition());
                    this.setName(config.getName());
                    this.setType(config.getComponentId().name());
                    this.setFullName(config.getFullName().toString());
                    if (config.isVmLocal().booleanValue()) {
                        this.setUri(ServiceUris.remote(config.getComponentId(), ServiceConfigurationToServiceId.maphost(Internets.localHostInetAddress()), new String[0]).toASCIIString());
                    } else {
                        this.setUri(ServiceUris.remote(config.getComponentId(), ServiceConfigurationToServiceId.maphost(config.getInetAddress()), config.getPort(), new String[0]).toASCIIString());
                    }
                }
            };
        }

        private static InetAddress maphost(InetAddress hostAddress) {
            InetAddress result = hostAddress;
            try {
                Host host;
                Cidr cidr;
                SocketAddress address = Contexts.lookup().getChannel().getLocalAddress();
                if (address instanceof InetSocketAddress && !(cidr = (Cidr)cidrLookup.apply((Object)((InetSocketAddress)address).getAddress())).apply(result) && (host = Hosts.lookup(hostAddress)) != null) {
                    result = (InetAddress)Iterables.tryFind(host.getHostAddresses(), (Predicate)cidr).or((Object)result);
                }
            }
            catch (IllegalContextAccessException illegalContextAccessException) {
                // empty catch block
            }
            return result;
        }

        static {
            cidrLookup = CacheBuilder.newBuilder().maximumSize(64L).expireAfterWrite(1L, TimeUnit.MINUTES).build(CacheLoader.from((Function)Functions.compose(CollectionUtils.optionalOr(Cidr.of(0, 0)), Internets.interfaceCidr())));
        }
    }

    @TypeMapper
    public static enum ServiceIdToServiceConfiguration implements Function<ServiceId, ServiceConfiguration>
    {
        INSTANCE;


        public ServiceConfiguration apply(ServiceId arg0) {
            Component comp = null;
            try {
                comp = Components.lookup(arg0.getType());
                try {
                    return comp.lookup(arg0.getName());
                }
                catch (NoSuchElementException ex1) {
                    Object builder = ServiceBuilders.lookup(comp.getComponentId());
                    try {
                        URI uri = new URI(arg0.getUri());
                        Object config = builder.newInstance(arg0.getPartition(), arg0.getName(), uri.getHost(), uri.getPort());
                        comp.setup((ServiceConfiguration)config);
                        return config;
                    }
                    catch (URISyntaxException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        throw Exceptions.toUndeclared(ex);
                    }
                }
            }
            catch (NoSuchElementException ex2) {
                ComponentId compId = ComponentIds.createEphemeral(arg0.getType());
                try {
                    comp = Components.create(compId);
                    return comp.lookup(arg0.getName());
                }
                catch (Exception ex) {
                    try {
                        return ServiceConfigurations.createEphemeral(compId, arg0.getPartition(), arg0.getName(), new URI(arg0.getUri()));
                    }
                    catch (URISyntaxException ex1) {
                        LOG.error((Object)ex1);
                        throw Exceptions.toUndeclared(ex1);
                    }
                }
            }
        }
    }

    @TypeMapper
    public static enum ServiceIdToServiceStatus implements Function<ServiceId, ServiceStatusType>
    {
        INSTANCE;

        private final Function<ServiceId, ServiceStatusType> transform = Functions.compose((Function)ServiceConfigurationToStatus.INSTANCE, (Function)ServiceIdToServiceConfiguration.INSTANCE);

        public ServiceStatusType apply(ServiceId input) {
            return (ServiceStatusType)this.transform.apply((Object)input);
        }
    }

    @TypeMapper
    static enum ServiceConfigurationToStatus implements Function<ServiceConfiguration, ServiceStatusType>
    {
        INSTANCE;


        public ServiceStatusType apply(final ServiceConfiguration config) {
            return new ServiceStatusType(){
                {
                    this.setServiceId(TypeMappers.transform(config, ServiceId.class));
                    this.setLocalEpoch(Topology.epoch());
                    if (config.isVmLocal().booleanValue() && Faults.isFailstop()) {
                        this.setLocalState(Component.State.NOTREADY.name());
                    } else {
                        try {
                            this.setLocalState(config.lookupState().toString());
                        }
                        catch (Exception ex) {
                            this.setLocalState("n/a: " + ex.getMessage());
                        }
                    }
                    this.getStatusDetails().addAll(Collections2.transform(Faults.lookup(config), TypeMappers.lookup(Faults.CheckException.class, ServiceStatusDetail.class)));
                    for (ServiceStatusDetail a : this.getStatusDetails()) {
                        a.setStackTrace("");
                    }
                }
            };
        }
    }

    private static enum DatabaseProvider {
        INSTANCE;


        public <T extends ServiceConfiguration> List<T> list(T example) {
            EntityTransaction db = Entities.get(example.getClass());
            try {
                List<T> componentList = Entities.query(example);
                db.commit();
                return componentList;
            }
            catch (PersistenceException ex) {
                LOG.debug((Object)ex);
                db.rollback();
                throw ex;
            }
            catch (Throwable ex) {
                LOG.debug((Object)ex);
                db.rollback();
                throw new PersistenceException("Service configuration lookup failed for: " + LogUtil.dumpObject(example), ex);
            }
        }

        public <T extends ServiceConfiguration> T lookup(T example) {
            EntityTransaction db = Entities.get(example);
            T existingName = null;
            try {
                existingName = Entities.uniqueResult(example);
                db.commit();
                return existingName;
            }
            catch (NoSuchElementException ex) {
                db.rollback();
                throw ex;
            }
            catch (PersistenceException ex) {
                LOG.debug((Object)ex);
                db.rollback();
                throw ex;
            }
            catch (Throwable ex) {
                LOG.debug((Object)ex);
                db.rollback();
                throw new PersistenceException("Service configuration lookup failed for: " + LogUtil.dumpObject(example), ex);
            }
        }

        public <T extends ServiceConfiguration> T store(T config) {
            EntityTransaction db = Entities.get(config.getClass());
            try {
                config = Entities.mergeDirect(config);
                db.commit();
                EventRecord.here(ServiceConfigurations.class, EventClass.COMPONENT, EventType.COMPONENT_REGISTERED, config.toString()).info();
            }
            catch (PersistenceException ex) {
                LOG.debug((Object)ex);
                EventRecord.here(ServiceConfigurations.class, EventClass.COMPONENT, EventType.COMPONENT_REGISTERED, "FAILED", config.toString()).error();
                db.rollback();
                throw ex;
            }
            catch (Throwable ex) {
                LOG.debug((Object)ex);
                EventRecord.here(ServiceConfigurations.class, EventClass.COMPONENT, EventType.COMPONENT_REGISTERED, "FAILED", config.toString()).error();
                db.rollback();
                throw new PersistenceException("Service configuration storing failed for: " + LogUtil.dumpObject(config), ex);
            }
            return config;
        }

        public <T extends ServiceConfiguration> T remove(T config) {
            EntityTransaction db = Entities.get(config.getClass());
            try {
                ServiceConfiguration searchConfig = (ServiceConfiguration)config.getClass().newInstance();
                searchConfig.setName(config.getName());
                ServiceConfiguration exists = Entities.uniqueResult(searchConfig);
                Entities.delete(exists);
                db.commit();
                EventRecord.here(ServiceConfigurations.class, EventClass.COMPONENT, EventType.COMPONENT_DEREGISTERED, config.toString()).info();
            }
            catch (NoSuchElementException ex) {
                db.rollback();
            }
            catch (PersistenceException ex) {
                LOG.debug((Object)ex);
                EventRecord.here(ServiceConfigurations.class, EventClass.COMPONENT, EventType.COMPONENT_DEREGISTERED, "FAILED", config.toString()).error();
                db.rollback();
                throw ex;
            }
            catch (Throwable ex) {
                LOG.debug((Object)ex);
                EventRecord.here(ServiceConfigurations.class, EventClass.COMPONENT, EventType.COMPONENT_DEREGISTERED, "FAILED", config.toString()).error();
                db.rollback();
                throw new PersistenceException("Service configuration removal failed for: " + LogUtil.dumpObject(config), ex);
            }
            return config;
        }
    }
}

