/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.DummyServiceBuilder;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceBuilders {
    private static Logger LOG = Logger.getLogger(ServiceBuilders.class);
    private static Map<Class<? extends BaseMessage>, ServiceBuilder<? extends ServiceConfiguration>> builders = Maps.newConcurrentMap();
    private static Map<Class<? extends ComponentId>, ServiceBuilder<? extends ServiceConfiguration>> componentBuilders = Maps.newConcurrentMap();

    private static void addMessageBuilder(Class<? extends BaseMessage> c, ServiceBuilder b) {
        LOG.trace((Object)("Registered service builder for " + c.getSimpleName() + " -> " + b.getClass().getCanonicalName()));
        builders.put(c, b);
    }

    private static void addComponentBuilder(Class<? extends ComponentId> c, ServiceBuilder b) {
        LOG.trace((Object)("Registered service builder for " + c.getSimpleName() + " -> " + b.getClass().getCanonicalName()));
        componentBuilders.put(c, b);
    }

    public static ServiceBuilder<? extends ServiceConfiguration> handles(Class<? extends BaseMessage> handlesType) {
        return builders.get(handlesType);
    }

    public static <T extends ServiceBuilder<? extends ServiceConfiguration>> T lookup(ComponentId componentId) {
        try {
            return ServiceBuilders.lookup(componentId.getClass());
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static <T extends ServiceBuilder<? extends ServiceConfiguration>> T lookup(Class<? extends ComponentId> componentId) {
        if (!componentBuilders.containsKey(componentId)) {
            Component comp = Components.lookup(componentId);
            componentBuilders.put(componentId, new DummyServiceBuilder(comp.getComponentId()));
        }
        return (T)componentBuilders.get(componentId);
    }

    public static List<Class<? extends ComponentId>> listRegisterableComponents() {
        return Lists.newArrayList(componentBuilders.keySet());
    }

    public static class ServiceBuilderDiscovery
    extends ServiceJarDiscovery {
        @Override
        public Double getPriority() {
            return 0.2;
        }

        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (ServiceBuilder.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isInterface(candidate.getModifiers())) {
                RuntimeException ex;
                ServiceBuilder b = (ServiceBuilder)candidate.newInstance();
                Ats ats = Ats.from(candidate);
                if (!ats.has(ComponentPart.class)) {
                    ex = Exceptions.noSuchElement("@ComponentPart(Class<? extends ComponentId>) is missing: " + candidate, new Throwable[0]);
                    LOG.error((Object)ex.getMessage());
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                } else {
                    ComponentPart at = ats.get(ComponentPart.class);
                    ServiceBuilders.addComponentBuilder(at.value(), b);
                }
                if (!ats.has(Handles.class)) {
                    ex = Exceptions.noSuchElement("@Handles(Class<? extends BaseMessage>) is missing: " + candidate, new Throwable[0]);
                    LOG.error((Object)ex.getMessage());
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                } else {
                    for (Class<? extends BaseMessage> c : ats.get(Handles.class).value()) {
                        ServiceBuilders.addMessageBuilder(c, b);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

