/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.amazonaws.regions.Regions;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.dns.DnsResolvers;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

@ConfigurableClass(root="dns.spoof_regions", description="Options controlling DNS domain spoofing for AWS regions.")
public class RegionSpoofingResolver
implements DnsResolvers.DnsResolver {
    @ConfigurableField(description="Enable the spoofing resolver which allows for AWS DNS name emulation for instances.")
    public static Boolean enabled = Boolean.FALSE;
    @ConfigurableField(description="Enable spoofing of the default AWS DNS names, e.g., ec2.amazonaws.com would resolve to the ENABLED cloud controller.")
    public static Boolean SPOOF_AWS_DEFAULT_REGIONS = Boolean.FALSE;
    @ConfigurableField(description="Enable spoofing for the normal AWS regions, too. e.g., ec2.us-east-1.amazonaws.com would resolve to the ENABLED cloud controller.")
    public static Boolean SPOOF_AWS_REGIONS = Boolean.FALSE;
    @ConfigurableField(description="Internal region name. If set, the region name to expect as the second label in the DNS name. For example, to treat your Eucalyptus install like a region named 'eucalyptus', set this value to 'eucalyptus'.  Then, e.g., autoscaling.eucalyptus.amazonaws.com will resolve to the service address when using this DNS server.")
    public static String REGION_NAME = null;
    private static Logger LOG = Logger.getLogger(RegionSpoofingResolver.class);
    private static final Name awsDomain = Name.fromConstantString((String)"amazonaws.com.");
    private static final List<String> awsRegionNames = Lists.transform(Arrays.asList(Regions.values()), (Function)Functions.toStringFunction());

    @Override
    public boolean checkAccepts(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        if (!(Bootstrap.isOperational().booleanValue() && enabled.booleanValue() && DnsResolvers.RequestType.A.apply(query) && query.getName().subdomain(awsDomain))) {
            return false;
        }
        if (SPOOF_AWS_REGIONS.booleanValue()) {
            return true;
        }
        Name relativeName = query.getName().relativize(awsDomain);
        if (relativeName.labels() > 2) {
            return false;
        }
        if (relativeName.labels() == 1 && SPOOF_AWS_DEFAULT_REGIONS.booleanValue()) {
            return true;
        }
        if (relativeName.labels() == 2) {
            String regionLabel = query.getName().getLabelString(1);
            if (!SPOOF_AWS_REGIONS.booleanValue() && awsRegionNames.contains(regionLabel.replace("-", "_").toUpperCase())) {
                return false;
            }
            return REGION_NAME == null || REGION_NAME.equals(regionLabel);
        }
        return false;
    }

    @Override
    public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        Name name = query.getName();
        String label0 = name.getLabelString(0);
        String label1 = name.getLabelString(1);
        LOG.debug((Object)("Trying to spoof " + name + " aws-service=" + label0 + " region=" + label1 + " spoof=" + SPOOF_AWS_REGIONS + " region=" + REGION_NAME));
        if (!Strings.isNullOrEmpty((String)REGION_NAME) && !REGION_NAME.equals(label1)) {
            LOG.debug((Object)("Spoofing skipped mismatched Eucalyptus region name: " + name + " query-region=" + label1 + " region=" + REGION_NAME));
            throw new NoSuchElementException("Failed to lookup name: " + name);
        }
        LOG.debug((Object)("Spoofing proceeding for name: " + name + " aws-service=" + label0 + " region=" + label1));
        for (ComponentId compId : ComponentIds.list()) {
            if (!compId.getAwsServiceName().equals(label0)) continue;
            LOG.debug((Object)("Spoofing found component for name: " + name + " aws-service=" + label0 + " region=" + label1 + " component=" + compId.name()));
            ArrayList configs = Lists.newArrayList(Topology.enabledServices(compId.getClass()));
            Collections.shuffle(configs);
            ArrayList answers = Lists.newArrayList();
            for (ServiceConfiguration config : configs) {
                Record aRecord = DomainNameRecords.addressRecord(name, config.getInetAddress());
                answers.add(aRecord);
                LOG.debug((Object)("Spoofing found records for name: " + name + " config=" + config.getName() + " config-address=" + config.getInetAddress()));
            }
            return DnsResolvers.DnsResponse.forName(query.getName()).answer(answers);
        }
        throw new NoSuchElementException("Failed to lookup name: " + name);
    }
}

