/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Exceptions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class Partitions {
    static Logger LOG = Logger.getLogger(Partitions.class);
    private static String CLUSTER_KEY_FSTRING = "cc-%s";
    private static String NODE_KEY_FSTRING = "nc-%s";
    private static final LoadingCache<String, Partition> partitionMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Partition>(){

        public Partition load(String input) {
            try {
                Databases.awaitSynchronized();
                EntityTransaction db = Entities.get(Partition.class);
                Partition p = null;
                try {
                    p = Entities.uniqueResult(Partition.newInstanceNamed(input));
                    db.commit();
                    return p;
                }
                catch (NoSuchElementException ex) {
                    db.rollback();
                    throw ex;
                }
                catch (Exception ex) {
                    db.rollback();
                    throw Exceptions.toUndeclared(ex);
                }
            }
            catch (NoSuchElementException ex) {
                throw ex;
            }
            catch (Databases.DatabaseStateException ex) {
                Databases.awaitSynchronized();
                return this.load(input);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
        }
    });

    public static void maybeRemove(String partitionName) {
        LOG.error((Object)"Ignoring attempt for partition at the moment");
    }

    public static boolean exists(String partitionName) {
        EntityTransaction db = Entities.get(Partition.class);
        Partition p = null;
        try {
            p = Entities.uniqueResult(Partition.newInstanceNamed(partitionName));
            db.commit();
            return true;
        }
        catch (Exception ex) {
            db.rollback();
            return false;
        }
    }

    public static Partition lookupByName(String partitionName) {
        return (Partition)partitionMap.getUnchecked((Object)partitionName);
    }

    public static Partition lookup(ServiceConfiguration config) {
        try {
            if (config.getComponentId().isPartitioned() && config.getComponentId().isRegisterable()) {
                Partition p;
                try {
                    p = Partitions.lookupByName(config.getPartition());
                }
                catch (Exception ex) {
                    if (Exceptions.isCausedBy(ex, NoSuchElementException.class)) {
                        LOG.warn((Object)("Failed to lookup partition for " + config + ".  Generating new partition configuration.\nCaused by: " + Exceptions.causeString(ex)));
                        try {
                            p = Partitions.generatePartition(config);
                        }
                        catch (ServiceRegistrationException ex1) {
                            LOG.error((Object)ex1, (Throwable)ex1);
                            throw Exceptions.toUndeclared(ex1);
                        }
                    }
                    throw ex;
                }
                return p;
            }
            if (config.getComponentId().isPartitioned()) {
                return Partitions.lookupInternal(config);
            }
            return Partitions.lookupInternal(config);
        }
        catch (Databases.DatabaseStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.trace((Object)ex);
            return Partitions.lookupInternal(config);
        }
    }

    private static Partition generatePartition(ServiceConfiguration config) throws ServiceRegistrationException {
        X509Certificate nodeX509;
        KeyPair nodeKp;
        X509Certificate clusterX509;
        KeyPair clusterKp;
        File keyDir = SubDirectory.KEYS.getChildFile(config.getPartition());
        if (!keyDir.exists() && !keyDir.mkdir()) {
            throw new ServiceRegistrationException("Failed to create partition key directory: " + keyDir.getAbsolutePath());
        }
        try {
            clusterKp = Certs.generateKeyPair();
            clusterX509 = Certs.generateServiceCertificate(clusterKp, String.format(CLUSTER_KEY_FSTRING, config.getName()));
            nodeKp = Certs.generateKeyPair();
            nodeX509 = Certs.generateServiceCertificate(nodeKp, String.format(NODE_KEY_FSTRING, config.getName()));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new ServiceRegistrationException("Failed to generate credentials for partition: " + config, ex);
        }
        Partition partition = new Partition(config.getPartition(), clusterKp, clusterX509, nodeKp, nodeX509);
        EntityTransaction db = Entities.get(Partition.class);
        try {
            Entities.persist(partition);
            db.commit();
            return partition;
        }
        catch (Exception ex) {
            db.rollback();
            throw new ServiceRegistrationException("Failed to store partition credentials during registration: " + config, ex);
        }
    }

    public static boolean testPartitionCredentialsDirectory(String name) {
        File keyDir = SubDirectory.KEYS.getChildFile(name);
        if (!keyDir.exists()) {
            try {
                return keyDir.mkdir() && keyDir.canWrite();
            }
            catch (Exception e) {
                return false;
            }
        }
        return keyDir.canWrite();
    }

    public static Partition lookupInternal(ServiceConfiguration config) {
        ComponentId compId = config.getComponentId();
        if (compId.isRegisterable()) {
            throw new IllegalArgumentException("Provided compId is partitioned: " + compId.getFullName());
        }
        if (compId.isAlwaysLocal().booleanValue()) {
            Partition partition = new Partition();
            partition.getClass();
            return partition.new Partition.Fake(config.getHostName(), SystemCredentials.lookup(Empyrean.class).getKeyPair(), SystemCredentials.lookup(Empyrean.class).getCertificate());
        }
        if (compId.isCloudLocal().booleanValue()) {
            Partition partition = new Partition();
            partition.getClass();
            return partition.new Partition.Fake(config.getHostName(), SystemCredentials.lookup(Eucalyptus.class).getKeyPair(), SystemCredentials.lookup(Eucalyptus.class).getCertificate());
        }
        if (!compId.hasCredentials().booleanValue()) {
            Partition partition = new Partition();
            partition.getClass();
            return partition.new Partition.Fake(compId.getPartition(), SystemCredentials.lookup(Eucalyptus.class).getKeyPair(), SystemCredentials.lookup(Eucalyptus.class).getCertificate());
        }
        Partition partition = new Partition();
        partition.getClass();
        return partition.new Partition.Fake(compId.getPartition(), SystemCredentials.lookup(compId).getKeyPair(), SystemCredentials.lookup(compId).getCertificate());
    }

    public static List<Partition> list() {
        EntityTransaction db = Entities.get(Partition.class);
        try {
            List<Partition> entities = Entities.query(new Partition());
            db.commit();
            return entities;
        }
        catch (RuntimeException ex) {
            db.rollback();
            throw ex;
        }
    }
}

