/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.SystemIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.system.SubDirectory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_config")
@Table(name="config_partition")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Partition
extends AbstractPersistent
implements Comparable<Partition> {
    private static Logger LOG = Logger.getLogger(Partition.class);
    @Column(name="config_partition_name", unique=true)
    String name;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="config_partition_x509_certificate")
    private String pemCertificate;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="config_partition_node_x509_certificate")
    private String pemNodeCertificate;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="config_partition_kp")
    private String pemPrivateKey;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="config_partition_node_kp")
    private String pemNodePrivateKey;
    public static final String DEFAULT_NAME = "";
    public static final Partition DEFAULT = new Partition("");

    public Partition() {
    }

    private Partition(String name) {
        this.name = name;
    }

    public static Partition newInstanceNamed(String partitionName) {
        return new Partition(partitionName);
    }

    public Partition(String name, KeyPair keyPair, X509Certificate certificate, KeyPair nodeKeyPair, X509Certificate nodeCertificate) {
        this.name = name;
        this.pemCertificate = PEMFiles.fromCertificate(certificate);
        this.pemNodeCertificate = PEMFiles.fromCertificate(nodeCertificate);
        this.pemPrivateKey = PEMFiles.fromKeyPair(keyPair);
        this.pemNodePrivateKey = PEMFiles.fromKeyPair(nodeKeyPair);
    }

    private boolean hasNodeCertificate() {
        return this.getPemNodeCertificate() != null;
    }

    public X509Certificate getNodeCertificate() {
        return PEMFiles.toCertificate(this.getPemNodeCertificate());
    }

    private boolean hasCertificate() {
        return this.getPemCertificate() != null;
    }

    public X509Certificate getCertificate() {
        return PEMFiles.toCertificate(this.getPemCertificate());
    }

    public PrivateKey getNodePrivateKey() {
        return PEMFiles.toKeyPair(this.getPemNodePrivateKey()).getPrivate();
    }

    public PrivateKey getPrivateKey() {
        return PEMFiles.toKeyPair(this.getPemPrivateKey()).getPrivate();
    }

    @PrePersist
    void prepareKeyDirectory() {
        File keyDir = SubDirectory.KEYS.getChildFile(this.name);
        LOG.info((Object)("Creating key directory: " + keyDir.getAbsolutePath()));
        if (!keyDir.exists() && !keyDir.mkdir()) {
            throw new RuntimeException("Failed to create partition key directory: " + keyDir.getAbsolutePath());
        }
    }

    @Deprecated
    public void link(ServiceConfiguration config) {
        File keyLink = SubDirectory.KEYS.getChildFile(config.getName());
        if (!keyLink.exists()) {
            LOG.debug((Object)("Creating key directory link for " + config.getFullName() + " at " + keyLink.getAbsolutePath()));
            try {
                Groovyness.exec("ln -sf " + SubDirectory.KEYS.getChildFile(this.name).getAbsolutePath() + " " + keyLink.getAbsolutePath());
                try {
                    LOG.debug((Object)("Created key directory link: " + keyLink.getAbsolutePath() + " -> " + keyLink.getCanonicalPath()));
                }
                catch (IOException iOException) {
                }
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        } else {
            LOG.debug((Object)("Skipped creating key directory link for " + config.getFullName() + " because it already exists at " + keyLink.getAbsolutePath()));
        }
    }

    @Deprecated
    public void unlink(ServiceConfiguration config) {
        LOG.info((Object)("Removing key directory link for " + config));
        SubDirectory.KEYS.getChildFile(config.getName()).delete();
    }

    protected String getPemCertificate() {
        return this.pemCertificate;
    }

    protected void setPemCertificate(String clusterCertificate) {
        this.pemCertificate = clusterCertificate;
    }

    protected String getPemNodeCertificate() {
        return this.pemNodeCertificate;
    }

    protected void setPemNodeCertificate(String nodeCertificate) {
        this.pemNodeCertificate = nodeCertificate;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected String getPemPrivateKey() {
        return this.pemPrivateKey;
    }

    protected void setPemPrivateKey(String pemPrivateKey) {
        this.pemPrivateKey = pemPrivateKey;
    }

    protected String getPemNodePrivateKey() {
        return this.pemNodePrivateKey;
    }

    protected void setPemNodePrivateKey(String pemNodePrivateKey) {
        this.pemNodePrivateKey = pemNodePrivateKey;
    }

    @PostRemove
    private void removePartitionKeyFiles() {
        LOG.info((Object)String.format("Removing credentials for the partition=%s.", this.getName()));
        File keyDir = SubDirectory.KEYS.getChildFile(this.getName());
        if (keyDir.exists()) {
            for (File f : keyDir.listFiles()) {
                if (f.delete()) {
                    LOG.info((Object)("Removing cluster key file: " + f.getAbsolutePath()));
                    continue;
                }
                LOG.info((Object)("Failed to remove cluster key file: " + f.getAbsolutePath()));
            }
            if (keyDir.delete()) {
                LOG.info((Object)("Removing cluster key directory: " + keyDir.getAbsolutePath()));
            } else {
                LOG.info((Object)("Failed to remove cluster key directory: " + keyDir.getAbsolutePath()));
            }
        }
    }

    public void syncKeysToDisk() {
        this.writePartitionKeyFiles();
    }

    @PostUpdate
    @PostPersist
    private void writePartitionKeyFiles() {
        File keyDir = SubDirectory.KEYS.getChildFile(this.getName());
        if (!keyDir.exists() && !keyDir.mkdir()) {
            throw new RuntimeException("Failed to create directory for partition credentials: " + this);
        }
        X509Certificate systemX509 = SystemCredentials.lookup(Eucalyptus.class).getCertificate();
        OutputStreamWriter out = null;
        try {
            PEMFiles.write(keyDir.getAbsolutePath() + File.separator + "cluster-pk.pem", this.getPrivateKey());
            PEMFiles.write(keyDir.getAbsolutePath() + File.separator + "cluster-cert.pem", this.getCertificate());
            PEMFiles.write(keyDir.getAbsolutePath() + File.separator + "node-pk.pem", this.getNodePrivateKey());
            PEMFiles.write(keyDir.getAbsolutePath() + File.separator + "node-cert.pem", this.getNodeCertificate());
            PEMFiles.write(keyDir.getAbsolutePath() + File.separator + "cloud-cert.pem", systemX509);
            out = new FileWriter(keyDir.getAbsolutePath() + File.separator + "vtunpass");
            out.write(SystemIds.tunnelPassword());
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new RuntimeException("Failed to write partition credentials to disk: " + this, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Partition:name=").append(this.name).append(":cc-cert-serial=").append(!this.hasCertificate() ? DEFAULT_NAME : this.getCertificate().getSerialNumber()).append(":nc-cert-serial=").append(!this.hasNodeCertificate() ? DEFAULT_NAME : this.getNodeCertificate().getSerialNumber());
        return builder.toString();
    }

    @Override
    public int compareTo(Partition that) {
        return this.name.compareTo(that.name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Partition other = (Partition)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public class Fake
    extends Partition {
        public Fake(String name, KeyPair keyPair, X509Certificate certificate) {
            super(name, keyPair, certificate, keyPair, certificate);
        }
    }
}

