/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.fault.FaultBuilderImpl;
import com.eucalyptus.component.fault.FaultSubsystemManager;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.empyrean.ServiceStatusDetail;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Emails;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;

@ConfigurableClass(root="bootstrap.notifications", description="Parameters controlling the handling of service state notifications.")
public class Faults {
    private static Logger LOG = Logger.getLogger(Faults.class);
    @ConfigurableField(description="Email address where notifications are to be delivered.")
    public static String EMAIL_TO;
    @ConfigurableField(description="From email address used for notification delivery.")
    public static String EMAIL_FROM;
    @ConfigurableField(description="From email name used for notification delivery.")
    public static String EMAIL_FROM_NAME;
    @ConfigurableField(description="Email subject used for notification delivery.")
    public static final String EMAIL_SUBJECT_PREFIX = "[eucalyptus-notifications] ";
    @ConfigurableField(description="Interval (in seconds) during which a notification will be delayed to allow for batching events for delivery.")
    public static Integer BATCH_DELAY_SECONDS;
    @ConfigurableField(description="Send a system state digest periodically.")
    public static Boolean DIGEST;
    @ConfigurableField(description="If sending system state digests is set to true, then only send the digest when the system has failures to report.")
    public static Boolean DIGEST_ONLY_ON_ERRORS;
    @ConfigurableField(description="Period (in hours) with which a system state digest will be delivered.")
    public static Integer DIGEST_FREQUENCY_HOURS;
    @ConfigurableField(description="Period (in hours) with which a system state digest will be delivered.")
    public static Boolean INCLUDE_FAULT_STACK;
    private static final SetMultimap<ServiceConfiguration, FaultRecord> serviceExceptions;
    private static final BlockingQueue<FaultRecord> errorQueue;
    private static final ConcurrentMap<ServiceConfiguration, CheckException> failstopExceptions;
    private static final FaultSubsystemManager faultSubsystemManager;

    public static final boolean filter(ServiceConfiguration parent, Throwable ex, Predicate<Throwable> ... filters) {
        Predicate<Throwable> failureAction = filters != null && filters.length > 0 ? filters[0] : NoopErrorFilter.INSTANCE;
        if (ex instanceof CheckException) {
            for (CheckException checkEx : (CheckException)ex) {
                if (checkEx.getSeverity().ordinal() < Severity.ERROR.ordinal()) continue;
                try {
                    failureAction.apply((Object)ex);
                }
                catch (Exception ex1) {
                    Logs.extreme().error((Object)ex1, (Throwable)ex1);
                }
                return true;
            }
            return false;
        }
        try {
            failureAction.apply((Object)ex);
        }
        catch (Exception ex1) {
            Logs.extreme().error((Object)ex1, (Throwable)ex1);
        }
        return true;
    }

    public static final boolean filter(ServiceConfiguration parent, Throwable ex) {
        return Faults.filter(parent, ex, NoopErrorFilter.INSTANCE);
    }

    private static CheckException chain(ServiceConfiguration config, Severity severity, List<? extends Throwable> exs) {
        if (exs == null || exs.isEmpty()) {
            return new CheckException(config, Severity.TRACE, new NullPointerException("Faults.chain called w/ empty list: " + exs));
        }
        try {
            CheckException last = null;
            for (Throwable ex : Lists.reverse(exs)) {
                if (last != null && ex instanceof CheckException) {
                    last.other = (CheckException)ex;
                    continue;
                }
                if (last != null && !(ex instanceof CheckException)) {
                    last.other = new CheckException(config, severity, ex);
                    continue;
                }
                if (last == null && ex instanceof CheckException) {
                    last = (CheckException)ex;
                    continue;
                }
                last = new CheckException(config, severity, ex);
            }
            last = last != null ? last : new CheckException(config, Severity.TRACE, new NullPointerException("Faults.chain called w/ empty list: " + exs));
            return last;
        }
        catch (Exception ex) {
            LOG.error((Object)("Faults: error in processing previous error: " + ex));
            Logs.extreme().error((Object)ex, (Throwable)ex);
            return new CheckException(config, Severity.ERROR, ex);
        }
    }

    public static CheckException failure(ServiceConfiguration config, String ... messages) {
        return Faults.failure(config, new RuntimeException(Joiner.on((String)"\n").join(Arrays.asList(messages))));
    }

    public static CheckException failure(ServiceConfiguration config, Throwable ... exs) {
        return Faults.failure(config, Arrays.asList(exs));
    }

    public static CheckException failure(ServiceConfiguration config, List<? extends Throwable> exs) {
        return Faults.chain(config, Severity.ERROR, exs);
    }

    public static CheckException advisory(ServiceConfiguration config, List<? extends Throwable> exs) {
        return Faults.chain(config, Severity.INFO, exs);
    }

    public static CheckException advisory(ServiceConfiguration config, String ... messages) {
        return Faults.advisory(config, new RuntimeException(Joiner.on((String)"\n").join(Arrays.asList(messages))));
    }

    public static CheckException advisory(ServiceConfiguration config, Throwable ... exs) {
        return Faults.advisory(config, Arrays.asList(exs));
    }

    public static CheckException fatal(ServiceConfiguration config, List<? extends Throwable> exs) {
        return Faults.chain(config, Severity.FATAL, exs);
    }

    public static Function<ServiceStatusType, CheckException> transformToExceptions() {
        return StatusToCheckException.INSTANCE;
    }

    public static void flush(ServiceConfiguration config) {
        serviceExceptions.removeAll((Object)config);
    }

    public static Collection<CheckException> lookup(ServiceConfiguration config) {
        Collection records = Collections2.transform((Collection)serviceExceptions.get((Object)config), (Function)new Function<FaultRecord, CheckException>(){

            public CheckException apply(FaultRecord input) {
                return input.getError();
            }
        });
        if (records != null && !records.isEmpty()) {
            return Lists.newArrayList((Iterable)records);
        }
        return Lists.newArrayList();
    }

    public static void submit(ServiceConfiguration parent, TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> transitionRecord, CheckException errors) {
        FaultRecord record = new FaultRecord(parent, transitionRecord, errors);
        serviceExceptions.put((Object)parent, (Object)record);
        if (errors != null && BootstrapArgs.isCloudController().booleanValue() && Bootstrap.isFinished().booleanValue()) {
            errorQueue.offer(record);
        }
    }

    public static void flush() {
        failstopExceptions.clear();
    }

    public static void failstop(ServiceConfiguration key, CheckException checkEx) {
        for (CheckException ex : checkEx) {
            if (!Severity.FATAL.equals((Object)ex.getSeverity())) continue;
            LOG.warn((Object)("FAILSTOP: " + key.getFullName() + "=> " + checkEx.getMessage()));
            failstopExceptions.put(key, checkEx);
            return;
        }
    }

    public static boolean isFailstop() {
        return !failstopExceptions.isEmpty();
    }

    public static void init() {
        faultSubsystemManager.init();
    }

    public static FaultBuilder forComponent(Class<? extends ComponentId> componentIdClass) {
        return new FaultBuilderImpl(faultSubsystemManager, componentIdClass);
    }

    static {
        EMAIL_FROM = "notification@eucalyptus";
        EMAIL_FROM_NAME = "Eucalyptus Notifications";
        BATCH_DELAY_SECONDS = 60;
        DIGEST = Boolean.FALSE;
        DIGEST_ONLY_ON_ERRORS = Boolean.TRUE;
        DIGEST_FREQUENCY_HOURS = 24;
        INCLUDE_FAULT_STACK = Boolean.FALSE;
        serviceExceptions = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        errorQueue = new LinkedTransferQueue<FaultRecord>();
        failstopExceptions = Maps.newConcurrentMap();
        faultSubsystemManager = new FaultSubsystemManager();
    }

    public static interface FaultBuilder {
        public FaultBuilder havingId(int var1);

        public FaultBuilder withVar(String var1, String var2);

        public Callable<String> logOnFirstRun();

        public String log();
    }

    public static class FaultNotificationHandler
    implements EventListener<Hertz>,
    Callable<Boolean> {
        private static final AtomicBoolean ready = new AtomicBoolean(true);
        private static final AtomicLong lastDigest = new AtomicLong(System.currentTimeMillis());

        public static void register() {
            Listeners.register(Hertz.class, new FaultNotificationHandler());
        }

        @Override
        public void fireEvent(Hertz event) {
            if (Bootstrap.isOperational().booleanValue() && event.isAsserted(BATCH_DELAY_SECONDS.intValue()) && ready.compareAndSet(true, false)) {
                try {
                    Threads.enqueue(Eucalyptus.class, Faults.class, this);
                }
                catch (Exception ex) {
                    ready.set(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                FaultNotificationHandler.sendFaults();
                FaultNotificationHandler.sendDigest();
            }
            finally {
                ready.set(true);
            }
            return true;
        }

        private static void sendDigest() {
            if (Hosts.isCoordinator() && DIGEST.booleanValue()) {
                long lastTime = lastDigest.getAndSet(System.currentTimeMillis());
                if (lastDigest.get() - lastTime > (long)(DIGEST_FREQUENCY_HOURS * 60 * 60 * 1000)) {
                    Date digestDate = new Date(lastDigest.get());
                    if (!serviceExceptions.isEmpty() || !DIGEST_ONLY_ON_ERRORS.booleanValue()) {
                        LOG.debug((Object)("Fault notifications: preparing digest for " + digestDate + "."));
                        try {
                            String subject = "[eucalyptus-notifications]  system state for " + digestDate;
                            String result = (String)Groovyness.run(SubDirectory.SCRIPTS, "notifications_digest");
                            if (!Strings.isNullOrEmpty((String)result)) {
                                FaultNotificationHandler.dispatchEmail(subject, result);
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Fault notifications: rendering digest failed: " + ex.getMessage()));
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                        }
                    } else {
                        LOG.debug((Object)("Fault notifications: skipping digest for " + digestDate + "."));
                    }
                } else {
                    lastDigest.set(lastTime);
                }
            }
        }

        private static void sendFaults() {
            LOG.debug((Object)"Fault notifications: waking up to service error queue.");
            final ArrayList pendingFaults = Lists.newArrayList();
            errorQueue.drainTo(pendingFaults);
            if (pendingFaults.isEmpty()) {
                LOG.debug((Object)"Fault notifications: service error queue is empty... going back to sleep.");
            } else if (Hosts.isCoordinator()) {
                String subject = Faults.EMAIL_SUBJECT_PREFIX;
                ArrayList noStateChange = Lists.newArrayList();
                ArrayList stateChange = Lists.newArrayList();
                for (FaultRecord f : pendingFaults) {
                    TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> tr = f.getTransitionRecord();
                    if (tr.getRule().getFromState().equals(f.getFinalState())) {
                        noStateChange.add(f);
                        continue;
                    }
                    stateChange.add(f);
                    subject = subject + " " + f.getServiceConfiguration().getName() + "->" + f.getFinalState();
                }
                if (stateChange.isEmpty()) {
                    LOG.debug((Object)"Fault notifications: no state changes pending, discarding pending faults");
                } else {
                    try {
                        String result = (String)Groovyness.run(SubDirectory.SCRIPTS, "notifications", new HashMap(){
                            {
                                this.put("faults", pendingFaults);
                            }
                        });
                        if (!Strings.isNullOrEmpty((String)result)) {
                            FaultNotificationHandler.dispatchEmail(subject, result);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Fault notifications: rendering notification failed: " + ex.getMessage()));
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                }
            }
        }

        public static void dispatchEmail(String subject, String result) {
            LOG.debug((Object)("From: " + EMAIL_FROM_NAME + " <" + EMAIL_FROM + ">"));
            LOG.debug((Object)("To: " + EMAIL_TO));
            LOG.debug((Object)("Subject: " + subject));
            LOG.debug((Object)result);
            if (!Strings.isNullOrEmpty((String)EMAIL_TO)) {
                Emails.send(EMAIL_FROM, EMAIL_FROM_NAME, EMAIL_TO, subject, result);
            }
        }
    }

    private static class FaultRecord {
        private final ServiceConfiguration serviceConfiguration;
        private final TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> transitionRecord;
        private final CheckException error;
        private final Component.State finalState;

        private FaultRecord(ServiceConfiguration serviceConfiguration, TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> transitionRecord, CheckException error) {
            this.serviceConfiguration = serviceConfiguration;
            this.finalState = serviceConfiguration.lookupState();
            this.transitionRecord = transitionRecord;
            this.error = error;
        }

        public ServiceConfiguration getServiceConfiguration() {
            return this.serviceConfiguration;
        }

        public TransitionRecord<ServiceConfiguration, Component.State, Component.Transition> getTransitionRecord() {
            return this.transitionRecord;
        }

        public CheckException getError() {
            return this.error;
        }

        private Component.State getFinalState() {
            return this.finalState;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.serviceConfiguration, this.error.getMessage(), this.finalState});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FaultRecord that = (FaultRecord)obj;
            return Objects.equal((Object)this.serviceConfiguration.getFullName().toString(), (Object)that.serviceConfiguration.getFullName().toString()) && Objects.equal((Object)this.error.getMessage(), (Object)that.error.getMessage()) && Objects.equal((Object)this.finalState, (Object)that.finalState);
        }
    }

    static enum StatusToCheckException implements Function<ServiceStatusType, CheckException>
    {
        INSTANCE;


        public CheckException apply(ServiceStatusType input) {
            ArrayList exs = Lists.newArrayList();
            ServiceConfiguration config = TypeMappers.transform(input.getServiceId(), ServiceConfiguration.class);
            Component.State serviceState = Component.State.valueOf(input.getLocalState());
            Component.State localState = config.lookupState();
            if (Component.State.ENABLED.equals(localState) && !localState.equals(serviceState)) {
                exs.add(Faults.failure(config, new IllegalStateException("State mismatch: local state is " + localState + " and remote state is: " + serviceState)));
            }
            for (ServiceStatusDetail detail : input.getStatusDetails()) {
                CheckException ex = TypeMappers.transform(detail, CheckException.class);
                exs.add(ex);
            }
            if (exs.isEmpty()) {
                return new CheckException(config, Severity.DEBUG, new Exception(input.toString()));
            }
            return Faults.chain(config, Severity.ERROR, exs);
        }
    }

    @TypeMapper
    public static enum StatusDetailExceptionRecordMapper implements Function<ServiceStatusDetail, CheckException>
    {
        INSTANCE;


        public CheckException apply(ServiceStatusDetail input) {
            ServiceConfiguration config;
            block5: {
                config = null;
                String serviceFullName = Strings.nullToEmpty((String)input.getServiceFullName());
                try {
                    String serviceName = Strings.nullToEmpty((String)input.getServiceName());
                    config = (ServiceConfiguration)ServiceConfigurations.lookupByName(serviceName);
                }
                catch (RuntimeException e) {
                    block2: for (Component c : Components.list()) {
                        for (ServiceConfiguration s : c.services()) {
                            if (!serviceFullName.equals(s.getFullName().toString())) continue;
                            config = s;
                            continue block2;
                        }
                    }
                    if (config != null) break block5;
                    throw e;
                }
            }
            Severity severity = Severity.DEBUG;
            if (input.getSeverity() != null) {
                severity = Severity.valueOf(input.getSeverity());
            }
            CheckException ex = new CheckException(config, severity, new Exception(input.toString()), input.getUuid());
            ex.stackString = input.getStackTrace();
            return ex;
        }
    }

    public static enum Scope {
        SERVICE,
        HOST,
        NETWORK;

    }

    public static enum Severity implements Predicate<CheckException>
    {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        URGENT,
        FATAL;


        public boolean apply(CheckException input) {
            if (input == null) {
                return false;
            }
            for (CheckException ex : input) {
                if (!this.equals((Object)ex.getSeverity())) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Actions {
        STORE,
        LOGGING,
        DESCRIBE,
        UI,
        NOTIFY,
        ALERT;

    }

    @Entity
    @PersistenceContext(name="eucalyptus_faults")
    @Table(name="faults_records")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    public static class CheckException
    extends RuntimeException
    implements Iterable<CheckException> {
        @Id
        @GeneratedValue(generator="system-uuid")
        @GenericGenerator(name="system-uuid", strategy="uuid")
        @Column(name="id")
        String id;
        @Version
        @Column(name="version")
        Integer version;
        @Temporal(value=TemporalType.TIMESTAMP)
        @Column(name="creation_timestamp")
        Date creationTimestamp;
        @Temporal(value=TemporalType.TIMESTAMP)
        @Column(name="last_update_timestamp")
        Date lastUpdateTimestamp;
        @NaturalId
        @Column(name="metadata_perm_uuid", unique=true, updatable=false, nullable=false)
        private String naturalId;
        @Transient
        private static final long serialVersionUID = 1L;
        @Enumerated(value=EnumType.STRING)
        private final Severity severity;
        @Column(name="fault_service_name")
        private final String serviceName;
        @Column(name="fault_service_full_name")
        private final String serviceFullName;
        @Column(name="fault_timestamp")
        private final Date timestamp;
        @Column(name="fault_msg_correlation_id")
        private final String correlationId;
        @Column(name="fault_event_epoch")
        private final Integer eventEpoch;
        @Column(name="fault_service_state")
        private final Component.State eventState;
        @Column(name="fault_stack_trace")
        @Lob
        @Type(type="org.hibernate.type.StringClobType")
        private String stackString;
        @Transient
        private CheckException other;

        public CheckException() {
            this((String)null);
        }

        private CheckException(String serviceName) {
            this.serviceName = serviceName;
            this.serviceFullName = null;
            this.severity = null;
            this.timestamp = null;
            this.correlationId = null;
            this.eventEpoch = null;
            this.eventState = null;
            this.stackString = null;
        }

        CheckException(ServiceConfiguration config, Severity severity, Throwable cause) {
            this(config, severity, cause, null);
        }

        CheckException(ServiceConfiguration config, Severity severity, Throwable cause, String correlationId) {
            super(cause != null ? cause.getMessage() : Exceptions.causeString(cause));
            if (cause instanceof CheckException) {
                this.initCause(cause);
                this.setStackTrace(cause.getStackTrace());
            } else if (cause != null) {
                this.initCause(cause);
                this.fillInStackTrace();
            }
            this.severity = severity;
            this.serviceName = config.getName();
            this.serviceFullName = config.getFullName().toString();
            this.correlationId = correlationId == null ? UUID.randomUUID().toString() : correlationId;
            this.timestamp = new Date();
            this.eventState = config.lookupState();
            this.eventEpoch = Topology.epoch();
            this.stackString = Exceptions.string(this);
        }

        @PreUpdate
        @PrePersist
        public void updateTimeStamps() {
            this.lastUpdateTimestamp = new Date();
            if (this.creationTimestamp == null) {
                this.creationTimestamp = new Date();
            }
            if (this.naturalId == null) {
                this.naturalId = UUID.randomUUID().toString();
            }
        }

        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        public Iterator<CheckException> iterator() {
            return new Iterator<CheckException>(){
                CheckException next;
                {
                    this.next = CheckException.this;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public CheckException next() {
                    CheckException ret = this.next;
                    this.next = ret != null ? ret.other : null;
                    return ret;
                }

                @Override
                public void remove() {
                    LOG.error((Object)"ServiceCheckException iterator does not support remove()");
                }
            };
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public int getEventEpoch() {
            return this.eventEpoch;
        }

        public Component.State getEventState() {
            return this.eventState;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public Date getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public void setCreationTimestamp(Date creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public Date getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public void setLastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public String getNaturalId() {
            return this.naturalId;
        }

        public void setNaturalId(String naturalId) {
            this.naturalId = naturalId;
        }

        private CheckException getOther() {
            return this.other;
        }

        private void setOther(CheckException other) {
            this.other = other;
        }

        public String getStackString() {
            return this.stackString;
        }

        public String getServiceFullName() {
            return this.serviceFullName;
        }
    }

    static enum NoopErrorFilter implements Predicate<Throwable>
    {
        INSTANCE;


        public boolean apply(Throwable input) {
            Logs.exhaust().error((Object)input, input);
            return true;
        }
    }
}

