/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.Mbeans;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class Components {
    private static Logger LOG = Logger.getLogger(Components.class);
    private static ConcurrentMap<Class<? extends ComponentId>, Component> components = Maps.newConcurrentMap();

    public static List<ComponentId> toIds(List<Component> components) {
        return Lists.transform(components, (Function)ToComponentId.INSTANCE);
    }

    public static Iterable<Component> whichCanLoad() {
        return Iterables.filter(Components.list(), (Predicate)Predicates.BOOTSTRAP_LOAD_LOCAL);
    }

    public static Iterable<Component> whichCanEnable() {
        return Iterables.filter(Components.list(), (Predicate)Predicates.BOOTSTRAP_ENABLE_LOCAL);
    }

    public static Iterable<Component> whichCanLoadOnRemoteHost() {
        return Iterables.filter(Components.list(), (Predicate)Predicates.BOOTSTRAP_LOAD_REMOTE);
    }

    public static Iterable<Component> whichCanEnabledOnRemoteHost() {
        return Iterables.filter(Components.list(), (Predicate)Predicates.BOOTSTRAP_ENABLE_REMOTE);
    }

    public static List<Component> whichAreEnabledLocally() {
        return Lists.newArrayList((Iterable)Iterables.filter(Components.list(), (Predicate)Predicates.ARE_ENABLED_LOCAL));
    }

    public static List<Component> whichAreEnabled() {
        return Lists.newArrayList((Iterable)Iterables.filter(Components.list(), (Predicate)Predicates.ARE_ENABLED));
    }

    public static List<Component> whichAreManyToOneEnabled() {
        return Lists.newArrayList((Iterable)Iterables.filter(Components.list(), (Predicate)Predicates.ARE_MANY_TO_ONE_AND_ENABLED));
    }

    public static List<Component> list() {
        return ImmutableList.copyOf(components.values());
    }

    public static List<Component> listLocal() {
        return Lists.newArrayList((Iterable)Iterables.filter(Components.list(), (Predicate)Predicates.ARE_LOCAL));
    }

    public static <T extends ComponentId> Component lookup(String componentIdName) throws NoSuchElementException {
        return Components.lookup(IdNameToId.INSTANCE.apply(componentIdName));
    }

    public static <T extends ComponentId> Component lookup(Class<T> componentId) throws NoSuchElementException {
        return Components.lookup(IdClassToId.INSTANCE.apply(componentId));
    }

    public static Component lookup(ComponentId componentId) throws NoSuchElementException {
        return IdToComponent.INSTANCE.apply(componentId);
    }

    public static boolean contains(ComponentId component) {
        return components.containsKey(component);
    }

    public static Component create(ComponentId id) throws ServiceRegistrationException {
        if (!components.containsKey(id)) {
            Component c = new Component(id);
            components.put(id.getClass(), c);
            EventRecord.here(Bootstrap.class, EventType.COMPONENT_REGISTERED, c.toString()).info();
            Mbeans.register(c);
            return c;
        }
        return (Component)components.get(id.getClass());
    }

    public static String describe(Component comp) {
        try {
            return (String)Components.componentToString().apply((Object)comp);
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            try {
                return "Error attempting to convert component to string: " + comp.toString() + " because of: " + ex.getMessage();
            }
            catch (Exception ex1) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                return "Error attempting to convert component to string: " + comp.getName() + " because of: " + ex.getMessage();
            }
        }
    }

    public static Function<ServiceConfiguration, ServiceConfiguration> updateConfiguration() {
        return UpdateComponentServiceConfiguration.INSTANCE;
    }

    public static Function<Component, String> componentToString() {
        return ToString.INSTANCE;
    }

    public static Component lookup(ServiceConfiguration config) {
        return Components.lookup(config.getComponentId());
    }

    private static enum Predicates implements Predicate<Component>
    {
        BOOTSTRAP_LOAD_LOCAL{

            public boolean apply(Component component) {
                ComponentId c = component.getComponentId();
                boolean cloudLocal = BootstrapArgs.isCloudController() != false && c.isCloudLocal() != false && !c.isRegisterable();
                boolean isCloudItself = BootstrapArgs.isCloudController() != false && Eucalyptus.class.equals(c.getClass());
                boolean alwaysLocal = c.isAlwaysLocal() != false && !c.isRegisterable();
                boolean isBootrapperItself = Empyrean.class.equals(c.getClass());
                return cloudLocal || alwaysLocal || isBootrapperItself || isCloudItself;
            }
        }
        ,
        BOOTSTRAP_ENABLE_LOCAL{

            public boolean apply(Component component) {
                ComponentId c = component.getComponentId();
                boolean cloudLocal = BootstrapArgs.isCloudController() != false && c.isCloudLocal() != false && !c.isRegisterable();
                boolean isCloudItself = BootstrapArgs.isCloudController() != false && Eucalyptus.class.equals(c.getClass());
                boolean alwaysLocal = c.isAlwaysLocal() != false && !c.isRegisterable();
                boolean isBootrapperItself = Empyrean.class.equals(c.getClass());
                return cloudLocal || alwaysLocal || isBootrapperItself || isCloudItself;
            }
        }
        ,
        BOOTSTRAP_LOAD_REMOTE{

            public boolean apply(Component component) {
                ComponentId c = component.getComponentId();
                boolean cloudLocal = c.isCloudLocal() != false && !c.isRegisterable();
                boolean isCloudItself = Eucalyptus.class.equals(c.getClass());
                boolean alwaysLocal = c.isAlwaysLocal() != false && !c.isRegisterable();
                boolean isBootrapperItself = Empyrean.class.equals(c.getClass());
                return cloudLocal || alwaysLocal || isBootrapperItself || isCloudItself;
            }
        }
        ,
        BOOTSTRAP_ENABLE_REMOTE{

            public boolean apply(Component component) {
                return BOOTSTRAP_LOAD_REMOTE.apply(component);
            }
        }
        ,
        ARE_ENABLED_LOCAL{

            public boolean apply(Component component) {
                ComponentId compId = component.getComponentId();
                boolean cloudLocal = BootstrapArgs.isCloudController() != false && compId.isCloudLocal() != false && !compId.isRegisterable();
                boolean alwaysLocal = compId.isAlwaysLocal();
                boolean runningLocal = component.isEnabledLocally();
                return cloudLocal || alwaysLocal || runningLocal;
            }
        }
        ,
        ARE_ENABLED{

            public boolean apply(Component c) {
                NavigableSet<ServiceConfiguration> services = c.services();
                return services.isEmpty() ? false : Component.State.ENABLED.equals(((ServiceConfiguration)services.first()).lookupState());
            }
        }
        ,
        ARE_LOCAL{

            public boolean apply(Component c) {
                return c.hasLocalService();
            }
        }
        ,
        ARE_MANY_TO_ONE_AND_ENABLED{

            public boolean apply(Component c) {
                NavigableSet<ServiceConfiguration> services = c.services();
                if (!services.isEmpty() && c.getComponentId().isManyToOnePartition().booleanValue()) {
                    for (ServiceConfiguration srv : services) {
                        if (!Component.State.ENABLED.equals(srv.lookupState())) continue;
                        return true;
                    }
                }
                return false;
            }
        };

    }

    static enum UpdateComponentServiceConfiguration implements Function<ServiceConfiguration, ServiceConfiguration>
    {
        INSTANCE;


        public ServiceConfiguration apply(ServiceConfiguration configuration) {
            Component component = Components.lookup(configuration.getComponentId());
            return component.updateService(configuration) ? component.lookup(configuration.getName()) : configuration;
        }
    }

    static enum ToString implements Function<Component, String>
    {
        INSTANCE;


        public String apply(Component comp) {
            StringBuilder buf = new StringBuilder();
            buf.append(LogUtil.header(comp.toString())).append("\n");
            for (Bootstrapper b : comp.getBootstrappers()) {
                buf.append("-> " + b.toString()).append("\n");
            }
            buf.append(LogUtil.subheader(comp.getName() + " services")).append("\n");
            for (ServiceConfiguration s : comp.services()) {
                try {
                    buf.append("->  Service:          ").append(s.getFullName()).append(" ").append(ServiceUris.remote(s, new String[0])).append("\n");
                    buf.append("|-> Service config:   ").append(s).append("\n");
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            return buf.toString();
        }
    }

    static enum ComponentToLocalService implements Function<Component, ServiceConfiguration>
    {
        INSTANCE;


        public ServiceConfiguration apply(Component input) {
            return input.getLocalServiceConfiguration();
        }
    }

    static enum IdToComponent implements Function<ComponentId, Component>
    {
        INSTANCE;


        public Component apply(ComponentId input) {
            if (!components.containsKey(input.getClass())) {
                try {
                    Components.create(input);
                    return Components.lookup(input);
                }
                catch (ServiceRegistrationException ex) {
                    throw new NoSuchElementException("Missing entry for component '" + input);
                }
            }
            return (Component)components.get(input.getClass());
        }
    }

    static enum IdClassToId implements Function<Class<? extends ComponentId>, ComponentId>
    {
        INSTANCE;


        public ComponentId apply(Class<? extends ComponentId> input) {
            return ComponentIds.lookup(input);
        }
    }

    static enum IdNameToId implements Function<String, ComponentId>
    {
        INSTANCE;


        public ComponentId apply(String input) {
            return ComponentIds.lookup(input);
        }
    }

    static enum ToComponentId implements Function<Component, ComponentId>
    {
        INSTANCE;


        public ComponentId apply(Component input) {
            return input.getComponentId();
        }
    }
}

