/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.groups.ServiceGroups;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.MoreExecutors;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;

public class ComponentRegistrationHandler {
    private static Logger LOG = Logger.getLogger(ComponentRegistrationHandler.class);

    public static ServiceConfiguration register(ComponentId compId, String partitionName, String name, String hostName, Integer port) throws ServiceRegistrationException {
        ServiceConfiguration returnConfig = null;
        if (!compId.isRegisterable()) {
            throw new ServiceRegistrationException("Failed to register component: " + compId.getFullName() + " does not support registration.");
        }
        Object builder = ServiceBuilders.lookup(compId);
        String partition = partitionName;
        if (!ServiceGroups.listMembership(compId).isEmpty()) {
            partition = partitionName;
        } else if (!compId.isPartitioned()) {
            partition = name;
        } else if (!compId.isPartitioned() && compId.isCloudLocal().booleanValue()) {
            partition = Components.lookup(Eucalyptus.class).getComponentId().name();
        } else if (partition == null) {
            LOG.error((Object)"BUG: Provided partition is null.  Using the service name as the partition name for the time being.");
            partition = name;
        }
        HostNamePredicate.get().apply((Object)hostName);
        LOG.info((Object)("Using builder: " + builder.getClass().getSimpleName() + " for: " + partition + "." + name + "@" + hostName + ":" + port));
        if (builder.checkUpdate(partition, name, hostName, port)) {
            Object configuration = ServiceConfigurations.lookupByName(builder.getComponentId().getClass(), name);
            ServiceConfigurations.update(configuration, hostName, port);
            ServiceConfigurations.store(configuration);
            Components.updateConfiguration().apply(configuration);
            LOG.info((Object)String.format("Updated registration information to: %s.%s@%s:%d", partition, name, hostName, port));
            return configuration;
        }
        if (!builder.checkAdd(partition, name, hostName, port)) {
            LOG.info((Object)("Returning existing registration information for: " + partition + "." + name + "@" + hostName + ":" + port));
            return ServiceConfigurations.lookupByName(builder.getComponentId().getClass(), name);
        }
        try {
            Object newComponent = builder.newInstance(partition, name, hostName, port);
            if (newComponent.getComponentId().isPartitioned()) {
                Partition part2 = Partitions.lookup(newComponent);
                part2.syncKeysToDisk();
                Partition p = Partitions.lookup(newComponent);
                Logs.extreme().info((Object)p.getCertificate());
                Logs.extreme().info((Object)p.getNodeCertificate());
            }
            returnConfig = (ServiceConfiguration)ServiceConfigurations.store(newComponent);
            try {
                Components.lookup(newComponent).setup((ServiceConfiguration)newComponent);
                Future<ServiceConfiguration> res = Topology.start(newComponent);
                JdkFutureAdapters.listenInPoolThread(res).addListener(new Runnable((ServiceConfiguration)newComponent, (ServiceBuilder)builder){
                    final /* synthetic */ ServiceConfiguration val$newComponent;
                    final /* synthetic */ ServiceBuilder val$builder;
                    {
                        this.val$newComponent = serviceConfiguration;
                        this.val$builder = serviceBuilder;
                    }

                    @Override
                    public void run() {
                        try {
                            Topology.enable(this.val$newComponent);
                        }
                        catch (Exception ex) {
                            LOG.info((Object)(this.val$builder.getClass().getSimpleName() + ": enable failed because of: " + ex.getMessage()));
                        }
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
            }
            catch (Exception ex) {
                LOG.info((Object)(builder.getClass().getSimpleName() + ": load failed because of: " + ex.getMessage()));
            }
            return returnConfig;
        }
        catch (Exception e) {
            e = Exceptions.filterStackTrace(e);
            LOG.info((Object)(builder.getClass().getSimpleName() + ": registration failed because of: " + e.getMessage()));
            LOG.error((Object)e, (Throwable)e);
            throw new ServiceRegistrationException(builder.getClass().getSimpleName() + ": registration failed with message: " + e.getMessage(), e);
        }
    }

    public static ServiceConfiguration deregister(ComponentId compId, String name) throws ServiceRegistrationException, EucalyptusCloudException {
        Object builder = ServiceBuilders.lookup(compId);
        LOG.info((Object)("Using builder: " + builder.getClass().getSimpleName()));
        boolean proceedOnError = false;
        try {
            if (!ComponentRegistrationHandler.checkRemove(builder, name)) {
                LOG.info((Object)(builder.getClass().getSimpleName() + ": checkRemove failed."));
                throw new ServiceRegistrationException(builder.getClass().getSimpleName() + ": checkRemove returned false.  " + "It is unsafe to currently deregister, please check the logs for additional information.");
            }
        }
        catch (NoSuchElementException ex) {
            LOG.info((Object)"Silently proceeding with deregister for non-existant configuration");
            proceedOnError = true;
        }
        catch (Exception e) {
            LOG.info((Object)(builder.getClass().getSimpleName() + ": checkRemove failed."));
            throw new ServiceRegistrationException(builder.getClass().getSimpleName() + ": checkRemove failed with message: " + e.getMessage(), e);
        }
        ServiceConfiguration conf = null;
        try {
            try {
                conf = (ServiceConfiguration)ServiceConfigurations.lookupByName(compId.getClass(), name);
            }
            catch (NoSuchElementException ex1) {
                conf = Components.lookup(compId.getClass()).lookup(name);
            }
            try {
                Topology.destroy(conf);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().debug((Object)ex, (Throwable)ex);
            }
            try {
                ServiceConfigurations.remove(conf);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().debug((Object)ex, (Throwable)ex);
            }
        }
        catch (Exception e) {
            if (proceedOnError) {
                LOG.info((Object)(builder.getClass().getSimpleName() + ": deregistration error, but proceeding since config has been removed: " + e.getMessage()));
                return conf;
            }
            LOG.info((Object)(builder.getClass().getSimpleName() + ": deregistration failed because of" + e.getMessage()));
            throw new ServiceRegistrationException(builder.getClass().getSimpleName() + ": deregistration failed because of: " + e.getMessage(), e);
        }
        return conf;
    }

    private static boolean checkRemove(ServiceBuilder builder, String name) {
        try {
            Object conf = builder.newInstance();
            conf.setName(name);
            ServiceConfigurations.lookup(conf);
            return true;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (PersistenceException e) {
            throw Exceptions.toUndeclared(e);
        }
        catch (Exception e) {
            Logs.extreme().error((Object)e, (Throwable)e);
            return true;
        }
    }

    static enum HostNamePredicate implements Predicate<String>
    {
        INSTANCE;

        public static Predicate<String> current;

        public boolean apply(String hostName) {
            try {
                InetAddress addr = InetAddress.getByName(hostName);
                return true;
            }
            catch (UnknownHostException ex1) {
                LOG.error((Object)("Invalid hostname: " + hostName + " failure: " + ex1.getMessage()), (Throwable)ex1);
                throw Exceptions.toUndeclared((String)("Registration failed because the hostname " + hostName + " is invalid: " + ex1.getMessage()), (Throwable[])new UnknownHostException[]{ex1});
            }
        }

        public static Predicate<String> get() {
            return current;
        }

        static {
            current = INSTANCE;
        }
    }
}

