/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.annotation.ComponentMessage;
import com.eucalyptus.system.Ats;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessageMarker;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ComponentMessages {
    private static Logger LOG = Logger.getLogger(ComponentMessages.class);
    private static final Map<Class<? extends BaseMessageMarker>, Class<? extends ComponentId>> compIdMap = Maps.newHashMap();

    public static Collection<Class<? extends BaseMessageMarker>> forComponent(ComponentId compId) {
        Class<?> compIdClass = compId.getClass();
        if (!compIdMap.containsValue(compIdClass)) {
            return Collections.emptyList();
        }
        return Maps.filterValues(compIdMap, (Predicate)Predicates.equalTo(compIdClass)).keySet();
    }

    public static <T extends BaseMessage> Class<? extends ComponentId> lookup(T msg) {
        Class msgType = Ats.inClassHierarchy(msg).findAncestor(ComponentMessage.class);
        if (!compIdMap.containsKey(msgType)) {
            throw new NoSuchElementException("No ComponentMessage with name: " + msgType);
        }
        return compIdMap.get(msgType);
    }

    public static void register(Class<? extends BaseMessageMarker> componentMsg) {
        Class<? extends ComponentId> componentIdClass = Ats.from(componentMsg).get(ComponentMessage.class).value();
        compIdMap.put(componentMsg, componentIdClass);
    }

    public static class ComponentMessageDiscovery
    extends ServiceJarDiscovery {
        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (BaseMessageMarker.class.isAssignableFrom(candidate) && candidate.getAnnotation(ComponentMessage.class) != null) {
                try {
                    ComponentMessages.register(candidate);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                return true;
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 0.0;
        }
    }
}

