/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.util.Classes;
import com.google.common.base.Predicate;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ComponentIds {
    private static Logger LOG = Logger.getLogger(ComponentIds.class);
    private static final ClassToInstanceMap<ComponentId> compIdMap = MutableClassToInstanceMap.create();
    private static final Map<String, Class<? extends ComponentId>> compIdName = Maps.newHashMap();

    public static List<Class<? extends ComponentId>> listTypes() {
        return Lists.newArrayList((Iterable)compIdMap.keySet());
    }

    public static List<ComponentId> list() {
        return Lists.newArrayList((Iterable)compIdMap.values());
    }

    public static final <T extends ComponentId> T lookup(Class<T> compIdClass) {
        if (!compIdMap.containsKey(compIdClass)) {
            ComponentId newInstance = (ComponentId)Classes.newInstance(compIdClass, new Object[0]);
            compIdMap.putInstance(compIdClass, (Object)newInstance);
            compIdName.put(newInstance.name(), compIdClass);
            LOG.debug((Object)("Registered ComponentId: " + compIdClass.toString()));
            return (T)newInstance;
        }
        return (T)((ComponentId)compIdMap.get(compIdClass));
    }

    public static final ComponentId lookup(String name) {
        if (!compIdName.containsKey(name.toLowerCase())) {
            throw new NoSuchElementException("No ComponentId with name: " + name.toLowerCase());
        }
        return (ComponentId)compIdMap.get(compIdName.get(name.toLowerCase()));
    }

    public static Predicate<ComponentId> manyToOne() {
        return ComponentIdPredicates.MANY_TO_ONE;
    }

    static ComponentId createEphemeral(String componentIdName) {
        return new ComponentId(componentIdName){};
    }

    private static enum ComponentIdPredicates implements Predicate<ComponentId>
    {
        MANY_TO_ONE{

            public boolean apply(@Nullable ComponentId componentId) {
                return componentId != null && componentId.isManyToOnePartition() != false;
            }
        };

    }
}

