/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.component.ComponentFullName;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.DummyServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.annotation.AdminService;
import com.eucalyptus.component.annotation.AwsServiceName;
import com.eucalyptus.component.annotation.ComponentDatabase;
import com.eucalyptus.component.annotation.DatabaseNamingStrategy;
import com.eucalyptus.component.annotation.FaultLogPrefix;
import com.eucalyptus.component.annotation.GenerateKeys;
import com.eucalyptus.component.annotation.InternalService;
import com.eucalyptus.component.annotation.Partition;
import com.eucalyptus.component.annotation.PolicyVendor;
import com.eucalyptus.component.annotation.PublicService;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.HasName;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.TransportDefinition;
import com.eucalyptus.ws.server.Pipelines;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

public abstract class ComponentId
implements HasName<ComponentId>,
HasFullName<ComponentId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(ComponentId.class);
    private String capitalizedName = this.getClass().getSimpleName();
    private final Ats ats = Ats.from(this);
    private final Partition partitionInfo = this.ats.get(Partition.class);
    private final GenerateKeys keyInfo = this.ats.has(GenerateKeys.class) ? this.ats.get(GenerateKeys.class) : null;
    private final String vendorName = !this.ats.has(PolicyVendor.class) ? "euca" : this.ats.get(PolicyVendor.class).value();
    private static final ConcurrentMap<String, Class<ChannelPipelineFactory>> clientPipelines = Maps.newConcurrentMap();
    private static final String defaultClientPipelineClass = "com.eucalyptus.ws.client.pipeline.InternalClientPipeline";

    protected ComponentId(String name) {
        this();
        this.capitalizedName = name == null ? this.getClass().getSimpleName() : name;
    }

    protected ComponentId() {
    }

    public List<? extends TransportDefinition> getTransports() {
        return Lists.newArrayList((Object[])new StackConfiguration.BasicTransport[]{StackConfiguration.BasicTransport.HTTP});
    }

    public String getServicePath(String ... pathParts) {
        return "/services/" + this.capitalizedName;
    }

    public String getInternalServicePath(String ... pathParts) {
        return "/internal/" + this.capitalizedName;
    }

    @Nullable
    public String getInternalNamespaceSuffix() {
        return null;
    }

    public Map<String, String> getServiceQueryParameters() {
        return Collections.emptyMap();
    }

    public final String getVendorName() {
        return this.vendorName;
    }

    public final String name() {
        return this.capitalizedName.toLowerCase();
    }

    @Override
    public final String getName() {
        return this.name();
    }

    @Override
    public final FullName getFullName() {
        return ComponentFullName.getInstance(ServiceConfigurations.createEphemeral(this), this.getPartition(), this.name());
    }

    @Override
    public String getPartition() {
        return this.partitionParent().name();
    }

    public final boolean isRootService() {
        return this.partitionParent().equals(this);
    }

    public final boolean isAncestor(Class<? extends ComponentId> compId) {
        if (this.isCloudLocal().booleanValue() && Eucalyptus.class.equals(compId)) {
            return true;
        }
        if (this.isAlwaysLocal().booleanValue() && Empyrean.class.equals(compId)) {
            return true;
        }
        for (ComponentId deps = this; deps != null && !deps.equals(deps.partitionParent()); deps = deps.partitionParent()) {
            if (!compId.equals(deps.getClass())) continue;
            return true;
        }
        return false;
    }

    final ComponentId partitionParent() {
        if (this.partitionInfo == null) {
            return this;
        }
        if (this.partitionInfo.value().length == 0) {
            return this;
        }
        if (Arrays.asList(this.partitionInfo.value()).contains(Empyrean.class)) {
            return Empyrean.INSTANCE;
        }
        if (Arrays.asList(this.partitionInfo.value()).contains(this.getClass())) {
            return this;
        }
        if (Arrays.asList(this.partitionInfo.value()).contains(Eucalyptus.class) && !this.partitionInfo.manyToOne()) {
            return Eucalyptus.INSTANCE;
        }
        return ComponentIds.lookup(this.partitionInfo.value()[0]);
    }

    public boolean isPartitioned() {
        return this.isRegisterable() && !this.equals(this.partitionParent());
    }

    public Boolean isCloudLocal() {
        return Eucalyptus.INSTANCE.isRelated().apply((Object)this);
    }

    public final Boolean isAlwaysLocal() {
        return Empyrean.INSTANCE.isRelated().apply((Object)this);
    }

    public Predicate<ComponentId> isRelated() {
        return new Predicate<ComponentId>(){

            public boolean apply(ComponentId input) {
                return ComponentId.this.equals(input) || input.partitionInfo != null && Arrays.asList(input.partitionInfo.value()).contains(ComponentId.this.getClass());
            }
        };
    }

    public Boolean hasCredentials() {
        return this.ats.has(GenerateKeys.class);
    }

    public ChannelPipelineFactory getClientPipeline() {
        ChannelPipelineFactory factory = null;
        for (Class c : Classes.ancestors(this)) {
            factory = Pipelines.lookup(this.getClass());
            if (factory == null) continue;
            return factory;
        }
        return ComponentId.helpGetClientPipeline(defaultClientPipelineClass);
    }

    protected static ChannelPipelineFactory helpGetClientPipeline(String fqName) {
        block8: {
            if (clientPipelines.containsKey(fqName)) {
                try {
                    return (ChannelPipelineFactory)((Class)clientPipelines.get(fqName)).newInstance();
                }
                catch (InstantiationException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    break block8;
                }
                catch (IllegalAccessException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    break block8;
                }
            }
            try {
                clientPipelines.putIfAbsent(fqName, ClassLoader.getSystemClassLoader().loadClass(fqName));
                return (ChannelPipelineFactory)((Class)clientPipelines.get(fqName)).newInstance();
            }
            catch (InstantiationException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline();
            }
        };
    }

    public final String getEntryPoint() {
        return this.capitalizedName + "RequestQueueEndpoint";
    }

    public final String getCapitalizedName() {
        return this.capitalizedName;
    }

    public final String getFaultLogPrefix() {
        if (Ats.from(this).has(FaultLogPrefix.class)) {
            String value = Ats.from(this).get(FaultLogPrefix.class).value();
            return value != null && !"".equals(value) ? value : this.name();
        }
        return Ats.from(Empyrean.class).get(FaultLogPrefix.class).value();
    }

    public Integer getPort() {
        return 8773;
    }

    public String getLocalEndpointName() {
        return String.format("vm://%sInternal", this.getClass().getSimpleName());
    }

    public URI getLocalEndpointUri() {
        URI uri = URI.create(this.getLocalEndpointName());
        try {
            uri.parseServerAuthority();
        }
        catch (URISyntaxException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return uri;
    }

    public String getServiceModelFileName() {
        return String.format("%s-model.xml", this.getName());
    }

    @Override
    public final int compareTo(ComponentId that) {
        return this.name().compareTo(that.name());
    }

    @Override
    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name() == null ? 0 : this.name().hashCode());
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentId other = (ComponentId)obj;
        return !(this.name() == null ? other.name() != null : !this.name().equals(other.name()));
    }

    public boolean runLimitedServices() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFullName()).append(" ");
        builder.append(this.name()).append(":");
        if (this.isPartitioned()) {
            builder.append("partitioned:");
        } else {
            builder.append("unpartitioned:");
        }
        if (this.isCloudLocal().booleanValue()) {
            builder.append("cloudLocal:");
        } else if (this.isAlwaysLocal().booleanValue()) {
            builder.append("alwaysLocal:");
        }
        return builder.toString();
    }

    public final boolean isInternal() {
        return this.ats.has(InternalService.class) || !this.isAdminService() || !this.isPublicService() || this.partitionParent().equals(Empyrean.INSTANCE) && !this.isRegisterable() || this.partitionParent().equals(Eucalyptus.INSTANCE) && !this.isRegisterable();
    }

    public boolean isPublicService() {
        return this.ats.has(PublicService.class);
    }

    public boolean isAdminService() {
        return this.ats.has(AdminService.class);
    }

    public boolean isImpersonationSupported() {
        return this.isPublicService();
    }

    public boolean isRegisterable() {
        return !(ServiceBuilders.lookup(this) instanceof DummyServiceBuilder);
    }

    public boolean isDistributedService() {
        return this.isRegisterable();
    }

    public Boolean isAvailableLocally() {
        return this.isAlwaysLocal() != false || this.isCloudLocal() != false && BootstrapArgs.isCloudController() != false || this.checkComponentParts();
    }

    @Deprecated
    public boolean isDnsSupported() {
        return true;
    }

    public String getAwsServiceName() {
        if (this.ats.has(AwsServiceName.class)) {
            return this.ats.get(AwsServiceName.class).value();
        }
        return "eucalyptus";
    }

    public DatabaseNamingStrategy getDatabaseNamingStrategy() {
        if (this.ats.has(ComponentDatabase.class)) {
            return this.ats.get(ComponentDatabase.class).namingStrategy();
        }
        return DatabaseNamingStrategy.Schema;
    }

    public Boolean isManyToOnePartition() {
        return this.ats.has(Partition.class) && this.ats.get(Partition.class).manyToOne();
    }

    private boolean checkComponentParts() {
        return true;
    }
}

