/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Joiner;
import org.hamcrest.Matchers;

public class ComponentFullName
implements FullName {
    public static final String VENDOR = "euca";
    private final ComponentId componentId;
    private final ComponentId realComponentId;
    private final String partition;
    private final String name;
    private final String qName;
    private final String authority;
    private final String relativeId;
    private static final String PREFIX = "arn:euca";

    ComponentFullName(ComponentId componentType, String partition, String name, String ... pathPartsArray) {
        Parameters.checkParam(componentType, Matchers.notNullValue());
        this.realComponentId = componentType;
        this.name = name != null ? name : "null";
        partition = partition != null ? partition : "null";
        boolean hasParentComponent = this.realComponentId.partitionParent() != null;
        ComponentId tempComponentId = Empyrean.INSTANCE;
        String tempPartition = "";
        if (hasParentComponent || this.realComponentId.isPartitioned()) {
            if (this.realComponentId.isCloudLocal().booleanValue()) {
                tempComponentId = Eucalyptus.INSTANCE;
            } else if (this.realComponentId.isAlwaysLocal().booleanValue()) {
                tempComponentId = Empyrean.INSTANCE;
            }
            tempPartition = partition;
        } else if (!hasParentComponent && !this.realComponentId.isPartitioned()) {
            tempComponentId = this.realComponentId;
            tempPartition = this.realComponentId.name();
        } else if (!this.realComponentId.isPartitioned() && hasParentComponent) {
            ComponentId parentId = this.realComponentId.partitionParent();
            if (parentId.getClass().equals(Eucalyptus.class)) {
                tempComponentId = Eucalyptus.INSTANCE;
                tempPartition = tempComponentId.name();
            } else {
                tempComponentId = Empyrean.INSTANCE;
                tempPartition = tempComponentId.name();
            }
        }
        this.componentId = tempComponentId;
        this.partition = tempPartition;
        String displayPartition = this.componentId.name().equals(this.partition) ? "" : this.partition;
        String displayCompType = this.realComponentId.equals(this.componentId) ? "" : this.realComponentId.name();
        this.authority = Joiner.on((String)":").join((Object)PREFIX, (Object)this.componentId.name(), new Object[]{displayPartition, displayCompType, this.name});
        this.relativeId = ("/" + Joiner.on((String)"/").join((Object[])pathPartsArray)).replaceAll("^//", "/");
        this.qName = this.authority + this.relativeId;
    }

    ComponentFullName(ServiceConfiguration config, String ... parts) {
        this(config.getComponentId(), config.getPartition(), config.getName(), parts);
    }

    @Override
    public final String getVendor() {
        return VENDOR;
    }

    @Override
    public final String getRegion() {
        return this.getPartition();
    }

    @Override
    public final String getNamespace() {
        return this.componentId.getName();
    }

    @Override
    public final String getAuthority() {
        return this.authority;
    }

    @Override
    public final String getRelativeId() {
        return this.relativeId;
    }

    @Override
    public final String getPartition() {
        return this.partition;
    }

    @Override
    public String toString() {
        return this.qName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ComponentFullName that = (ComponentFullName)obj;
        if (this.name == null ? that.name != null : !this.name.equals(that.name)) {
            return false;
        }
        return !(this.partition == null ? that.partition != null : !this.partition.equals(that.partition));
    }

    @Override
    public String getUniqueId() {
        return this.name;
    }

    public static FullName getInstance(ServiceConfiguration config, String ... parts) {
        return new ComponentFullName(config, parts);
    }
}

