/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.CanBootstrap;
import com.eucalyptus.component.BasicService;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.fsm.Automata;
import com.eucalyptus.util.fsm.OrderlyTransitionException;
import com.eucalyptus.util.fsm.StateMachine;
import com.eucalyptus.util.fsm.TransitionException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class Component
implements HasName<Component> {
    private static Logger LOG = Logger.getLogger(Component.class);
    public final ComponentId identity;
    private final ServiceRegistry serviceRegistry;
    private final ComponentBootstrapper bootstrapper;

    Component(ComponentId componentId) throws ServiceRegistrationException {
        this.identity = componentId;
        this.serviceRegistry = new ServiceRegistry();
        this.bootstrapper = new ComponentBootstrapper(this);
    }

    public ComponentId getComponentId() {
        return this.identity;
    }

    public State getState() {
        return this.hasLocalService() != false ? this.getLocalServiceConfiguration().lookupState() : State.PRIMORDIAL;
    }

    @Override
    public String getName() {
        return this.identity.name();
    }

    public ServiceBuilder<? extends ServiceConfiguration> getBuilder() {
        return ServiceBuilders.lookup(this.identity.getClass());
    }

    public NavigableSet<ServiceConfiguration> services() {
        return this.serviceRegistry.getServices();
    }

    public Boolean hasLocalService() {
        return this.serviceRegistry.hasLocalService();
    }

    public Boolean isEnabledLocally() {
        return this.serviceRegistry.hasLocalService() && State.ENABLED.equals(this.getLocalServiceConfiguration().lookupState());
    }

    public Boolean isRunningLocally() {
        return this.isEnabledLocally();
    }

    public CanBootstrap getBootstrapper() {
        return this.bootstrapper;
    }

    public ServiceConfiguration lookup(String name) {
        return this.serviceRegistry.getService(name);
    }

    public ServiceConfiguration initService() {
        if (!this.identity.isAvailableLocally().booleanValue()) {
            throw Exceptions.toUndeclared((String)("The component " + this.getName() + " is not being loaded automatically."), (Throwable[])new Throwable[0]);
        }
        return this.initRemoteService(Internets.localHostInetAddress());
    }

    public ServiceConfiguration initRemoteService(InetAddress addr) {
        ServiceConfiguration config = this.getBuilder().newInstance(this.getComponentId().getPartition(), addr.getHostAddress(), addr.getHostAddress(), this.getComponentId().getPort());
        BasicService ret = this.serviceRegistry.register(config);
        Logs.extreme().debug((Object)("Initializing remote service for host " + addr + " with configuration: " + config));
        return config;
    }

    void destroy(ServiceConfiguration configuration) throws ServiceRegistrationException {
        try {
            BasicService service = null;
            if (this.serviceRegistry.hasService(configuration)) {
                service = this.serviceRegistry.lookup(configuration);
            }
            try {
                EventRecord.caller(Component.class, EventType.COMPONENT_SERVICE_DESTROY, this.getName(), configuration.getFullName(), ServiceUris.remote(configuration, new String[0]).toASCIIString()).info();
                this.serviceRegistry.deregister(configuration);
            }
            catch (Exception ex) {
                throw new ServiceRegistrationException("Failed to destroy service: " + configuration + " because of: " + ex.getMessage(), ex);
            }
        }
        catch (NoSuchElementException ex) {
            throw new ServiceRegistrationException("Failed to find service corresponding to: " + configuration, ex);
        }
    }

    public void setup(ServiceConfiguration config) throws IllegalStateException {
        if ((config.isVmLocal().booleanValue() || config.isHostLocal().booleanValue()) && !this.serviceRegistry.hasLocalService()) {
            this.serviceRegistry.register(config);
        } else if (this.serviceRegistry.hasService(config)) {
            this.serviceRegistry.lookup(config);
        } else {
            this.serviceRegistry.register(config);
        }
    }

    public boolean hasService(ServiceConfiguration config) {
        return this.serviceRegistry.hasService(config);
    }

    public boolean updateService(ServiceConfiguration config) {
        if (this.serviceRegistry.hasService(config)) {
            ServiceConfiguration registeredConfig = this.serviceRegistry.lookup(config).getServiceConfiguration();
            ServiceConfigurations.update(registeredConfig, config);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("Component %s=%s service=%s\n", this.identity.name(), (this.identity.isAvailableLocally() != false ? "" : "not") + "available", this.serviceRegistry.hasLocalService() ? this.serviceRegistry.getLocalService() : "not-local");
    }

    @Override
    public int compareTo(Component that) {
        return this.getName().compareTo(that.getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        return !(this.identity == null ? other.identity != null : !this.identity.equals(other.identity));
    }

    public ServiceConfiguration getLocalServiceConfiguration() {
        return this.serviceRegistry.getLocalService().getServiceConfiguration();
    }

    public StateMachine<ServiceConfiguration, State, Transition> getStateMachine(ServiceConfiguration conf) {
        return this.serviceRegistry.lookup(conf).getStateMachine();
    }

    public void addBootstrapper(Bootstrapper bootstrapper) {
        this.bootstrapper.addBootstrapper(bootstrapper);
    }

    public boolean load() {
        return this.bootstrapper.load();
    }

    public boolean start() {
        return this.bootstrapper.start();
    }

    public boolean enable() {
        return this.bootstrapper.enable();
    }

    public boolean stop() {
        return this.bootstrapper.stop();
    }

    public void destroy() {
        this.bootstrapper.destroy();
    }

    public boolean disable() {
        return this.bootstrapper.disable();
    }

    public boolean check() {
        return this.bootstrapper.check();
    }

    public List<Bootstrapper> getBootstrappers() {
        return this.bootstrapper.getBootstrappers();
    }

    static class ComponentBootstrapper
    implements CanBootstrap {
        private final Multimap<Bootstrap.Stage, Bootstrapper> bootstrappers;
        private final Multimap<Bootstrap.Stage, Bootstrapper> disabledBootstrappers;
        private final Component component;

        ComponentBootstrapper(Component component) {
            this.component = component;
            ArrayListMultimap a = ArrayListMultimap.create();
            this.bootstrappers = Multimaps.synchronizedMultimap((Multimap)a);
            ArrayListMultimap b = ArrayListMultimap.create();
            this.disabledBootstrappers = Multimaps.synchronizedMultimap((Multimap)b);
        }

        public void addBootstrapper(Bootstrapper bootstrapper) {
            if (Bootstrap.Stage.PrivilegedConfiguration.equals((Object)bootstrapper.getBootstrapStage())) {
                EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_SKIPPED, "stage:" + bootstrapper.getBootstrapStage().toString(), this.component.getComponentId().name(), bootstrapper.getClass().getName(), "component=" + this.component.getComponentId().name()).exhaust();
            } else {
                EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_ADDED, "stage:" + bootstrapper.getBootstrapStage().toString(), this.component.getComponentId().name(), bootstrapper.getClass().getName(), "component=" + this.component.getComponentId().name()).exhaust();
                this.bootstrappers.put((Object)bootstrapper.getBootstrapStage(), (Object)bootstrapper);
            }
        }

        private void updateBootstrapDependencies() {
            Iterable currBootstrappers = Iterables.concat((Iterable)Lists.newArrayList((Iterable)this.bootstrappers.values()), (Iterable)Lists.newArrayList((Iterable)this.disabledBootstrappers.values()));
            this.bootstrappers.clear();
            this.disabledBootstrappers.clear();
            for (Bootstrapper bootstrapper : currBootstrappers) {
                try {
                    Bootstrap.Stage stage = bootstrapper.getBootstrapStage();
                    if (bootstrapper.checkLocal() && bootstrapper.checkRemote()) {
                        this.enableBootstrapper(stage, bootstrapper);
                        continue;
                    }
                    this.disableBootstrapper(stage, bootstrapper);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }

        private void enableBootstrapper(Bootstrap.Stage stage, Bootstrapper bootstrapper) {
            EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_MARK_ENABLED, "stage:", stage.toString(), this.component.getComponentId().name(), bootstrapper.getClass().getName(), "component=" + this.component.getComponentId().name()).exhaust();
            this.disabledBootstrappers.remove((Object)stage, (Object)bootstrapper);
            this.bootstrappers.put((Object)stage, (Object)bootstrapper);
        }

        private void disableBootstrapper(Bootstrap.Stage stage, Bootstrapper bootstrapper) {
            EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_MARK_DISABLED, "stage:" + stage.toString(), this.component.getComponentId().name(), bootstrapper.getClass().getName(), "component=" + this.component.getComponentId().name()).exhaust();
            this.bootstrappers.remove((Object)stage, (Object)bootstrapper);
            this.disabledBootstrappers.put((Object)stage, (Object)bootstrapper);
        }

        private boolean doTransition(EventType transition, Function<Bootstrapper, Boolean> checkedFunction) {
            return this.doTransition(transition, checkedFunction, (Function<Bootstrapper, Boolean>)Functions.forPredicate((Predicate)Predicates.alwaysTrue()));
        }

        private boolean doTransition(EventType transition, Function<Bootstrapper, Boolean> checkedFunction, Function<Bootstrapper, Boolean> rollbackFunction) {
            String name = transition.name().replaceAll(".*_", "").toLowerCase();
            ArrayList rollbackBootstrappers = Lists.newArrayList();
            this.updateBootstrapDependencies();
            for (Bootstrap.Stage s : Bootstrap.Stage.values()) {
                for (Bootstrapper b : Lists.newArrayList((Iterable)this.bootstrappers.get((Object)s))) {
                    EventRecord.here(this.component.getClass(), transition, this.component.getComponentId().name(), "stage", s.name(), b.getClass().getCanonicalName()).extreme();
                    TransitionException ex = null;
                    try {
                        if (((Boolean)checkedFunction.apply((Object)b)).booleanValue()) {
                            rollbackBootstrappers.add(b);
                        } else {
                            ex = new OrderlyTransitionException(b.getClass().getSimpleName() + "." + name + "( ): returned false, terminating bootstrap for component: " + this.component.getName());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                        Logs.extreme().error((Object)e, (Throwable)e);
                        ex = new TransitionException(b.getClass().getSimpleName() + "." + name + "( ): failed because of: " + e.getMessage() + ", terminating bootstrap for component: " + this.component.getName(), e);
                    }
                    if (ex == null) continue;
                    for (Bootstrapper rollback : Lists.reverse((List)rollbackBootstrappers)) {
                        try {
                            rollbackFunction.apply((Object)rollback);
                        }
                        catch (Exception ex1) {
                            LOG.error((Object)ex1);
                            Logs.extreme().error((Object)ex1, (Throwable)ex1);
                        }
                    }
                    throw ex;
                }
            }
            return true;
        }

        @Override
        public boolean load() {
            return this.doTransition(EventType.BOOTSTRAPPER_LOAD, BootstrapperTransition.LOAD, BootstrapperTransition.DESTROY);
        }

        @Override
        public boolean start() {
            return this.doTransition(EventType.BOOTSTRAPPER_START, BootstrapperTransition.START, BootstrapperTransition.STOP);
        }

        @Override
        public boolean enable() {
            return this.doTransition(EventType.BOOTSTRAPPER_ENABLE, BootstrapperTransition.ENABLE, BootstrapperTransition.DISABLE);
        }

        @Override
        public boolean stop() {
            return this.doTransition(EventType.BOOTSTRAPPER_ENABLE, BootstrapperTransition.STOP);
        }

        @Override
        public void destroy() {
            this.doTransition(EventType.BOOTSTRAPPER_ENABLE, BootstrapperTransition.DESTROY);
        }

        @Override
        public boolean disable() {
            return this.doTransition(EventType.BOOTSTRAPPER_ENABLE, BootstrapperTransition.DISABLE);
        }

        @Override
        public boolean check() {
            return this.doTransition(EventType.BOOTSTRAPPER_ENABLE, BootstrapperTransition.CHECK);
        }

        public List<Bootstrapper> getBootstrappers() {
            return Lists.newArrayList((Iterable)this.bootstrappers.values());
        }

        public String toString() {
            return Joiner.on((String)"\n").join((Iterable)this.bootstrappers.values());
        }

        static enum BootstrapperTransition implements Function<Bootstrapper, Boolean>
        {
            LOAD{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    return arg0.load();
                }
            }
            ,
            START{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    return arg0.start();
                }
            }
            ,
            ENABLE{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    return arg0.enable();
                }
            }
            ,
            DISABLE{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    return arg0.disable();
                }
            }
            ,
            STOP{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    try {
                        arg0.stop();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    return true;
                }
            }
            ,
            DESTROY{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    try {
                        arg0.destroy();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    return true;
                }
            }
            ,
            CHECK{

                @Override
                public Boolean runBootstrapper(Bootstrapper arg0) throws Exception {
                    return arg0.check();
                }
            };


            public abstract Boolean runBootstrapper(Bootstrapper var1) throws Exception;

            public Boolean apply(Bootstrapper input) {
                try {
                    return this.runBootstrapper(input);
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared(ex);
                }
            }
        }
    }

    static enum BootstrapChecks implements Predicate<Bootstrapper>
    {
        CHECK_NO_TRANSITION{

            public boolean apply(@Nullable Bootstrapper bootstrapper) {
                try {
                    return bootstrapper.check();
                }
                catch (Throwable f) {
                    LOG.debug((Object)"Bootstrap check failed", f);
                    return false;
                }
            }
        };

    }

    class ServiceRegistry {
        private final AtomicReference<BasicService> localService = new AtomicReference<Object>(null);
        private final ConcurrentMap<ServiceConfiguration, BasicService> services = Maps.newConcurrentMap();

        ServiceRegistry() {
        }

        public boolean hasLocalService() {
            return this.localService.get() != null;
        }

        public BasicService getLocalService() {
            BasicService ret = this.localService.get();
            if (ret == null) {
                throw Exceptions.error(new NoSuchElementException("Attempt to access a local service reference when none exists for: " + Component.this.toString()));
            }
            return ret;
        }

        public NavigableSet<ServiceConfiguration> getServices() {
            return Sets.newTreeSet(this.services.keySet());
        }

        public BasicService deregister(ServiceConfiguration config) throws NoSuchElementException {
            BasicService ret = (BasicService)this.services.remove(config);
            if (ret == null) {
                throw new NoSuchElementException("Failed to lookup service corresponding to full-name: " + config);
            }
            if (config.isVmLocal().booleanValue()) {
                Optional newLocal = Iterables.tryFind(this.services.keySet(), ServiceConfigurations.filterVmLocal());
                if (newLocal.isPresent()) {
                    this.localService.compareAndSet(ret, (BasicService)this.services.get(newLocal.get()));
                } else {
                    this.localService.compareAndSet(ret, null);
                }
            }
            return ret;
        }

        public BasicService lookup(ServiceConfiguration config) throws NoSuchElementException {
            if (!this.services.containsKey(config)) {
                throw new NoSuchElementException("Failed to lookup service corresponding to service configuration: " + config.getName());
            }
            return (BasicService)this.services.get(config);
        }

        BasicService register(ServiceConfiguration config) {
            BasicService ret;
            BasicService service;
            LOG.debug((Object)Threads.currentStackRange(1, 5));
            BasicService basicService = service = this.services.containsKey(config) ? (BasicService)this.services.get(config) : new BasicService(config);
            if (config.isVmLocal().booleanValue() || config.isHostLocal().booleanValue()) {
                this.localService.set(service);
            }
            if ((ret = this.services.putIfAbsent(config, service)) == null) {
                ret = service;
                try {
                    config.lookupStateMachine().transition(State.INITIALIZED).get();
                    EventRecord.caller(Component.class, EventType.COMPONENT_SERVICE_REGISTERED, Component.this.getName(), config.isVmLocal() != false || config.isHostLocal() != false ? "local" : "remote", config.toString()).info();
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            } else if (ret.getStateMachine().getState().ordinal() < State.INITIALIZED.ordinal()) {
                try {
                    config.lookupStateMachine().transition(State.INITIALIZED).get();
                    EventRecord.caller(Component.class, EventType.COMPONENT_SERVICE_REGISTERED, Component.this.getName(), config.isVmLocal() != false || config.isHostLocal() != false ? "local" : "remote", config.toString()).info();
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
            return ret;
        }

        public ServiceConfiguration getService(String name) throws NoSuchElementException {
            Parameters.checkParam(name, Matchers.notNullValue());
            for (ServiceConfiguration s : this.services.keySet()) {
                if (!s.getName().equals(name)) continue;
                return s;
            }
            throw new NoSuchElementException("No service found matching name: " + name + " for component: " + Component.this.getName());
        }

        public boolean hasService(ServiceConfiguration config) {
            return this.services.containsKey(config);
        }
    }

    public static enum Transition implements Automata.Transition<Transition>
    {
        INITIALIZING,
        LOAD,
        START,
        READY_CHECK,
        STOP,
        STOPPING_NOTREADY,
        STOPPING_BROKEN,
        ENABLE,
        ENABLED_CHECK,
        DISABLE,
        DISABLED_CHECK,
        DESTROY,
        FAILED_TO_PREPARE,
        RELOAD,
        REMOVING;

    }

    public static enum State implements Automata.State<State>,
    Predicate<ServiceConfiguration>
    {
        BROKEN,
        PRIMORDIAL,
        INITIALIZED,
        LOADED,
        STOPPED,
        NOTREADY,
        DISABLED,
        ENABLED;


        public boolean apply(ServiceConfiguration input) {
            return this.equals(input.lookupState());
        }
    }
}

