/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceState;
import com.eucalyptus.component.ServiceTransitions;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.fsm.StateMachine;
import java.net.URI;
import org.apache.log4j.Logger;

public class BasicService {
    private static Logger LOG = Logger.getLogger(BasicService.class);
    private final ServiceConfiguration serviceConfiguration;
    private final StateMachine<ServiceConfiguration, Component.State, Component.Transition> stateMachine;
    private final Component.State goal = Component.State.ENABLED;
    public static String LOCAL_HOSTNAME = "@localhost";

    BasicService(ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
        this.stateMachine = new ServiceState(this.serviceConfiguration);
        if (this.getServiceConfiguration().isVmLocal().booleanValue()) {
            URI remoteUri = ServiceUris.internal(this.getServiceConfiguration().getComponentId(), new String[0]);
        } else {
            URI remoteUri = ServiceUris.internal(this.getServiceConfiguration(), new String[0]);
        }
        if (this.serviceConfiguration.isVmLocal().booleanValue()) {
            ComponentId compId = this.serviceConfiguration.getComponentId();
            OrderedShutdown.registerShutdownHook(compId.getClass(), new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceTransitions.pathTo(BasicService.this.serviceConfiguration, Component.State.PRIMORDIAL).get();
                        LOG.warn((Object)("SHUTDOWN Service: " + BasicService.this.serviceConfiguration.getFullName()));
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                }
            });
        }
    }

    public final String getName() {
        return this.serviceConfiguration.getFullName().toString();
    }

    public Boolean isLocal() {
        return this.serviceConfiguration.isVmLocal();
    }

    ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public String toString() {
        return String.format("Service %s name=%s serviceConfiguration=%s\n", this.getServiceConfiguration().getComponentId().name(), this.getName(), this.getServiceConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceConfiguration == null ? 0 : this.serviceConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicService other = (BasicService)obj;
        return !(this.serviceConfiguration == null ? other.serviceConfiguration != null : !this.serviceConfiguration.equals(other.serviceConfiguration));
    }

    public int compareTo(ServiceConfiguration that) {
        return this.serviceConfiguration.compareTo(that);
    }

    public StateMachine<ServiceConfiguration, Component.State, Component.Transition> getStateMachine() {
        return this.stateMachine;
    }
}

