/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.annotation.Partition;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.Internets;
import java.util.NoSuchElementException;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;

public abstract class AbstractServiceBuilder<T extends ServiceConfiguration>
implements ServiceBuilder<T> {
    private static Logger LOG = Logger.getLogger(AbstractServiceBuilder.class);

    @Override
    public void fireLoad(ServiceConfiguration parent) throws ServiceRegistrationException {
    }

    @Override
    public boolean checkAdd(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        try {
            if (!Internets.testGoodAddress(host)) {
                throw new EucalyptusCloudException("Components cannot be registered using local, link-local, or multicast addresses.");
            }
        }
        catch (EucalyptusCloudException e) {
            throw new ServiceRegistrationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ServiceRegistrationException("Service registration failed: " + e.getMessage(), e);
        }
        Object existingName = null;
        try {
            existingName = ServiceConfigurations.lookupByName(this.getComponentId().getClass(), name);
        }
        catch (NoSuchElementException ex1) {
            LOG.trace((Object)("Failed to find existing component registration for name: " + name));
        }
        catch (PersistenceException e) {
            throw new ServiceRegistrationException("Service registration failed: " + e.getMessage(), e);
        }
        Partition partitionAnnotation = Ats.from(this.getComponentId()).get(Partition.class);
        boolean manyToOne = partitionAnnotation != null && partitionAnnotation.manyToOne();
        HasName existingHost = null;
        if (!manyToOne) {
            if (this.getComponentId().isPartitioned() ? ServiceConfigurations.listPartition(this.getComponentId().getClass(), partition).size() >= 2 : ServiceConfigurations.list(this.getComponentId().getClass()).size() >= 2) {
                throw new ServiceRegistrationException("Unable to register more than two services in a partition for component type: " + this.getComponentId().getName());
            }
            try {
                existingHost = (HasName)ServiceConfigurations.lookupByHost(this.getComponentId().getClass(), host);
            }
            catch (NoSuchElementException ex1) {
                LOG.trace((Object)("Failed to find existing component registration for host: " + name));
            }
            catch (PersistenceException ex1) {
                LOG.trace((Object)("Failed to find existing component registration for host: " + host));
            }
        } else if (ServiceConfigurations.listPartition(this.getComponentId().getClass(), partition).size() >= 1) {
            throw new ServiceRegistrationException("Unable to register more than one service in a partition for component type: " + this.getComponentId().getName());
        }
        if (existingName != null && existingHost != null) {
            Object maybeIdenticalConfig = existingName;
            if (existingName.equals(existingHost) && maybeIdenticalConfig.getName().equals(name) && maybeIdenticalConfig.getPartition().equals(partition) && maybeIdenticalConfig.getHostName().equals(host) && maybeIdenticalConfig.getPort().equals(port)) {
                return false;
            }
        }
        if (existingName == null && existingHost == null) {
            return true;
        }
        if (existingName != null) {
            throw new ServiceRegistrationException("Component with name=" + name + " already exists with host=" + existingName.getHostName());
        }
        if (existingHost != null) {
            throw new ServiceRegistrationException("Component with host=" + host + " already exists with name=" + existingHost.getName());
        }
        throw new ServiceRegistrationException("BUG: This is a logical impossibility.");
    }

    @Override
    public boolean checkUpdate(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        try {
            Object configuration = ServiceConfigurations.lookupByName(this.getComponentId().getClass(), name);
            if (!configuration.getPort().equals(port) || !configuration.getHostName().equals(host)) {
                if (!Internets.testGoodAddress(host)) {
                    throw new ServiceRegistrationException("Components cannot use local, link-local, or multicast addresses.");
                }
                if (configuration.getComponentId().isPartitioned() && configuration.getPartition() != null && !configuration.getPartition().equals(partition)) {
                    throw new ServiceRegistrationException("Partition update not supported, please re-register component.");
                }
                return true;
            }
        }
        catch (ServiceRegistrationException e) {
            throw e;
        }
        catch (NoSuchElementException ex1) {
            LOG.trace((Object)("Failed to find existing component registration for name: " + name));
        }
        catch (Exception e) {
            throw new ServiceRegistrationException("Service registration failed: " + e.getMessage(), e);
        }
        return false;
    }
}

