/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.BillOfMaterials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.Signatures;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Joiner;

public class SystemIds {
    public static String databasePassword() {
        try {
            return Digest.SHA256.digestHex(Signatures.SHA256withRSA.signBinary(Eucalyptus.class, "eucalyptus".getBytes()));
        }
        catch (Exception e) {
            throw Exceptions.toUndeclared((String)"Error getting database password", (Throwable[])new Exception[]{e});
        }
    }

    public static String tunnelPassword() {
        return Signatures.SHA256withRSA.trySign(Eucalyptus.class, "vtunpass".getBytes());
    }

    public static String securityTokenPassword() {
        return Signatures.SHA256withRSA.trySign(Eucalyptus.class, "tokens-service".getBytes());
    }

    public static String createCloudUniqueName(String subName) {
        return Joiner.on((String)".").join((Object)Eucalyptus.class.getSimpleName(), (Object)BillOfMaterials.getVersion(), new Object[]{subName, Signatures.SHA256withRSA.trySign(Eucalyptus.class, subName.getBytes())});
    }

    public static String createShortCloudUniqueName(String subName) {
        try {
            return Joiner.on((String)".").join((Object)Eucalyptus.class.getSimpleName(), (Object)BillOfMaterials.getVersion(), new Object[]{subName, Digest.SHA256.digestHex(Signatures.SHA256withRSA.signBinary(Eucalyptus.class, subName.getBytes()))});
        }
        catch (Exception e) {
            throw Exceptions.toUndeclared((String)("Error getting short unique name for " + subName), (Throwable[])new Exception[]{e});
        }
    }

    public static String cloudName() {
        return SystemIds.createCloudUniqueName("cloud");
    }

    public static String cacheName() {
        return SystemIds.createShortCloudUniqueName("cache");
    }

    public static String membershipGroupName() {
        return SystemIds.createShortCloudUniqueName("membership");
    }

    public static String membershipUdpMcastTransportName() {
        return SystemIds.createShortCloudUniqueName("membership-udp-mcast-transport");
    }
}

