/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.BillOfMaterials;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.EventClass;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.Capabilities;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Internets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import groovy.lang.ExpandoMetaClass;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SystemBootstrapper {
    private static final String SEP = " -- ";
    static Logger LOG = Logger.getLogger(SystemBootstrapper.class);
    private static SystemBootstrapper singleton;
    private static ThreadGroup singletonGroup;
    public static final PrintStream out;
    public static final PrintStream err;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemBootstrapper getInstance() {
        Class<SystemBootstrapper> clazz = SystemBootstrapper.class;
        synchronized (SystemBootstrapper.class) {
            if (singleton == null) {
                singleton = new SystemBootstrapper();
                LOG.info((Object)"Creating Bootstrapper instance.");
            } else {
                LOG.info((Object)"Returning Bootstrapper instance.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private static void handleException(Throwable t) throws Throwable {
        if (t instanceof BootstrapException) {
            t.printStackTrace();
            LOG.fatal((Object)t, t);
            throw t;
        }
        t.printStackTrace();
        LOG.fatal((Object)t, t);
        System.exit(123);
    }

    public boolean init() throws Throwable {
        ExpandoMetaClass.enableGlobally();
        Logs.init();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                try {
                    String stack = Joiner.on((String)"\t\n").join((Object[])Thread.currentThread().getStackTrace());
                    LOG.error((Object)stack);
                    LOG.error((Object)e, e);
                }
                catch (Exception ex) {
                    try {
                        System.out.println(Joiner.on((String)"\t\n").join((Object[])Thread.currentThread().getStackTrace()));
                        e.printStackTrace();
                        ex.printStackTrace();
                    }
                    catch (Exception ex1) {
                        System.out.println("Failed because of badness in uncaught exception path.");
                        System.out.println("Thread:      " + t.toString());
                        System.out.println("Exception:   " + e.getClass());
                        System.out.println("Message:     " + e.getMessage());
                        System.out.println("All threads:\n");
                        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                        }
                    }
                }
            }
        });
        OrderedShutdown.initialize();
        BootstrapArgs.init();
        if (Security.getProvider("BC") == null) {
            if (Security.getProviders().length > 4) {
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 4);
            } else {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
        }
        try {
            Groovyness.eval("import sun.security.jca.*; Providers.setProviderList( ProviderList.remove( Providers.@providerList,\"SunPKCS11-NSS\") );");
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            if (!BootstrapArgs.isInitializeSystem()) {
                Bootstrap.init();
                Bootstrap.Stage stage = Bootstrap.transition();
                stage.load();
            }
            return true;
        }
        catch (Throwable t) {
            SystemBootstrapper.handleException(t);
            return false;
        }
    }

    public boolean load() throws Throwable {
        if (BootstrapArgs.isInitializeSystem()) {
            try {
                Bootstrap.initializeSystem();
                System.exit(0);
            }
            catch (Throwable t) {
                LOG.error((Object)t, t);
                System.exit(1);
                throw t;
            }
        } else {
            SystemBootstrapper.runSystemStages(new Predicate<Bootstrap.Stage>(){

                public boolean apply(Bootstrap.Stage input) {
                    input.load();
                    return true;
                }
            });
            Bootstrap.applyTransition(Component.State.LOADED, Components.whichCanLoad());
        }
        return true;
    }

    public boolean start() throws Throwable {
        Capabilities.initialize();
        SystemBootstrapper.runSystemStages(new Predicate<Bootstrap.Stage>(){

            public boolean apply(Bootstrap.Stage input) {
                input.start();
                return true;
            }
        });
        Bootstrap.applyTransition(Component.State.LOADED, Components.whichCanLoad());
        Threads.enqueue(Empyrean.class, SystemBootstrapper.class, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    Bootstrap.applyTransition(Component.State.DISABLED, Components.whichCanLoad());
                    Bootstrap.applyTransition(Component.State.ENABLED, Components.whichCanEnable());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                return Boolean.TRUE;
            }
        }).get();
        try {
            SystemBootstrapper.printBanner();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return true;
    }

    private static void runSystemStages(Predicate<Bootstrap.Stage> exec) throws Throwable {
        try {
            Bootstrap.Stage stage = Bootstrap.transition();
            do {
                exec.apply((Object)stage);
            } while ((stage = Bootstrap.transition()) != null);
        }
        catch (Throwable t) {
            LOG.error((Object)t);
            Logs.extreme().error((Object)t, t);
            System.exit(123);
        }
    }

    public String getVersion() {
        return BillOfMaterials.RequiredFields.VERSION.getValue();
    }

    public boolean check() {
        return true;
    }

    public boolean destroy() {
        return true;
    }

    public boolean stop() throws Exception {
        LOG.warn((Object)"Shutting down Eucalyptus.");
        EventRecord.here(SystemBootstrapper.class, EventClass.SYSTEM, EventType.SYSTEM_STOP, "SHUT DOWN").info();
        return true;
    }

    public static void restart() {
        System.exit(123);
    }

    private static native void shutdown(boolean var0);

    public static native void hello();

    private static String printBanner() {
        String prefix = "\n\t";
        String headerHeader = "\n_________________________________________________________\n";
        String headerFormat = "  %-53.53s";
        String headerFooter = "\n_________________________________________________________\n";
        String banner = "Started Eucalyptus Version: " + singleton.getVersion() + "\n";
        banner = banner + headerHeader + String.format(headerFormat, "System Bootstrap Configuration") + headerFooter;
        for (Bootstrap.Stage stage : Bootstrap.Stage.values()) {
            banner = banner + prefix + stage.name() + SEP + stage.describe().replaceAll("(\\w*)\\w\n", "\u0001\n" + prefix + stage.name() + SEP).replaceAll("^\\w* ", "");
        }
        banner = banner + headerHeader + String.format(headerFormat, "Component Bootstrap Configuration") + headerFooter;
        for (Component c : Components.list()) {
            if (!c.getComponentId().isAvailableLocally().booleanValue()) continue;
            banner = banner + c.getBootstrapper();
        }
        banner = banner + headerHeader + String.format(headerFormat, "Local Services") + headerFooter;
        for (Component c : Components.list()) {
            if (!c.hasLocalService().booleanValue()) continue;
            ServiceConfiguration localConfig = c.getLocalServiceConfiguration();
            banner = banner + prefix + c.getName() + SEP + localConfig.toString();
            banner = banner + prefix + c.getName() + SEP + localConfig.getComponentId().toString();
            banner = banner + prefix + c.getName() + SEP + localConfig.lookupState().toString();
        }
        banner = banner + headerHeader + String.format(headerFormat, "Detected Interfaces") + headerFooter;
        for (NetworkInterface iface : Internets.getNetworkInterfaces()) {
            banner = banner + prefix + iface.getDisplayName() + SEP + Lists.transform(iface.getInterfaceAddresses(), (Function)Functions.toStringFunction());
            for (InetAddress addr : Lists.newArrayList((Iterator)Iterators.forEnumeration(iface.getInetAddresses()))) {
                banner = banner + prefix + iface.getDisplayName() + SEP + addr;
            }
        }
        LOG.info((Object)banner);
        return banner;
    }

    static {
        out = System.out;
        err = System.err;
    }
}

