/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.LogUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;

public abstract class ServiceJarDiscovery
implements Comparable<ServiceJarDiscovery> {
    private static Logger LOG = Logger.getLogger(ServiceJarDiscovery.class);
    private static SortedSet<ServiceJarDiscovery> discovery = Sets.newTreeSet();
    private static Multimap<Class, String> classList = ArrayListMultimap.create();

    private static void doDiscovery() {
        File libDir = new File(BaseDirectory.LIB.toString());
        for (File f : libDir.listFiles()) {
            if (!f.getName().startsWith("eucalyptus") || !f.getName().endsWith(".jar") || f.getName().matches(".*-ext-.*")) continue;
            LOG.debug((Object)("Found eucalyptus component jar: " + f.getName()));
            try {
                JarFilePass.CLASSES.process(f);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getMessage());
            }
        }
        ServiceJarDiscovery.runDiscovery();
    }

    public static void doSingleDiscovery(ServiceJarDiscovery s) {
        File libDir = new File(BaseDirectory.LIB.toString());
        for (File f : libDir.listFiles()) {
            if (!f.getName().startsWith("eucalyptus") || !f.getName().endsWith(".jar") || f.getName().matches(".*-ext-.*")) continue;
            LOG.debug((Object)("Found eucalyptus component jar: " + f.getName()));
            try {
                JarFilePass.CLASSES.process(f);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getMessage());
            }
        }
        ServiceJarDiscovery.runDiscovery(s);
    }

    public static void checkUniqueness(Class c) {
        if (classList.get((Object)c).size() > 1) {
            LOG.fatal((Object)("Duplicate bootstrap class registration: " + c.getName()));
            for (String fileName : classList.get((Object)c)) {
                LOG.fatal((Object)("\n==> Defined in: " + fileName));
            }
            System.exit(1);
        }
    }

    public static void runDiscovery() {
        for (ServiceJarDiscovery s : discovery) {
            EventRecord.here(ServiceJarDiscovery.class, EventType.BOOTSTRAP_INIT_DISCOVERY, s.getClass().getCanonicalName()).trace();
        }
        for (ServiceJarDiscovery s : discovery) {
            ServiceJarDiscovery.runDiscovery(s);
        }
    }

    public static void runDiscovery(ServiceJarDiscovery s) {
        LOG.info((Object)LogUtil.subheader(s.getClass().getSimpleName()));
        for (Class c : classList.keySet()) {
            try {
                s.checkClass(c);
            }
            catch (Throwable t) {
                LOG.debug((Object)t, t);
            }
        }
    }

    private void checkClass(Class candidate) {
        block3: {
            try {
                if (this.processClass(candidate)) {
                    ServiceJarDiscovery.checkUniqueness(candidate);
                    EventRecord.here(ServiceJarDiscovery.class, EventType.DISCOVERY_LOADED_ENTRY, this.getClass().getSimpleName(), candidate.getName()).trace();
                }
            }
            catch (Throwable e) {
                if (e instanceof InstantiationException) break block3;
                LOG.trace((Object)e, e);
            }
        }
    }

    public abstract boolean processClass(Class var1) throws Exception;

    public Double getDistinctPriority() {
        return this.getPriority() + 0.1 / (double)this.getClass().hashCode();
    }

    public abstract Double getPriority();

    @Override
    public int compareTo(ServiceJarDiscovery that) {
        return this.getDistinctPriority().compareTo(that.getDistinctPriority());
    }

    public static void processLibraries() {
        File libDir = new File(BaseDirectory.LIB.toString());
        for (File f : libDir.listFiles()) {
            if (!f.getName().startsWith("eucalyptus") || !f.getName().endsWith(".jar") || f.getName().matches(".*-ext-.*")) continue;
            EventRecord.here(ServiceJarDiscovery.class, EventType.BOOTSTRAP_INIT_SERVICE_JAR, f.getName()).info();
            try {
                JarFilePass.CLASSES.process(f);
            }
            catch (Throwable e) {
                Bootstrap.LOG.error((Object)e.getMessage());
            }
        }
    }

    public static URLClassLoader makeClassLoader(File libDir) {
        URLClassLoader loader = new URLClassLoader(Lists.transform(Arrays.asList(libDir.listFiles()), (Function)new Function<File, URL>(){

            public URL apply(File arg0) {
                try {
                    return URI.create("file://" + arg0.getAbsolutePath()).toURL();
                }
                catch (MalformedURLException e) {
                    LOG.debug((Object)e, (Throwable)e);
                    return null;
                }
            }
        }).toArray(new URL[0]));
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> contextsInDir(File libDir) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ServiceJarDiscovery.makeClassLoader(libDir));
            HashSet ctxs = Sets.newHashSet();
            for (Class candidate : ServiceJarDiscovery.getClassList(libDir)) {
                if (!PersistenceContexts.isEntityClass(candidate) || !Ats.from(candidate).has(PersistenceContext.class)) continue;
                ctxs.add(Ats.from(candidate).get(PersistenceContext.class).name());
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)ctxs);
            return arrayList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class> classesInDir(File libDir) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ServiceJarDiscovery.makeClassLoader(libDir));
            List<Class> list = ServiceJarDiscovery.getClassList(libDir);
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private static List<Class> getClassList(File libDir) {
        ArrayList classList = Lists.newArrayList();
        for (File f : libDir.listFiles()) {
            if (!f.getName().startsWith("eucalyptus") || !f.getName().endsWith(".jar") || f.getName().matches(".*-ext-.*")) continue;
            try {
                JarFile jar = new JarFile(f);
                for (JarEntry j : Collections.list(jar.entries())) {
                    if (!j.getName().matches(".*\\.class.{0,1}")) continue;
                    String classGuess = j.getName().replaceAll("/", ".").replaceAll("\\.class.{0,1}", "");
                    try {
                        Class<?> candidate = ClassLoader.getSystemClassLoader().loadClass(classGuess);
                        classList.add(candidate);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                jar.close();
            }
            catch (Throwable e) {
                LOG.error((Object)e.getMessage());
            }
        }
        return classList;
    }

    static enum JarFilePass {
        CLASSES{

            @Override
            public void process(File f) throws Exception {
                JarFile jar = new JarFile(f);
                Properties props = new Properties();
                ArrayList<JarEntry> jarList = Collections.list(jar.entries());
                LOG.trace((Object)("-> Trying to load component info from " + f.getAbsolutePath()));
                for (JarEntry j : jarList) {
                    try {
                        if (!j.getName().matches(".*\\.class.{0,1}")) continue;
                        this.handleClassFile(f, j);
                    }
                    catch (RuntimeException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        jar.close();
                        throw ex;
                    }
                }
                jar.close();
            }

            private void handleClassFile(File f, JarEntry j) throws IOException, RuntimeException {
                block7: {
                    String classGuess = j.getName().replaceAll("/", ".").replaceAll("\\.class.{0,1}", "");
                    try {
                        final Class<?> candidate = ClassLoader.getSystemClassLoader().loadClass(classGuess);
                        classList.put(candidate, (Object)f.getAbsolutePath());
                        if (ServiceJarDiscovery.class.isAssignableFrom(candidate) && !ServiceJarDiscovery.class.equals(candidate) && !candidate.isAnonymousClass()) {
                            try {
                                ServiceJarDiscovery discover = (ServiceJarDiscovery)candidate.newInstance();
                                discovery.add(discover);
                                break block7;
                            }
                            catch (Exception e) {
                                LOG.fatal((Object)e, (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                        if (!Ats.from(candidate).has(Bootstrap.Discovery.class) || !Predicate.class.isAssignableFrom(candidate)) break block7;
                        try {
                            ServiceJarDiscovery discover = new ServiceJarDiscovery(){
                                final Bootstrap.Discovery annote;
                                final Predicate<Class> instance;
                                {
                                    this.annote = Ats.from(candidate).get(Bootstrap.Discovery.class);
                                    this.instance = (Predicate)Classes.builder(candidate).newInstance();
                                }

                                @Override
                                public boolean processClass(Class discoveryCandidate) throws Exception {
                                    boolean classFiltered;
                                    boolean bl = classFiltered = this.annote.value().length != 0 ? Iterables.any(Arrays.asList(this.annote.value()), Classes.assignableTo(discoveryCandidate)) : true;
                                    if (classFiltered) {
                                        boolean annotationFiltered;
                                        boolean bl2 = annotationFiltered = this.annote.annotations().length != 0 ? Iterables.any(Arrays.asList(this.annote.annotations()), (Predicate)Ats.from(discoveryCandidate)) : true;
                                        if (annotationFiltered) {
                                            return this.instance.apply((Object)discoveryCandidate);
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @Override
                                public Double getPriority() {
                                    return this.annote.priority();
                                }
                            };
                            discovery.add(discover);
                        }
                        catch (Exception e) {
                            LOG.fatal((Object)e, (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        LOG.debug((Object)e, (Throwable)e);
                    }
                }
            }
        };


        public abstract void process(File var1) throws Exception;
    }
}

