/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.ShutdownHook;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.util.Exceptions;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.log4j.Logger;

public class OrderedShutdown {
    static Logger LOG = Logger.getLogger(OrderedShutdown.class);
    static LinkedBlockingQueue<ShutdownHook> preShutdownHooks = new LinkedBlockingQueue();
    static PriorityBlockingQueue<ShutdownHook> shutdownHooks = new PriorityBlockingQueue();
    static LinkedBlockingQueue<ShutdownHook> postShutdownHooks = new LinkedBlockingQueue();

    public static <T extends ComponentId> void registerShutdownHook(Class<T> id, Runnable r) {
        ShutdownHook hook = new ShutdownHook((ComponentId)ComponentIds.lookup(id), r);
        shutdownHooks.offer(hook);
    }

    public static void registerPreShutdownHook(Runnable r) {
        ShutdownHook hook = new ShutdownHook(r);
        preShutdownHooks.offer(hook);
    }

    public static void registerPostShutdownHook(Runnable r) {
        ShutdownHook hook = new ShutdownHook(r);
        postShutdownHooks.offer(hook);
    }

    public static void initialize() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ShutdownHook posthook;
                ShutdownHook h;
                ShutdownHook prehook;
                LOG.info((Object)"Executing Pre-Shutdown Hooks...");
                while ((prehook = preShutdownHooks.poll()) != null) {
                    try {
                        LOG.info((Object)("Executing Pre-Shutdown Hook: " + prehook.getRunnable()));
                        prehook.getRunnable().run();
                    }
                    catch (Exception e) {
                        Exceptions.maybeInterrupted(e);
                    }
                }
                LOG.info((Object)"Executing Shutdown Hooks...");
                while ((h = shutdownHooks.poll()) != null) {
                    try {
                        LOG.info((Object)("Executing Shutdown Hook: " + h.getRunnable()));
                        h.getRunnable().run();
                    }
                    catch (Exception e) {
                        Exceptions.maybeInterrupted(e);
                    }
                }
                LOG.info((Object)"Executing Post-Shutdown Hooks...");
                while ((posthook = postShutdownHooks.poll()) != null) {
                    try {
                        LOG.info((Object)("Executing Post-Shutdown Hook: " + posthook.getRunnable()));
                        posthook.getRunnable().run();
                    }
                    catch (Exception e) {
                        Exceptions.maybeInterrupted(e);
                    }
                }
            }
        });
    }
}

