/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.bootstrap.SystemIds;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.Timers;
import com.eucalyptus.util.async.Futures;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataOutput;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.ReplicatedHashMap;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

@ConfigurableClass(root="bootstrap.hosts", description="Properties controlling the handling of remote host bootstrapping")
public class Hosts {
    private static int REJOIN_BACKOFF_SECS = Integer.parseInt(System.getProperty("euca.bootstrap.rejoin.backoff", "30"));
    @ConfigurableField(description="Timeout for state transfers (in msec).", readonly=true)
    public static final Long STATE_TRANSFER_TIMEOUT = 10000L;
    @ConfigurableField(description="Timeout for state initialization (in msec).", readonly=true)
    public static final Long STATE_INITIALIZE_TIMEOUT = 120000L;
    private static final Logger LOG = Logger.getLogger(Hosts.class);
    public static final long SERVICE_INITIALIZE_TIMEOUT = 10000L;
    private static ReplicatedHashMap<String, Host> hostMap;
    private static final ReentrantReadWriteLock canHas;
    private static final Predicate<Host> FILTER_SYNCED_DBS;
    private static final Predicate<Host> FILTER_BOOTED_SYNCED_DBS;

    public static Predicate<ServiceConfiguration> nonLocalAddressMatch(final InetAddress addr) {
        return new Predicate<ServiceConfiguration>(){

            public boolean apply(ServiceConfiguration input) {
                return input.getInetAddress().equals(addr) || input.getInetAddress().getCanonicalHostName().equals(addr.getCanonicalHostName()) || input.getHostName().equals(addr.getCanonicalHostName());
            }
        };
    }

    public static Predicate<ComponentId> nonLocalAddressFilter(final InetAddress addr) {
        return new Predicate<ComponentId>(){

            public boolean apply(ComponentId input) {
                return !Internets.testLocal(addr);
            }
        };
    }

    private static <T extends ComponentId> Function<T, ServiceConfiguration> initRemoteSetupConfigurations(final InetAddress addr) {
        return new Function<T, ServiceConfiguration>(){

            public ServiceConfiguration apply(T input) {
                Component component = Components.lookup(input);
                ServiceConfiguration config = !Internets.testLocal(addr.getHostAddress()) ? component.initRemoteService(addr) : component.initService();
                Logs.extreme().info((Object)("Initialized service: " + config.getFullName()));
                return config;
            }
        };
    }

    private static boolean pruneHosts() {
        block6: {
            try {
                HashSet currentMembers = Sets.newHashSet((Iterable)hostMap.getChannel().getView().getMembers());
                HashMap hostCopy = Maps.newHashMap(hostMap);
                HashSet currentHosts = Sets.newHashSet((Iterable)Collections2.transform(hostCopy.values(), (Function)GroupAddressTransform.INSTANCE));
                Sets.SetView strayHosts = Sets.difference((Set)currentHosts, (Set)currentMembers);
                if (!strayHosts.isEmpty()) {
                    LOG.info((Object)("Pruning orphan host entries: " + strayHosts));
                    for (Address strayHost : strayHosts) {
                        Host h = (Host)hostCopy.get(strayHost.toString());
                        if (h == null) {
                            LOG.debug((Object)("Pruning failed to find host copy for orphan host: " + h));
                            h = Hosts.lookup(strayHost.toString());
                            LOG.debug((Object)("Pruning fell back to underlying host map for orphan host: " + h));
                        }
                        if (h != null) {
                            LOG.info((Object)("Pruning orphan host: " + h));
                            BootstrapComponent.TEARDOWN.apply(h);
                            continue;
                        }
                        LOG.info((Object)("Pruning failed for orphan host: " + strayHost + " with local-copy value: " + hostCopy.get(strayHost.toString()) + " and underlying host map value: " + Hosts.lookup(strayHost)));
                    }
                    break block6;
                }
                return false;
            }
            catch (Exception ex) {
                LOG.debug((Object)ex);
                Logs.extreme().debug((Object)ex, (Throwable)ex);
            }
        }
        return true;
    }

    private static void updateServices() {
        try {
            if (!Topology.isEnabled(Eucalyptus.class) && Hosts.getCoordinator() != null) {
                LOG.info((Object)("Setting up new coordinator: " + Hosts.getCoordinator()));
                BootstrapComponent.SETUP.apply(Hosts.getCoordinator());
            } else if (!Hosts.isCoordinator() && Bootstrap.isFinished().booleanValue()) {
                BootstrapComponent.SETUP.apply(Hosts.localHost());
                UpdateEntry.INSTANCE.apply(Hosts.localHost());
            }
        }
        catch (Exception ex) {
            LOG.debug((Object)ex);
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
    }

    private static boolean eucalyptusStoppedLocally() {
        return !Iterables.isEmpty(ServiceConfigurations.filter(Eucalyptus.class, Predicates.and(ServiceConfigurations.filterHostLocal(), (Predicate)Component.State.STOPPED)));
    }

    public static ImmutableList<Host.DBStatus> getDBStatus() {
        ArrayList status = Lists.newArrayList();
        for (String cluster : Databases.listRegisteredDatabases()) {
            status.add(new Host.DBStatus(cluster, Databases.listPrimaryActiveDatabases(cluster), Databases.listSecondaryActiveDatabases(cluster), Databases.listInactiveDatabases(cluster)));
        }
        return ImmutableList.copyOf((Collection)status);
    }

    public static Address getLocalGroupAddress() {
        return HostManager.getMembershipChannel().getAddress();
    }

    private static void doInitialize() {
        try {
            hostMap.stop();
        }
        catch (Exception ex1) {
            LOG.error((Object)ex1, (Throwable)ex1);
        }
        try {
            Bootstrap.initializeSystem();
            System.exit(123);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            System.exit(123);
        }
    }

    public static int maxEpoch() {
        try {
            return (Integer)Collections.max(Collections2.transform((Collection)hostMap.values(), (Function)EpochTransform.INSTANCE));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static List<Host> list() {
        ArrayList hosts = Lists.newArrayList();
        if (hostMap != null) {
            hosts.addAll(hostMap.values());
        }
        return hosts;
    }

    public static List<Host> list(Predicate<Host> filter) {
        return Lists.newArrayList((Iterable)Iterables.filter(Hosts.list(), filter));
    }

    public static List<Host> listDatabases() {
        return Hosts.list(DbFilter.INSTANCE);
    }

    public static List<Host> listActiveDatabases() {
        return Hosts.list(FILTER_SYNCED_DBS);
    }

    private static Host put(Host newHost) {
        return (Host)hostMap.put((Object)newHost.getDisplayName(), (Object)newHost);
    }

    private static Host putIfAbsent(Host host) {
        return (Host)hostMap.putIfAbsent((Object)host.getDisplayName(), (Object)host);
    }

    public static Host lookup(Address hostGroupAddress) {
        return Hosts.lookup(hostGroupAddress.toString());
    }

    public static Host lookup(String hostDisplayName) {
        if (hostMap.containsKey((Object)hostDisplayName)) {
            return (Host)hostMap.get((Object)hostDisplayName);
        }
        final InetAddress addr = Internets.toAddress(hostDisplayName);
        Hosts.list(new Predicate<Host>(){

            public boolean apply(Host input) {
                if (input.getBindAddress().equals(addr)) {
                    return true;
                }
                return input.getHostAddresses().contains((Object)addr);
            }
        });
        return null;
    }

    public static Host lookup(final InetAddress address) {
        if (hostMap.containsKey((Object)address.getHostAddress())) {
            return (Host)hostMap.get((Object)address.getHostAddress());
        }
        return (Host)Iterables.tryFind(Hosts.list(), (Predicate)new Predicate<Host>(){

            public boolean apply(Host input) {
                return input.getHostAddresses().contains((Object)address);
            }
        }).orNull();
    }

    public static boolean contains(String hostDisplayName) {
        return hostMap.containsKey((Object)hostDisplayName);
    }

    static boolean contains(Address hostGroupAddress) {
        if (!HostManager.getMembershipChannel().getView().containsMember(hostGroupAddress)) {
            return false;
        }
        return Hosts.contains(hostGroupAddress.toString());
    }

    static Host remove(Address hostGroupAddress) {
        return Hosts.remove(hostGroupAddress.toString());
    }

    static Host remove(String hostDisplayName) {
        Host ret = null;
        try {
            ret = (Host)hostMap.remove((Object)hostDisplayName);
            LOG.info((Object)("Removing host map entry for: " + hostDisplayName + " => " + ret));
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Removing host map entry for: " + hostDisplayName + " => " + e.getMessage()));
        }
        return ret;
    }

    public static Host localHost() {
        if (hostMap == null || !hostMap.containsKey((Object)Internets.localHostIdentifier())) {
            return Host.create();
        }
        return Hosts.lookup(Internets.localHostIdentifier());
    }

    public static Long getStartTime() {
        return Coordinator.INSTANCE.getCurrentStartTime();
    }

    public static boolean isCoordinator(Host host) {
        return Hosts.isCoordinator(host.getBindAddress());
    }

    public static boolean isCoordinator(InetAddress addr) {
        Host coordinator = Hosts.getCoordinator();
        return coordinator != null && coordinator.getBindAddress().equals(addr);
    }

    public static void failstop() {
        Coordinator.INSTANCE.reset();
    }

    public static boolean hasCoordinator() {
        return Coordinator.INSTANCE.get() != null;
    }

    public static boolean isCoordinator() {
        return Coordinator.INSTANCE.isLocalhost();
    }

    public static Host getCoordinator() {
        return Coordinator.INSTANCE.get();
    }

    public static boolean isServiceLocal(ServiceConfiguration parent) {
        return parent.isVmLocal() != false || parent.isHostLocal() != false && Hosts.isCoordinator();
    }

    private static Predicate<Host.DBStatus> consistentWith(final Host.DBStatus status1) {
        return new Predicate<Host.DBStatus>(){

            public boolean apply(Host.DBStatus status2) {
                return status2.consistentWith(status1);
            }
        };
    }

    private static Function<List<Host.DBStatus>, Function<Host.DBStatus, List<Host.DBStatus>>> distinctStatus() {
        return new Function<List<Host.DBStatus>, Function<Host.DBStatus, List<Host.DBStatus>>>(){

            public Function<Host.DBStatus, List<Host.DBStatus>> apply(final List<Host.DBStatus> statusList) {
                return new Function<Host.DBStatus, List<Host.DBStatus>>(){

                    public List<Host.DBStatus> apply(Host.DBStatus input) {
                        if (!Iterables.any((Iterable)statusList, (Predicate)Hosts.consistentWith(input))) {
                            statusList.add(input);
                        }
                        return statusList;
                    }
                };
            }
        };
    }

    static void awaitDatabases() throws InterruptedException {
        if (!BootstrapArgs.isCloudController().booleanValue()) {
            while (Hosts.list(FILTER_BOOTED_SYNCED_DBS).isEmpty()) {
                TimeUnit.SECONDS.sleep(3L);
                LOG.info((Object)"Waiting for system view with database...");
                LOG.info((Object)HostMapStateListener.INSTANCE.printMap("Hosts.awaitDatabases():"));
            }
            if (Databases.shouldInitialize()) {
                Hosts.doInitialize();
            }
        } else if (BootstrapArgs.isCloudController().booleanValue() && !Hosts.isCoordinator()) {
            while (AwaitDatabase.INSTANCE.apply(Hosts.getCoordinator())) {
            }
            TimeUnit.SECONDS.sleep(REJOIN_BACKOFF_SECS);
        }
    }

    public static List<String> getHostDatabaseErrors() {
        List<String> errors = Collections.emptyList();
        if (Bootstrap.isOperational().booleanValue() && !Databases.isVolatile().booleanValue()) {
            errors = Hosts.getHostDatabaseErrors(Hosts.getCoordinator(), Hosts.list());
        }
        return errors;
    }

    static List<String> getHostDatabaseErrors(Host coordinator, List<Host> hosts) {
        ArrayList errors;
        block4: {
            List<Host.DBStatus> distinctStatus;
            block5: {
                errors = Lists.newArrayList();
                if (coordinator == null) break block4;
                distinctStatus = CollectionUtils.reduce(coordinator.getDatabaseStatus(), Lists.newArrayList(), Hosts.distinctStatus());
                Iterable coordinatorErrors = Optional.presentInstances((Iterable)Iterables.transform(coordinator.getDatabaseStatus(), (Function)DbStatusErrorTransform.INSTANCE));
                if (distinctStatus.size() <= 1 && Iterables.isEmpty((Iterable)coordinatorErrors)) break block5;
                if (distinctStatus.size() > 1) {
                    errors.add(String.format("Host %s database error: Inconsistent primary/secondary databases %s", coordinator.getDisplayName(), distinctStatus));
                }
                for (Host host : Iterables.filter(hosts, (Predicate)DbStatusErrorFilter.INSTANCE)) {
                    for (String error : Optional.presentInstances((Iterable)Iterables.transform(host.getDatabaseStatus(), (Function)DbStatusErrorTransform.INSTANCE))) {
                        errors.add(String.format("Host %s database error: %s", host.getDisplayName(), error));
                    }
                }
                break block4;
            }
            if (distinctStatus.size() != 1) break block4;
            for (Host host : hosts) {
                ArrayList inconsistentStatus = Lists.newArrayList((Iterable)Iterables.filter(host.getDatabaseStatus(), (Predicate)Predicates.not(Hosts.consistentWith(distinctStatus.get(0)))));
                if (inconsistentStatus.isEmpty()) continue;
                errors.add(String.format("Host %s database error: Inconsistent primary/secondary databases %s", host.getDisplayName(), inconsistentStatus));
            }
        }
        return errors;
    }

    static {
        canHas = new ReentrantReadWriteLock();
        FILTER_SYNCED_DBS = Predicates.and((Predicate)DbFilter.INSTANCE, (Predicate)SyncedDbFilter.INSTANCE);
        FILTER_BOOTED_SYNCED_DBS = Predicates.and(FILTER_SYNCED_DBS, (Predicate)BootedFilter.INSTANCE);
    }

    public static class HostDatabaseCheckListener
    implements EventListener<Hertz> {
        public static void register() {
            Listeners.register(Hertz.class, new HostDatabaseCheckListener());
        }

        @Override
        public void fireEvent(Hertz event) {
            if (BootstrapArgs.isCloudController().booleanValue() && event.isAsserted(60L)) {
                for (String error : Hosts.getHostDatabaseErrors()) {
                    LOG.error((Object)error);
                }
            }
        }
    }

    static enum AwaitDatabase implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host c) {
            if (c != null && (c.isLocalHost() || c.hasBootstrapped().booleanValue())) {
                LOG.info((Object)("Found system view with database: " + c));
                long now = System.currentTimeMillis();
                long coordTime = c.getStartedTime();
                long earliestJoin = coordTime + (long)REJOIN_BACKOFF_SECS * 5L * 1000L;
                if (now > earliestJoin) {
                    return false;
                }
                try {
                    LOG.info((Object)("Waiting for system view to settle till " + earliestJoin + " for coordinator " + coordTime + " (" + (earliestJoin - now) / 1000L + " secs)."));
                    TimeUnit.SECONDS.sleep(REJOIN_BACKOFF_SECS);
                }
                catch (InterruptedException ex) {
                    Exceptions.maybeInterrupted(ex);
                }
                return true;
            }
            try {
                TimeUnit.SECONDS.sleep(3L);
                LOG.info((Object)"Waiting for system view with database...");
            }
            catch (InterruptedException ex) {
                Exceptions.maybeInterrupted(ex);
            }
            return true;
        }
    }

    private static enum Coordinator {
        INSTANCE;

        private final AtomicLong currentStartTime = new AtomicLong(Long.MAX_VALUE);

        public void initialize(Collection<Host> values) {
            long currentTime = System.currentTimeMillis();
            long startTime = values.isEmpty() ? currentTime : Longs.max((long[])Longs.toArray((Collection)Collections2.transform(values, (Function)StartTimeTransform.INSTANCE)));
            long l = startTime = startTime > currentTime ? startTime + 30000L : currentTime;
            if (this.currentStartTime.compareAndSet(Long.MAX_VALUE, startTime)) {
                Hosts.put(Hosts.localHost());
            }
        }

        public void reset() {
            this.currentStartTime.set(Long.MAX_VALUE);
            this.initialize(hostMap.values());
        }

        public Boolean isLocalhost() {
            Host minHost = this.get();
            if (minHost == null && BootstrapArgs.isCloudController().booleanValue()) {
                return true;
            }
            if (minHost != null) {
                return minHost.isLocalHost();
            }
            return false;
        }

        public Host get() {
            List<Host> dbHosts = Hosts.listActiveDatabases();
            return Coordinator.find(dbHosts);
        }

        public Host await() {
            while (!Hosts.isCoordinator() && AwaitDatabase.INSTANCE.apply(Hosts.getCoordinator())) {
            }
            Host coord = this.get();
            if (!BootstrapArgs.isCloudController().booleanValue()) {
                Coordinator.loggedWait(JoinShouldWait.NON_CLOUD_CONTROLLER);
                return JoinShouldWait.NON_CLOUD_CONTROLLER.get();
            }
            Coordinator.loggedWait(JoinShouldWait.CLOUD_CONTROLLER);
            if (coord == null) {
                return Hosts.localHost();
            }
            return coord;
        }

        private static void loggedWait(JoinShouldWait waitFunction) {
            Host h = waitFunction.get();
            while (waitFunction.apply(h)) {
                try {
                    LOG.info((Object)("Waiting for cloud coordinator to become ready: " + h));
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Exceptions.maybeInterrupted(ex);
                }
                h = waitFunction.get();
            }
        }

        private static Host find(List<Host> dbHosts) {
            Host minHost = null;
            for (Host h : dbHosts) {
                if (minHost == null) {
                    minHost = h;
                    continue;
                }
                if (minHost.getStartedTime() > h.getStartedTime()) {
                    minHost = h;
                    continue;
                }
                if (!minHost.getStartedTime().equals(h.getStartedTime()) || minHost.getDisplayName().equals(h.getDisplayName())) continue;
                minHost = minHost.getDisplayName().compareTo(h.getDisplayName()) == -1 ? minHost : h;
            }
            return minHost;
        }

        public long getCurrentStartTime() {
            return this.currentStartTime.get();
        }
    }

    static enum JoinShouldWait implements Predicate<Host>,
    Supplier<Host>
    {
        CLOUD_CONTROLLER{

            @Override
            public boolean apply(Host input) {
                if (input == null) {
                    return false;
                }
                if (!input.hasBootstrapped().booleanValue()) {
                    return true;
                }
                return input.hasSynced() == false;
            }

            @Override
            public Host get() {
                return Coordinator.find(Hosts.listDatabases());
            }
        }
        ,
        NON_CLOUD_CONTROLLER{

            @Override
            public boolean apply(Host input) {
                if (input == null) {
                    return true;
                }
                if (!input.hasBootstrapped().booleanValue()) {
                    return true;
                }
                return input.hasSynced() == false;
            }

            @Override
            public Host get() {
                return Coordinator.find(Hosts.listActiveDatabases());
            }
        };


        public abstract boolean apply(Host var1);

        public abstract Host get();
    }

    static enum DbStatusErrorTransform implements Function<Host.DBStatus, Optional<String>>
    {
        INSTANCE;


        public Optional<String> apply(Host.DBStatus status) {
            return status.getError();
        }
    }

    static enum DbStatusErrorFilter implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            return !Iterables.isEmpty((Iterable)Optional.presentInstances((Iterable)Iterables.transform(input.getDatabaseStatus(), (Function)DbStatusErrorTransform.INSTANCE)));
        }
    }

    static enum NonLocalFilter implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            return !input.isLocalHost();
        }
    }

    static enum SyncedDbFilter implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            return input.hasSynced();
        }
    }

    static enum DbFilter implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            return input.hasDatabase();
        }
    }

    static enum BootedFilter implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            return input.hasBootstrapped();
        }
    }

    static enum EpochTransform implements Function<Host, Integer>
    {
        INSTANCE;


        public Integer apply(Host input) {
            return input.getEpoch();
        }
    }

    static enum GroupAddressTransform implements Function<Host, Address>
    {
        INSTANCE;


        public Address apply(Host input) {
            return input.getGroupsId();
        }
    }

    static enum NameTransform implements Function<Host, String>
    {
        INSTANCE;


        public String apply(Host input) {
            return input.getDisplayName();
        }
    }

    static enum StartTimeTransform implements Function<Host, Long>
    {
        INSTANCE;


        public Long apply(Host input) {
            long startTime = input.isLocalHost() ? 0L : input.getStartedTime();
            return startTime == Long.MAX_VALUE ? 0L : startTime;
        }
    }

    static enum ModifiedTimeTransform implements Function<Host, Long>
    {
        INSTANCE;


        public Long apply(Host input) {
            return input.getTimestamp().getTime();
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.RemoteConfiguration)
    public static class HostMembershipBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            try {
                JChannel jchannel = HostManager.buildChannel();
                LOG.info((Object)("Started membership channel " + SystemIds.membershipGroupName()));
                hostMap = new ReplicatedHashMap((Channel)jchannel);
                hostMap.setBlockingUpdates(true);
                HostManager.start();
                Runnable runMap = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            hostMap.start(STATE_INITIALIZE_TIMEOUT.longValue());
                            OrderedShutdown.registerPreShutdownHook(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        for (Runnable r : PeriodicMembershipChecks.shutdownNow()) {
                                            LOG.info((Object)("SHUTDOWN: Pending host pruning task: " + r));
                                        }
                                    }
                                    catch (Exception ex1) {
                                        LOG.error((Object)ex1, (Throwable)ex1);
                                    }
                                    try {
                                        hostMap.removeNotifier((ReplicatedHashMap.Notification)HostMapStateListener.INSTANCE);
                                        try {
                                            if (Hosts.contains(Internets.localHostIdentifier())) {
                                                Hosts.remove(Internets.localHostIdentifier());
                                            }
                                        }
                                        catch (Exception ex) {
                                            LOG.error((Object)ex, (Throwable)ex);
                                        }
                                        hostMap.stop();
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)ex, (Throwable)ex);
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            Exceptions.maybeInterrupted(ex);
                            System.exit(123);
                        }
                    }
                };
                Timers.loggingWrapper(runMap, hostMap).call();
                LOG.info((Object)("Initial view: " + HostMapStateListener.INSTANCE.printMap("Hosts.load():")));
                LOG.info((Object)("Searching for potential coordinator: " + Hosts.getCoordinator()));
                Coordinator.INSTANCE.await();
                Coordinator.INSTANCE.initialize(hostMap.values());
                LOG.info((Object)("Created local host entry: " + Hosts.localHost()));
                hostMap.addNotifier((ReplicatedHashMap.Notification)HostMapStateListener.INSTANCE);
                LOG.info((Object)("System view: " + HostMapStateListener.INSTANCE.printMap("Hosts.load():")));
                UpdateEntry.INSTANCE.apply(Hosts.localHost());
                LOG.info((Object)("System coordinator: " + Hosts.getCoordinator()));
                Hosts.awaitDatabases();
                LOG.info((Object)("Membership address for localhost: " + Hosts.localHost()));
                for (Host h : hostMap.values()) {
                    BootstrapComponent.REMOTESETUP.apply(h);
                }
                PeriodicMembershipChecks.setup();
                return true;
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                BootstrapException.throwFatal("Failed to connect membership channel because of " + ex.getMessage(), ex);
                return false;
            }
        }
    }

    static class HostManager {
        private final JChannel membershipChannel = HostManager.buildChannel();
        private static HostManager singleton;
        public static short PROTOCOL_ID;
        public static short HEADER_ID;
        private static JChannel singletonChannel;

        private HostManager() {
            try {
                LOG.info((Object)"Starting membership channel... ");
                this.membershipChannel.connect(SystemIds.membershipGroupName());
                HostManager.registerHeader(EpochHeader.class);
                this.membershipChannel.down(new Event(87, (Object)this.membershipChannel.getAddress()));
                LOG.info((Object)("Started membership channel: " + SystemIds.membershipGroupName()));
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                throw BootstrapException.throwFatal("Failed to connect membership channel because of " + ex.getMessage(), ex);
            }
        }

        public static short lookupRegisteredId(Class c) {
            return ClassConfigurator.getMagicNumber((Class)c);
        }

        private static synchronized <T extends Header> String registerHeader(Class<T> h) {
            if (ClassConfigurator.getMagicNumber(h) == -1) {
                HEADER_ID = (short)(HEADER_ID + 1);
                ClassConfigurator.add((short)HEADER_ID, h);
            }
            return "euca-" + (h.isAnonymousClass() ? h.getSuperclass().getSimpleName().toLowerCase() : h.getSimpleName().toLowerCase()) + "-header";
        }

        private static List<Protocol> getMembershipProtocolStack() {
            return (List)Groovyness.run("setup_membership.groovy");
        }

        private static synchronized void start() {
            if (singleton == null) {
                singleton = new HostManager();
            }
        }

        private static synchronized JChannel buildChannel() {
            if (singletonChannel == null) {
                try {
                    JChannel channel = new JChannel(false);
                    channel.setName(Internets.localHostIdentifier());
                    ProtocolStack stack = new ProtocolStack();
                    channel.setProtocolStack(stack);
                    stack.addProtocols(HostManager.getMembershipProtocolStack());
                    stack.init();
                    singletonChannel = channel;
                    return channel;
                }
                catch (Exception ex) {
                    LOG.fatal((Object)ex, (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            return singletonChannel;
        }

        public static JChannel getMembershipChannel() {
            return singletonChannel != null ? singletonChannel : HostManager.buildChannel();
        }

        static {
            PROTOCOL_ID = (short)513;
            HEADER_ID = (short)1025;
        }

        public static class EpochHeader
        extends Header {
            private Integer value;

            public EpochHeader() {
            }

            public EpochHeader(Integer value) {
                this.value = value;
            }

            public void writeTo(DataOutput out) throws Exception {
                out.writeInt(this.value);
            }

            public void readFrom(DataInput in) throws Exception {
                this.value = in.readInt();
            }

            public int size() {
                return 4;
            }

            public Integer getValue() {
                return this.value;
            }
        }
    }

    static enum InitializeAsCloudController implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            if (!BootstrapArgs.isCloudController().booleanValue() && input.isLocalHost() && input.hasDatabase().booleanValue()) {
                try {
                    hostMap.stop();
                }
                catch (Exception ex1) {
                    LOG.error((Object)ex1, (Throwable)ex1);
                }
                try {
                    Bootstrap.initializeSystem();
                    System.exit(123);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    System.exit(123);
                }
                return true;
            }
            return false;
        }
    }

    static enum UpdateEntry implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            if (input == null) {
                Host newHost = Host.create();
                Host oldHost = Hosts.putIfAbsent(newHost);
                if (oldHost != null) {
                    LOG.info((Object)("Inserted local host information:   " + Hosts.localHost()));
                    return true;
                }
                return false;
            }
            if (input.isLocalHost()) {
                if (CheckStale.INSTANCE.apply(input)) {
                    Host newHost = Host.create();
                    Host oldHost = Hosts.put(newHost);
                    if (oldHost != null) {
                        LOG.info((Object)("Updated local host information:   " + Hosts.localHost()));
                        return true;
                    }
                    return false;
                }
                Host newHost = Host.create();
                Host oldHost = Hosts.putIfAbsent(newHost);
                if (oldHost == null) {
                    LOG.info((Object)("Inserted local host information:   " + Hosts.localHost()));
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    static enum CheckStale implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            if (!input.isLocalHost()) {
                return false;
            }
            Host that = Host.create();
            if (that.hasBootstrapped().booleanValue() && !input.hasBootstrapped().booleanValue()) {
                return true;
            }
            if (that.hasDatabase().booleanValue() && !input.hasDatabase().booleanValue()) {
                return true;
            }
            if (that.getEpoch() > input.getEpoch()) {
                return true;
            }
            if (that.hasSynced().booleanValue() && !input.hasSynced().booleanValue()) {
                return true;
            }
            if (!that.getHostAddresses().equals(input.getHostAddresses())) {
                return true;
            }
            return !that.getDatabaseStatus().equals(input.getDatabaseStatus());
        }
    }

    static enum BootstrapComponent implements Predicate<Host>
    {
        SETUP{

            @Override
            public boolean apply(Host input) {
                if (Bootstrap.isShuttingDown().booleanValue()) {
                    return false;
                }
                if (input.hasBootstrapped().booleanValue()) {
                    SyncDatabases.INSTANCE.apply(input);
                    BootstrapComponent.setup(Empyrean.class, input.getBindAddress());
                    if (input.hasDatabase().booleanValue()) {
                        return BootstrapComponent.setup(Eucalyptus.class, input.getBindAddress());
                    }
                    return true;
                }
                return false;
            }
        }
        ,
        TEARDOWN{

            @Override
            public boolean apply(Host input) {
                if (Bootstrap.isShuttingDown().booleanValue() || input.isLocalHost()) {
                    return false;
                }
                try {
                    if (input.hasDatabase().booleanValue()) {
                        Databases.disable(input.getDisplayName());
                        this.removeHost(input);
                    } else {
                        this.removeHost(input);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return false;
                }
                try {
                    this.tryPromoteSelf(input);
                    return true;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return false;
                }
            }

            private void tryPromoteSelf(Host input) {
                if (input.hasDatabase().booleanValue() && BootstrapArgs.isCloudController().booleanValue()) {
                    SETUP.apply(Hosts.localHost());
                    UpdateEntry.INSTANCE.apply(Hosts.localHost());
                }
            }

            private void removeHost(Host input) {
                if (Hosts.isCoordinator()) {
                    Hosts.remove(input.getDisplayName());
                } else if (!Hosts.hasCoordinator() || Hosts.isCoordinator(input)) {
                    Hosts.remove(input.getDisplayName());
                }
                BootstrapComponent.teardown(Empyrean.class, input.getBindAddress());
                if (input.hasDatabase().booleanValue()) {
                    BootstrapComponent.teardown(Eucalyptus.class, input.getBindAddress());
                }
            }
        }
        ,
        REMOTESETUP{

            @Override
            public boolean apply(Host input) {
                if (!input.isLocalHost()) {
                    return SETUP.apply(input);
                }
                return false;
            }
        };


        public abstract boolean apply(Host var1);

        private static <T extends ComponentId> boolean teardown(Class<T> compClass, InetAddress addr) {
            if (Internets.testLocal(addr) || !Bootstrap.isOperational().booleanValue()) {
                return false;
            }
            try {
                HashMap disabled = Maps.newHashMap();
                for (ComponentId c : ShouldLoadRemote.findDependentComponents(compClass, addr)) {
                    try {
                        for (ServiceConfiguration s : Components.lookup(compClass).services()) {
                            try {
                                if (!s.getHostName().equals(addr.getHostAddress())) continue;
                                Future<ServiceConfiguration> disable = Topology.disable(s);
                                disabled.put(s, disable);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex);
                                Logs.extreme().error((Object)ex, (Throwable)ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                }
                Futures.waitAll(disabled);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                return false;
            }
            return true;
        }

        private static <T extends ComponentId> boolean setup(Class<T> compId, InetAddress addr) {
            try {
                Function initFunc = Functions.compose((Function)SetupRemoteServiceConfigurations.INSTANCE, (Function)Hosts.initRemoteSetupConfigurations(addr));
                initFunc.apply(ComponentIds.lookup(compId));
                Collection<ComponentId> deps = ShouldLoadRemote.findDependentComponents(compId, addr);
                Iterables.transform(deps, (Function)initFunc);
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                return false;
            }
        }
    }

    static enum SyncDatabases implements Predicate<Host>
    {
        INSTANCE;


        public boolean apply(Host input) {
            if (!Hosts.contains(input.getGroupsId())) {
                return false;
            }
            if (Hosts.isCoordinator(input) && input.hasBootstrapped().booleanValue() && !input.isLocalHost()) {
                return Databases.enable(input);
            }
            if (input.hasDatabase().booleanValue() && input.hasSynced().booleanValue() && !input.isLocalHost()) {
                return Databases.enable(input);
            }
            if (input.isLocalHost() && !Databases.isSynchronized().booleanValue()) {
                return Databases.enable(input);
            }
            return false;
        }
    }

    static enum HostMapStateListener implements ReplicatedHashMap.Notification<String, Host>
    {
        INSTANCE;

        private static final ExecutorService dbActivation;

        private String printMap(String prefix) {
            String currentView = HostManager.getMembershipChannel().getViewAsString();
            return "\n" + prefix + " " + currentView + "\n" + prefix + " " + Joiner.on((String)("\n" + prefix + " ")).join((Iterable)hostMap.values());
        }

        public void contentsCleared() {
            LOG.info((Object)this.printMap("Hosts.contentsCleared():"));
        }

        public void contentsSet(Map<String, Host> input) {
            LOG.info((Object)this.printMap("Hosts.contentsSet():"));
            if (Bootstrap.isShuttingDown().booleanValue()) {
                return;
            }
            for (Host host : input.values()) {
                HostMapStateListener.updateHostEntry(host);
            }
        }

        public void entryRemoved(final String input) {
            LOG.info((Object)("Hosts.entryRemoved(): " + input));
            dbActivation.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Databases.disable(input);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            });
        }

        public void entrySet(String hostKey, Host host) {
            if (Bootstrap.isShuttingDown().booleanValue()) {
                return;
            }
            LOG.debug((Object)("Hosts.entrySet(): " + hostKey + " => " + host));
            HostMapStateListener.updateHostEntry(host);
            LOG.debug((Object)("Hosts.entrySet(): " + hostKey + " finished."));
        }

        private static void updateHostEntry(final Host host) {
            try {
                final String hostKey = host.getDisplayName();
                if (host.isLocalHost() && host.hasDatabase().booleanValue() && Bootstrap.isLoaded().booleanValue()) {
                    final boolean wasSynched = Databases.isSynchronized();
                    final boolean wasVolatile = Databases.isVolatile();
                    dbActivation.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (!(wasSynched || Databases.SyncState.SYNCING.isCurrent() || Databases.isSynchronized().booleanValue())) {
                                if (Databases.enable(host) && Databases.isSynchronized().booleanValue()) {
                                    UpdateEntry.INSTANCE.apply(Hosts.lookup(hostKey));
                                }
                            } else if (wasVolatile && Bootstrap.isLoaded().booleanValue() && !Databases.ActiveHostSet.ACTIVATED.get().contains(hostKey)) {
                                if (Databases.enable(host) && !Databases.isVolatile().booleanValue()) {
                                    UpdateEntry.INSTANCE.apply(Hosts.lookup(hostKey));
                                }
                            } else if (wasVolatile && Bootstrap.isLoaded().booleanValue() && !Databases.isVolatile().booleanValue()) {
                                UpdateEntry.INSTANCE.apply(Hosts.lookup(hostKey));
                            } else if (Bootstrap.isFinished().booleanValue() && !Databases.isVolatile().booleanValue()) {
                                BootstrapComponent.SETUP.apply(Hosts.lookup(hostKey));
                            }
                        }
                    });
                } else if (Bootstrap.isFinished().booleanValue() && !host.isLocalHost() && host.hasSynced().booleanValue()) {
                    BootstrapComponent.REMOTESETUP.apply(host);
                } else if (InitializeAsCloudController.INSTANCE.apply(host)) {
                    LOG.info((Object)("Hosts.entrySet(): INITIALIZED CLC => " + host));
                } else {
                    Logs.extreme().debug((Object)("Hosts.updateHostEntry(): UPDATED HOST => " + host));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }

        public void viewChange(View currentView, List<Address> joinMembers, List<Address> partMembers) {
            LOG.info((Object)("Hosts.viewChange(): new view [" + currentView.getViewId().getId() + ":" + currentView.getViewId().getCreator() + "]=> " + Joiner.on((String)", ").join((Iterable)currentView.getMembers())));
            LOG.info((Object)this.printMap("Hosts.viewChange(before):"));
            if (!joinMembers.isEmpty()) {
                LOG.info((Object)("Hosts.viewChange(): joined   [" + currentView.getViewId().getId() + ":" + currentView.getViewId().getCreator() + "]=> " + Joiner.on((String)", ").join(joinMembers)));
            }
            if (!partMembers.isEmpty()) {
                LOG.info((Object)("Hosts.viewChange(): parted   [" + currentView.getViewId().getId() + ":" + currentView.getViewId().getCreator() + "]=> " + Joiner.on((String)", ").join(partMembers)));
            }
            List allHostAddresses = Lists.transform(Hosts.list(), (Function)GroupAddressTransform.INSTANCE);
            Collection partedHosts = Collections2.filter((Collection)allHostAddresses, (Predicate)Predicates.in(partMembers));
            for (Address hostAddress : partedHosts) {
                LOG.info((Object)("Hosts.viewChange(): -> removed  => " + hostAddress));
            }
            if (!partMembers.isEmpty()) {
                Threads.lookup(Empyrean.class, Hosts.class, "viewChange").submit(PeriodicMembershipChecks.PRUNING);
            }
            Collection joinedHosts = Collections2.filter((Collection)allHostAddresses, (Predicate)Predicates.in(joinMembers));
            for (Address hostAddress : joinedHosts) {
                LOG.info((Object)("Hosts.viewChange(): -> added    => " + hostAddress));
            }
            if (currentView instanceof MergeView) {
                this.handleMergeView((MergeView)currentView);
            }
            LOG.info((Object)this.printMap("Hosts.viewChange(after):"));
            LOG.info((Object)"Hosts.viewChange(): new view finished.");
        }

        private void handleMergeView(final MergeView mergeView) {
            final Host preMergeCoordinator = Coordinator.INSTANCE.get();
            LOG.info((Object)("Hosts.viewChange(): merge   : pre-merge-coordinator=" + preMergeCoordinator));
            Runnable mergeViews = new Runnable(){
                private final boolean coordinator;
                private final String coordinatorAddress;
                {
                    this.coordinator = preMergeCoordinator.isLocalHost();
                    this.coordinatorAddress = preMergeCoordinator != null ? preMergeCoordinator.getDisplayName() : "NONE";
                }

                private String logPrefix(View v) {
                    ViewId viewId = v == null ? null : v.getViewId();
                    String id = viewId == null ? "?" : Objects.toString(viewId.getId());
                    String creator = viewId == null ? "?" : Objects.toString(viewId.getCreator(), "?");
                    return "Hosts.viewChange(): merge   [" + id + ":" + creator + "]=> ";
                }

                @Override
                public void run() {
                    try {
                        HashMap partitions = Maps.newHashMap();
                        View localView = null;
                        for (View v : mergeView.getSubgroups()) {
                            LOG.info((Object)(this.logPrefix(v) + " localhost-member=" + v.containsMember(Hosts.getLocalGroupAddress()) + "coordinator=[ group=" + v.getViewId().getCreator() + ", system=" + this.coordinatorAddress + ", localhost=" + this.coordinator + "]"));
                            LOG.info((Object)(this.logPrefix(v) + Joiner.on((String)", ").join((Iterable)v.getMembers())));
                            Address viewCoordinator = (Address)v.getMembers().get(0);
                            if (viewCoordinator.equals(Hosts.getLocalGroupAddress())) {
                                localView = v;
                            }
                            try {
                                HostManager.getMembershipChannel().getState((Address)v.getMembers().get(0), 0L);
                            }
                            catch (Exception e) {
                                LOG.error((Object)(this.logPrefix(v) + " failed to merge partition state: " + e.getMessage()));
                                Logs.extreme().error((Object)e, (Throwable)e);
                            }
                            for (Address addr : v.getMembers()) {
                                partitions.put(addr.toString(), v);
                            }
                        }
                        if (BootstrapArgs.isCloudController().booleanValue()) {
                            boolean partitioned = false;
                            HashSet dbViews = Sets.newHashSet();
                            for (Host db : Hosts.listDatabases()) {
                                View dbView = (View)partitions.get(db.getDisplayName());
                                if (!dbView.equals(localView)) {
                                    partitioned = true;
                                }
                                dbViews.add(dbView);
                            }
                            Host newCoordinator = Coordinator.INSTANCE.get();
                            if (!this.coordinatorAddress.equals(newCoordinator.getDisplayName())) {
                                partitioned = true;
                            }
                            if (!partitioned) {
                                return;
                            }
                            if (!newCoordinator.isLocalHost() && this.coordinator) {
                                LOG.error((Object)("PARTITION FAIL-STOP:  Possibility for inconsistency detected for Host: " + Hosts.localHost()));
                                LOG.error((Object)("PARTITION FAIL-STOP: " + HostMapStateListener.this.printMap("Hosts.handleMergeView():")));
                                Databases.Locks.PARTITIONED.create(this.logPrefix(localView) + " found partitioned database in subgroup views: " + Joiner.on((String)", ").join((Iterable)dbViews));
                                Databases.Locks.PARTITIONED.failStop();
                            } else if (newCoordinator.isLocalHost() && this.coordinator) {
                                LOG.error((Object)("PARTITION CONTINUE:  Possibility for inconsistency detected for hosts in the following views: " + Joiner.on((String)", ").join((Iterable)dbViews)));
                            } else if (!newCoordinator.isLocalHost() && !this.coordinator) {
                                LOG.error((Object)("PARTITION RESTART:  Possibility for stale data copy detected for Host: " + Hosts.localHost()));
                                LOG.error((Object)("PARTITION RESTART: " + HostMapStateListener.this.printMap("Hosts.handleMergeView():")));
                                Databases.Locks.PARTITIONED.create(this.logPrefix(localView) + " found different coordinator " + newCoordinator);
                                Databases.Locks.PARTITIONED.failStop();
                            } else if (newCoordinator.isLocalHost() && !this.coordinator) {
                                LOG.error((Object)("PARTITION FAIL-STOP:  Possibility for inconsistency detected for Host: " + Hosts.localHost()));
                                LOG.error((Object)("PARTITION FAIL-STOP: " + HostMapStateListener.this.printMap("Hosts.handleMergeView():")));
                                Databases.Locks.PARTITIONED.create(this.logPrefix(localView) + " found partitioned database in subgroup views: " + Joiner.on((String)", ").join((Iterable)dbViews));
                                Databases.Locks.PARTITIONED.failStop();
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            };
            Threads.newThread(mergeViews).start();
        }

        static {
            dbActivation = Executors.newFixedThreadPool(32);
        }
    }

    static enum PeriodicMembershipChecks implements Runnable
    {
        ENTRYUPDATE(2L){
            private volatile int counter = 0;

            @Override
            public void run() {
                Host currentHost = Hosts.localHost();
                ++this.counter;
                try {
                    if (!Hosts.list((Predicate<Host>)Predicates.not((Predicate)BootedFilter.INSTANCE)).isEmpty() && currentHost.hasDatabase().booleanValue()) {
                        if (UpdateEntry.INSTANCE.apply(currentHost)) {
                            LOG.info((Object)("Updated local host entry while booting: " + currentHost));
                        }
                    } else if (this.counter % 5 == 0) {
                        if (UpdateEntry.INSTANCE.apply(currentHost)) {
                            LOG.info((Object)("Updated changed local host entry: " + currentHost));
                        } else {
                            Logs.extreme().info((Object)("Updated local host entry periodically: " + currentHost));
                            Hosts.put(Host.create());
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                    Logs.extreme().debug((Object)ex, (Throwable)ex);
                }
            }
        }
        ,
        PRUNING(10L){

            @Override
            public void run() {
                if (Hosts.pruneHosts()) {
                    Hosts.updateServices();
                }
            }
        }
        ,
        INITIALIZE(10L){

            @Override
            public void run() {
                Host currentHost = Hosts.localHost();
                if (!BootstrapArgs.isCloudController().booleanValue() && currentHost.hasBootstrapped().booleanValue() && Databases.shouldInitialize()) {
                    System.exit(123);
                }
            }
        }
        ,
        SWITCH_COORDINATOR(10L){
            private volatile boolean wasStoppedLocally = false;

            @Override
            public void run() {
                boolean wasStoppedPreviously = this.wasStoppedLocally;
                boolean stoppedLocally = this.wasStoppedLocally = Hosts.eucalyptusStoppedLocally();
                if (wasStoppedPreviously && stoppedLocally && Hosts.isCoordinator() && Hosts.listDatabases().size() > 1) {
                    LOG.info((Object)("Relinquishing coordinator role: " + Hosts.getCoordinator()));
                    Coordinator.INSTANCE.reset();
                }
            }
        };

        private final long interval;
        private static final ScheduledExecutorService hostPruner;
        private static final Lock canHasChecks;

        private PeriodicMembershipChecks(long interval) {
            this.interval = interval;
        }

        public static void setup() {
            for (final PeriodicMembershipChecks runner : PeriodicMembershipChecks.values()) {
                Runnable safeRunner = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block8: {
                            if (!Bootstrap.isLoaded().booleanValue() || Bootstrap.isShuttingDown().booleanValue()) {
                                return;
                            }
                            try {
                                if (!canHasChecks.tryLock(1L, TimeUnit.SECONDS)) break block8;
                                try {
                                    Logs.extreme().debug((Object)(runner.toString() + ": RUNNING"));
                                    try {
                                        runner.run();
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)(runner.toString() + ": FAILED because of: " + ex.getMessage()));
                                        Logs.extreme().error((Object)(runner.toString() + ": FAILED because of: " + ex.getMessage()), (Throwable)ex);
                                    }
                                }
                                finally {
                                    canHasChecks.unlock();
                                }
                            }
                            catch (Exception ex) {
                                Exceptions.maybeInterrupted(ex);
                                LOG.debug((Object)(runner.toString() + ": SKIPPED: " + ex.getMessage()));
                                Logs.extreme().debug((Object)ex, (Throwable)ex);
                            }
                        }
                    }
                };
                LOG.info((Object)("Registering " + runner + " for execution every " + runner.getInterval() + " seconds"));
                hostPruner.scheduleAtFixedRate(safeRunner, 0L, runner.getInterval(), TimeUnit.SECONDS);
            }
        }

        private long getInterval() {
            return this.interval;
        }

        public String toString() {
            return "Hosts.PeriodicMembershipChecks." + this.name();
        }

        public static List<Runnable> shutdownNow() {
            return hostPruner.shutdownNow();
        }

        public void submit() {
            hostPruner.execute(this);
        }

        static {
            hostPruner = Executors.newScheduledThreadPool(32);
            canHasChecks = new ReentrantLock();
        }
    }

    static enum ShouldLoadRemote implements Predicate<ComponentId>
    {
        EMPYREAN(Empyrean.class),
        EUCALYPTUS(Eucalyptus.class);

        Predicate<ComponentId> delegate;
        Class<? extends ComponentId> compId;

        private ShouldLoadRemote(final Class<? extends ComponentId> compId) {
            this.delegate = new Predicate<ComponentId>(){

                public boolean apply(ComponentId input) {
                    return input.isAncestor(compId) && !input.isRegisterable();
                }
            };
            this.compId = compId;
        }

        public boolean apply(ComponentId input) {
            return this.delegate.apply((Object)input);
        }

        public static Collection<ComponentId> findDependentComponents(Class<? extends ComponentId> comp, InetAddress addr) {
            return Collections2.filter(ComponentIds.list(), (Predicate)Predicates.and((Predicate)(ShouldLoadRemote.EMPYREAN.compId.equals(comp) ? EMPYREAN : EUCALYPTUS), Hosts.nonLocalAddressFilter(addr)));
        }
    }

    static enum SetupRemoteServiceConfigurations implements Function<ServiceConfiguration, ServiceConfiguration>
    {
        INSTANCE;


        public ServiceConfiguration apply(ServiceConfiguration input) {
            boolean inputIsLocal = Internets.testLocal(input.getHostName());
            if (!Bootstrap.isFinished().booleanValue() || Component.State.STOPPED.apply(input)) {
                return input;
            }
            Component.State goalState = input.getComponentId().isAlwaysLocal().booleanValue() ? Component.State.ENABLED : (BootstrapArgs.isCloudController().booleanValue() ? (inputIsLocal && Hosts.isCoordinator() ? Component.State.ENABLED : (!inputIsLocal && !Hosts.isCoordinator() ? Component.State.ENABLED : Component.State.DISABLED)) : (Hosts.isCoordinator(input.getInetAddress()) ? Component.State.ENABLED : Component.State.DISABLED));
            if (Component.State.ENABLED.apply(input) && Component.State.ENABLED.equals(goalState)) {
                return input;
            }
            if (Component.State.DISABLED.apply(input) && Component.State.DISABLED.equals(goalState)) {
                return input;
            }
            LOG.info((Object)("SetupRemoteServiceConfigurations: " + goalState + " " + (inputIsLocal ? "local" : "remote") + " " + (input.getComponentId().isAlwaysLocal() != false ? "bootstrap" : "cloud") + " services" + (Hosts.isCoordinator(input.getInetAddress()) ? " (coordinator)" : "") + ": " + input.getFullName()));
            try {
                return (ServiceConfiguration)((Future)Topology.transition(goalState).apply((Object)input)).get();
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                Exceptions.trace(ex.getCause());
            }
            return input;
        }
    }
}

