/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Topology;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;
import org.jgroups.Address;

public class Host
implements Serializable,
Comparable<Host> {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(Host.class);
    private final String displayName;
    private final Address groupsId;
    private final InetAddress bindAddress;
    private final ImmutableList<InetAddress> hostAddresses;
    private final Boolean hasDatabase;
    private final Boolean hasSynced;
    private final Boolean hasBootstrapped;
    private final AtomicLong timestamp = new AtomicLong(System.currentTimeMillis());
    private final Long startedTime;
    private final Integer epoch;
    private final ImmutableList<DBStatus> databaseStatus;

    Host(String displayName, Address groupsId, InetAddress bindAddress, ImmutableList<InetAddress> hostAddresses, Boolean hasDatabase, Boolean hasSynced, Boolean hasBootstrapped, Long startedTime, Integer epoch, ImmutableList<DBStatus> databaseStatus) {
        this.displayName = displayName;
        this.groupsId = groupsId;
        this.bindAddress = bindAddress;
        this.hostAddresses = hostAddresses;
        this.hasDatabase = hasDatabase;
        this.hasSynced = hasSynced;
        this.hasBootstrapped = hasBootstrapped;
        this.startedTime = startedTime;
        this.epoch = epoch;
        this.databaseStatus = databaseStatus;
    }

    Host() {
        this(Internets.localHostIdentifier(), Hosts.getLocalGroupAddress(), Internets.localHostInetAddress(), (ImmutableList<InetAddress>)ImmutableList.copyOf((Collection)Ordering.from(Internets.INET_ADDRESS_COMPARATOR).sortedCopy(Internets.getAllInetAddresses())), BootstrapArgs.isCloudController(), Databases.isSynchronized(), Bootstrap.isFinished(), Hosts.getStartTime(), Topology.epoch(), Hosts.getDBStatus());
    }

    public static Host create() {
        return new Host();
    }

    public Address getGroupsId() {
        return this.groupsId;
    }

    public ImmutableList<InetAddress> getHostAddresses() {
        return this.hostAddresses;
    }

    public ImmutableList<DBStatus> getDatabaseStatus() {
        return this.databaseStatus;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public Boolean hasDatabase() {
        return this.hasDatabase;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Host other = (Host)obj;
        return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
    }

    @Override
    public int compareTo(Host that) {
        return this.getDisplayName().compareTo(that.getDisplayName());
    }

    public boolean isLocalHost() {
        return Internets.testLocal(this.getBindAddress());
    }

    public Boolean hasBootstrapped() {
        return this.hasBootstrapped;
    }

    public Integer getEpoch() {
        return this.epoch;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Host ").append(this.groupsId).append(" ").append("#").append(this.epoch).append(" ").append(this.bindAddress).append(" ");
        try {
            Host coordinator = Hosts.getCoordinator();
            String coordinatorName = coordinator != null ? coordinator.getDisplayName() : "pending";
            builder.append("coordinator=").append(coordinatorName).append(" ");
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        Databases.SyncState synched = Databases.SyncState.get();
        boolean volat = Databases.isVolatile();
        builder.append(this.hasBootstrapped != false ? "booted " : "booting ").append(this.hasDatabase.booleanValue() ? (this.hasSynced.booleanValue() ? "db:synched" : "db:outofdate") : "nodb");
        if (this.isLocalHost()) {
            builder.append("(").append(synched.name().toLowerCase()).append(") ").append(volat ? "dbpool:volatile" : "dbpool:ok");
        }
        builder.append(" started=").append(this.startedTime).append(" ").append(this.hostAddresses);
        return builder.toString();
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.get());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getStartedTime() {
        return this.startedTime;
    }

    public Boolean hasSynced() {
        return this.hasSynced;
    }

    public static final class DBStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final ImmutableList<String> activePrimary;
        private final ImmutableList<String> activeSecondary;
        private final ImmutableList<String> inactive;

        public DBStatus(String name, Collection<String> activePrimary, Collection<String> activeSecondary, Collection<String> inactive) {
            Parameters.checkParam("Database name required", name, Matchers.notNullValue());
            this.name = name;
            this.activePrimary = ImmutableList.copyOf(activePrimary);
            this.activeSecondary = ImmutableList.copyOf(activeSecondary);
            this.inactive = ImmutableList.copyOf(inactive);
        }

        public String getName() {
            return this.name;
        }

        public ImmutableList<String> getActivePrimaries() {
            return this.activePrimary;
        }

        public ImmutableList<String> getActiveSecondaries() {
            return this.activeSecondary;
        }

        public ImmutableList<String> getInactive() {
            return this.inactive;
        }

        public Optional<String> getError() {
            Optional error = Optional.absent();
            if (this.getActivePrimaries().isEmpty() && !this.getActiveSecondaries().isEmpty()) {
                error = Optional.of((Object)String.format("Primary database not defined for %s: %s", this.getName(), this.getActiveSecondaries()));
            } else if (this.getActivePrimaries().size() > 1) {
                error = Optional.of((Object)String.format("Multiple primary databases defined for %s: %s", this.getName(), this.getActivePrimaries()));
            } else if (!this.getInactive().isEmpty()) {
                error = Optional.of((Object)String.format("Inactive databases for %s: %s", this.getName(), this.getInactive()));
            }
            return error;
        }

        public boolean consistentWith(DBStatus status) {
            return this.getActivePrimaries().equals(status.getActivePrimaries()) && this.getActiveSecondaries().equals(status.getActiveSecondaries());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DBStatus dbStatus = (DBStatus)o;
            if (!this.activePrimary.equals(dbStatus.activePrimary)) {
                return false;
            }
            if (!this.activeSecondary.equals(dbStatus.activeSecondary)) {
                return false;
            }
            if (!this.inactive.equals(dbStatus.inactive)) {
                return false;
            }
            return this.name.equals(dbStatus.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.activePrimary.hashCode();
            result = 31 * result + this.activeSecondary.hashCode();
            result = 31 * result + this.inactive.hashCode();
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("primaries", this.getActivePrimaries()).add("secondaries", this.getActiveSecondaries()).toString();
        }
    }
}

