/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DatabaseBootstrapper;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.id.Database;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.Mbeans;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.async.Futures;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.sql.Sql;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.persistence.LockTimeoutException;
import org.apache.log4j.Logger;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class Databases {
    private static final Logger LOG = Logger.getLogger(Databases.class);
    private static final int MAX_DEACTIVATION_RETRIES = 10;
    private static final int MAX_TX_START_SYNC_RETRIES = 120;
    private static final AtomicInteger counter = new AtomicInteger(500);
    private static final Predicate<Host> FILTER_SYNCING_DBS = Predicates.and((Predicate)Hosts.DbFilter.INSTANCE, (Predicate)Predicates.not((Predicate)Hosts.SyncedDbFilter.INSTANCE));
    private static final ScriptedDbBootstrapper singleton = new ScriptedDbBootstrapper();
    private static final String jdbcJmxDomain = "net.sf.hajdbc";
    private static final ExecutorService dbSyncExecutors = Executors.newCachedThreadPool();
    private static final ReentrantReadWriteLock canHas = new ReentrantReadWriteLock();
    private static Supplier<Set<String>> activeHosts = Suppliers.memoizeWithExpiration((Supplier)ActiveHostSet.ACTIVATED, (long)2L, (TimeUnit)TimeUnit.SECONDS);
    private static Supplier<Set<String>> hostDatabases = Suppliers.memoizeWithExpiration((Supplier)ActiveHostSet.DBHOSTS, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    private static Predicate<StackTraceElement> notStackFilterYouAreLookingFor = Predicates.or((Predicate[])new Predicate[]{Threads.filterStackByQualifiedName("com\\.eucalyptus\\.entities\\..*"), Threads.filterStackByQualifiedName("java\\.lang\\.Thread.*"), Threads.filterStackByQualifiedName("com\\.eucalyptus\\.system\\.Threads.*"), Threads.filterStackByQualifiedName("com\\.eucalyptus\\.bootstrap\\.Databases.*")});
    private static Predicate<StackTraceElement> stackFilter = Predicates.not(notStackFilterYouAreLookingFor);
    private static final int DATABASE_WEIGHT_PRIMARY = 100;
    private static final int DATABASE_WEIGHT_SECONDARY = 1;

    public static Iterable<String> databases() {
        return Sets.newTreeSet((Iterable)Iterables.transform(PersistenceContexts.list(), PersistenceContexts.toDatabaseName()));
    }

    public static Iterable<String> remoteDatabases() {
        return Sets.newTreeSet(PersistenceContexts.listRemotable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runDbStateChange(Function<String, Runnable> runnableFunction) {
        block9: {
            Logs.extreme().info((Object)("DB STATE CHANGE: " + runnableFunction));
            try {
                Logs.extreme().info((Object)("Attempting to acquire db state lock: " + runnableFunction));
                if (canHas.writeLock().tryLock(5L, TimeUnit.MINUTES)) {
                    try {
                        Logs.extreme().info((Object)("Acquired db state lock: " + runnableFunction));
                        HashMap runnables = Maps.newHashMap();
                        for (String database : Databases.listDatabases()) {
                            Runnable run = (Runnable)runnableFunction.apply((Object)database);
                            runnables.put(run, ExecuteRunnable.INSTANCE.apply(run));
                        }
                        Map succeeded = Futures.waitAll(runnables);
                        MapDifference failed = Maps.difference((Map)runnables, succeeded);
                        StringBuilder builder = new StringBuilder();
                        builder.append(Joiner.on((String)"\nSUCCESS: ").join(succeeded.keySet()));
                        builder.append(Joiner.on((String)"\nFAILED:  ").join(failed.entriesOnlyOnLeft().keySet()));
                        Logs.extreme().debug((Object)builder.toString());
                        if (!failed.entriesOnlyOnLeft().isEmpty()) {
                            throw Exceptions.toUndeclared((String)builder.toString(), (Throwable[])new Throwable[0]);
                        }
                        break block9;
                    }
                    finally {
                        canHas.writeLock().unlock();
                    }
                }
                throw new LockTimeoutException("DB STATE CHANGE ABORTED (failed to get lock): " + runnableFunction);
            }
            catch (RuntimeException ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            catch (InterruptedException ex) {
                Exceptions.maybeInterrupted(ex);
                throw Exceptions.toUndeclared(ex);
            }
        }
    }

    private static void resetDatabaseWeights(String contextName) {
        for (Host host : Hosts.listActiveDatabases()) {
            try {
                Databases.lookupDatabase(contextName, host.getDisplayName()).setweight(Hosts.isCoordinator(host) ? 100 : 1);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Exception e) {
                LOG.error((Object)("Error resetting weight for host " + host.getDisplayName() + " context " + contextName), (Throwable)e);
            }
        }
    }

    private static DatabaseClusterMBean lookup(String database, long timeout) throws NoSuchElementException {
        return Databases.lookupMBean((Map<String, String>)ImmutableMap.of((Object)"cluster", (Object)database, (Object)"type", (Object)"DatabaseCluster"), DatabaseClusterMBean.class, new Predicate<DatabaseClusterMBean>(){

            public boolean apply(DatabaseClusterMBean cluster) {
                cluster.getinactiveDatabases();
                return true;
            }
        }, timeout);
    }

    private static DriverDatabaseMBean lookupDatabase(String database, String hostName) throws NoSuchElementException {
        return Databases.lookupMBean((Map<String, String>)ImmutableMap.of((Object)"cluster", (Object)database, (Object)"type", (Object)"Database", (Object)"database", (Object)hostName), DriverDatabaseMBean.class, new Predicate<DriverDatabaseMBean>(){

            public boolean apply(DriverDatabaseMBean database) {
                database.getid();
                return true;
            }
        }, 0L);
    }

    private static <T> T lookupMBean(Map<String, String> props, Class<T> type, Predicate<T> tester, long timeout) {
        long until = System.currentTimeMillis() + timeout;
        while (true) {
            try {
                T bean = Mbeans.lookup(jdbcJmxDomain, props, type);
                tester.apply(bean);
                return bean;
            }
            catch (UndeclaredThrowableException e) {
                block8: {
                    block7: {
                        if (Exceptions.isCausedBy(e, InstanceNotFoundException.class)) {
                            if (System.currentTimeMillis() < until) {
                                try {
                                    TimeUnit.SECONDS.sleep(5L);
                                    break block7;
                                }
                                catch (InterruptedException e1) {
                                    Thread.interrupted();
                                    break block8;
                                }
                            }
                            throw new NoSuchElementException(type.getSimpleName() + " " + props.toString());
                        }
                        throw Exceptions.toUndeclared(e);
                    }
                    LOG.debug((Object)("Waiting for MBean " + type.getSimpleName() + "/" + props));
                    if (System.currentTimeMillis() < until) continue;
                }
                throw new NoSuchElementException(type.getSimpleName() + " " + props.toString());
            }
            break;
        }
    }

    static boolean disable(String hostName) {
        if (!Bootstrap.isFinished().booleanValue()) {
            return false;
        }
        if (Internets.testLocal(hostName)) {
            return true;
        }
        try {
            Databases.runDbStateChange(DeactivateHostFunction.INSTANCE.apply(hostName));
            return true;
        }
        catch (Exception ex) {
            Logs.extreme().debug((Object)ex);
            return false;
        }
    }

    static boolean enable(Host host) {
        if (!host.hasDatabase().booleanValue() || Bootstrap.isShuttingDown().booleanValue()) {
            return false;
        }
        if (!Hosts.contains(host.getGroupsId())) {
            Hosts.remove(host.getGroupsId());
            return false;
        }
        if (host.isLocalHost()) {
            if (SyncState.SYNCING.set()) {
                try {
                    Databases.runDbStateChange(ActivateHostFunction.INSTANCE.apply(host));
                    SyncState.SYNCED.set();
                    return true;
                }
                catch (LockTimeoutException ex) {
                    SyncState.NOTSYNCED.set();
                    return false;
                }
                catch (Exception ex) {
                    SyncState.NOTSYNCED.set();
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    return false;
                }
            }
            if (!SyncState.SYNCING.isCurrent()) {
                try {
                    Databases.runDbStateChange(ActivateHostFunction.INSTANCE.apply(host));
                    return true;
                }
                catch (LockTimeoutException ex) {
                    return false;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    return false;
                }
            }
            try {
                Databases.runDbStateChange(ActivateHostFunction.INSTANCE.apply(host));
                SyncState.SYNCED.set();
                return true;
            }
            catch (LockTimeoutException ex) {
                SyncState.NOTSYNCED.set();
                return false;
            }
            catch (Exception ex) {
                SyncState.NOTSYNCED.set();
                LOG.error((Object)ex, (Throwable)ex);
                return false;
            }
        }
        if (!ActiveHostSet.ACTIVATED.get().contains(host.getDisplayName())) {
            try {
                Databases.runDbStateChange(ActivateHostFunction.INSTANCE.apply(host));
                return true;
            }
            catch (LockTimeoutException ex) {
                return false;
            }
            catch (Exception ex) {
                Logs.extreme().debug((Object)ex);
                ActivateHostFunction.rollback(host, ex);
                return false;
            }
        }
        return ActiveHostSet.ACTIVATED.get().contains(host.getDisplayName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean shouldInitialize() {
        String context = "eucalyptus_config";
        String databaseName = (String)PersistenceContexts.toDatabaseName().apply((Object)"eucalyptus_config");
        String schemaName = (String)PersistenceContexts.toSchemaName().apply((Object)"eucalyptus_config");
        String schemaPrefix = schemaName == null ? "" : schemaName + ".";
        Iterator<Host> i$ = Hosts.listActiveDatabases().iterator();
        block38: while (i$.hasNext()) {
            Host h = i$.next();
            String url2 = String.format("jdbc:%s", ServiceUris.remote(Database.class, h.getBindAddress(), databaseName));
            try {
                Connection conn = DriverManager.getConnection(url2, Databases.getUserName(), Databases.getPassword());
                Throwable throwable = null;
                try {
                    PreparedStatement statement = conn.prepareStatement("select config_component_hostname from " + schemaPrefix + "config_component_base where config_component_partition='eucalyptus';");
                    Throwable throwable2 = null;
                    try {
                        ResultSet result = statement.executeQuery();
                        Throwable throwable3 = null;
                        try {
                            Object columnValue;
                            do {
                                if (!result.next()) continue block38;
                            } while (!Internets.testLocal((columnValue = result.getObject(1)).toString()));
                            boolean bl = true;
                            return bl;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (result == null) continue;
                            if (throwable3 != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable x2) {
                                    throwable3.addSuppressed(x2);
                                }
                                continue;
                            }
                            result.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (conn == null) continue;
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    conn.close();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return false;
    }

    static Set<String> listPrimaryActiveDatabases(String cluster) {
        return Databases.listDatabases(cluster, true, (Optional<Integer>)Optional.of((Object)100));
    }

    static Set<String> listSecondaryActiveDatabases(String cluster) {
        return Databases.listDatabases(cluster, true, (Optional<Integer>)Optional.of((Object)1));
    }

    static Set<String> listInactiveDatabases(String cluster) {
        return Databases.listDatabases(cluster, false, (Optional<Integer>)Optional.absent());
    }

    private static Set<String> listDatabases(String clusterName, boolean active, Optional<Integer> weight) {
        LinkedHashSet databases = Sets.newLinkedHashSet();
        try {
            DatabaseClusterMBean cluster = Databases.lookup(clusterName, 0L);
            Set<String> databaseIds = active ? cluster.getactiveDatabases() : cluster.getinactiveDatabases();
            for (String databaseId : databaseIds) {
                try {
                    DriverDatabaseMBean database = Databases.lookupDatabase(clusterName, databaseId);
                    if (weight.isPresent() && database.getweight() != ((Integer)weight.get()).intValue()) continue;
                    databases.add(databaseId);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (NoSuchElementException cluster) {
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return databases;
    }

    static Set<String> listRegisteredDatabases() {
        return Mbeans.listPropertyValues(jdbcJmxDomain, "cluster", (Map<String, String>)ImmutableMap.of((Object)"type", (Object)"DatabaseCluster"));
    }

    static Set<String> listDatabases() {
        HashSet dbNames = Sets.newHashSet();
        Predicate dbNamePredicate = Predicates.or(Strings.startsWith("eucalyptus_"), (Predicate)Predicates.equalTo((Object)"database_events"));
        for (Host h : Hosts.listActiveDatabases()) {
            Iterables.addAll((Collection)dbNames, (Iterable)Iterables.filter(Databases.getBootstrapper().listDatabases(h.getBindAddress()), (Predicate)dbNamePredicate));
        }
        return dbNames;
    }

    public static Boolean isSynchronized() {
        return SyncState.SYNCED.isCurrent();
    }

    public static Boolean isVolatile() {
        if (!Bootstrap.isFinished().booleanValue() || BootstrapArgs.isInitializeSystem()) {
            return false;
        }
        if (!Hosts.isCoordinator() && BootstrapArgs.isCloudController().booleanValue()) {
            return Databases.isSynchronized() == false || !((Set)activeHosts.get()).containsAll((Collection)hostDatabases.get());
        }
        if (!((Set)activeHosts.get()).equals(hostDatabases.get())) {
            return true;
        }
        return !Hosts.list(FILTER_SYNCING_DBS).isEmpty();
    }

    public static void awaitSynchronized() {
        if (!Databases.isVolatile().booleanValue()) {
            return;
        }
        Collection<StackTraceElement> stack = Threads.filteredStack(stackFilter);
        String caller = stack.isEmpty() ? "" : stack.iterator().next().toString();
        for (int i = 0; i < 120 && Databases.isVolatile().booleanValue(); ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                LOG.debug((Object)("Transaction blocked on sync: " + caller));
                continue;
            }
            catch (InterruptedException ex) {
                Exceptions.maybeInterrupted(ex);
                return;
            }
        }
        if (Databases.isVolatile().booleanValue()) {
            throw new DatabaseStateException("Transaction begin failed due to concurrent database synchronization: " + Hosts.listDatabases() + " for caller:\n" + Joiner.on((String)"\n\tat ").join(stack));
        }
    }

    public static String getUserName() {
        return singleton.getUserName();
    }

    public static String getPassword() {
        return singleton.getPassword();
    }

    public static String getDriverName() {
        return singleton.getDriverName();
    }

    public static String getDefaultSchemaName() {
        return singleton.getDefaultSchemaName();
    }

    public static String getJdbcDialect() {
        return singleton.getJdbcDialect();
    }

    public static String getHibernateDialect() {
        return singleton.getHibernateDialect();
    }

    public static DatabaseBootstrapper getBootstrapper() {
        return singleton;
    }

    public static void initialize() {
        singleton.init();
    }

    public static boolean isRunning() {
        try {
            return singleton.check();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return false;
        }
    }

    public static String getServicePath(String ... pathParts) {
        return singleton.getServicePath(pathParts);
    }

    public static Map<String, String> getJdbcUrlQueryParameters() {
        return singleton.getJdbcUrlQueryParameters();
    }

    public static String getJdbcScheme() {
        return singleton.getJdbcScheme();
    }

    public static void check() {
        for (String database : Databases.databases()) {
            try {
                DatabaseClusterMBean db = Databases.lookup(database, TimeUnit.SECONDS.toMillis(5L));
                for (String host : db.getactiveDatabases()) {
                    Host hostEntry = Hosts.lookup(host);
                    if (hostEntry == null) {
                        Databases.disable(host);
                        continue;
                    }
                    if (Hosts.contains(hostEntry.getGroupsId())) continue;
                    Hosts.remove(host);
                }
            }
            catch (NoSuchElementException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private static interface DriverDatabaseMBean {
        public boolean isActive();

        public String getid();

        public void setuser(String var1);

        public void setpassword(String var1);

        public int getweight();

        public void setweight(int var1);

        public void setlocal(boolean var1);

        public void setlocation(String var1);
    }

    private static interface DatabaseClusterMBean {
        public Set<String> getinactiveDatabases();

        public Set<String> getactiveDatabases();

        public void add(String var1);

        public void remove(String var1);

        public void activate(String var1, String var2);

        public void deactivate(String var1);

        public Set<String> getsynchronizationStrategies();

        public String getdefaultSynchronizationStrategy();
    }

    @RunDuring(value=Bootstrap.Stage.DatabaseInit)
    @Provides(value=Empyrean.class)
    @DependsLocal(value={Eucalyptus.class})
    public static class ScriptedDbBootstrapper
    extends Bootstrapper.Simple
    implements DatabaseBootstrapper {
        DatabaseBootstrapper db;

        public ScriptedDbBootstrapper() {
            try {
                this.db = (DatabaseBootstrapper)Groovyness.newInstance("setup_db");
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public boolean load() throws Exception {
            boolean result = this.db.load();
            Events.create();
            return result;
        }

        @Override
        public boolean start() throws Exception {
            return this.db.start();
        }

        @Override
        public boolean stop() throws Exception {
            return this.db.stop();
        }

        @Override
        public void destroy() throws Exception {
            this.db.destroy();
        }

        @Override
        public boolean isRunning() {
            return this.db.isRunning();
        }

        @Override
        public void hup() {
            this.db.hup();
        }

        @Override
        public String getUserName() {
            return this.db.getUserName();
        }

        @Override
        public String getPassword() {
            return this.db.getPassword();
        }

        @Override
        public String getDefaultSchemaName() {
            return this.db.getDefaultSchemaName();
        }

        @Override
        public String getDriverName() {
            return this.db.getDriverName();
        }

        @Override
        public String getJdbcDialect() {
            return this.db.getJdbcDialect();
        }

        @Override
        public String getHibernateDialect() {
            return this.db.getHibernateDialect();
        }

        @Override
        public void init() {
            try {
                this.db.init();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }

        public static DatabaseBootstrapper getInstance() {
            return singleton;
        }

        @Override
        public String getServicePath(String ... pathParts) {
            return this.db.getServicePath(pathParts);
        }

        @Override
        public Map<String, String> getJdbcUrlQueryParameters() {
            return this.db.getJdbcUrlQueryParameters();
        }

        @Override
        public boolean check() throws Exception {
            return this.db.isRunning();
        }

        @Override
        public String getJdbcScheme() {
            return this.db.getJdbcScheme();
        }

        @Override
        public List<String> listDatabases() {
            return this.db.listDatabases();
        }

        @Override
        public List<String> listDatabases(InetAddress host) {
            return this.db.listDatabases(host);
        }

        @Override
        public List<String> listSchemas(String database) {
            return this.db.listSchemas(database);
        }

        @Override
        public List<String> listSchemas(InetAddress host, String database) {
            return this.db.listSchemas(host, database);
        }

        @Override
        public List<String> listTables(String database, String schema) {
            return this.db.listTables(database, schema);
        }

        @Override
        public void createDatabase(String database) {
            this.db.createDatabase(database);
        }

        @Override
        public void deleteDatabase(String database) {
            this.db.deleteDatabase(database);
        }

        @Override
        public void renameDatabase(String from, String to) {
            this.db.renameDatabase(from, to);
        }

        @Override
        public void copyDatabase(String sourceDatabase, String destinationDatabase) {
            this.db.copyDatabase(sourceDatabase, destinationDatabase);
        }

        @Override
        public void copyDatabaseSchema(String sourceDatabase, String sourceSchema, String destinationDatabase, String destinationSchema) {
            this.db.copyDatabaseSchema(sourceDatabase, sourceSchema, destinationDatabase, destinationSchema);
        }

        @Override
        public Sql getConnection(String context) throws Exception {
            return this.db.getConnection(context);
        }

        @Override
        public Sql getConnection(String database, String schema) throws Exception {
            return this.db.getConnection(database, schema);
        }
    }

    static enum ActiveHostSet implements Supplier<Set<String>>
    {
        ACTIVATED{

            @Override
            public Set<String> get() {
                Object hosts = DBHOSTS.get();
                HashSet union = Sets.newHashSet();
                HashSet intersection = Sets.newHashSet((Iterable)hosts);
                Logs.extreme().debug((Object)("ActiveHostSet: universe of db hosts: " + hosts));
                for (String database : Databases.databases()) {
                    try {
                        Set<String> activeDatabases = Databases.lookup(database, 0L).getactiveDatabases();
                        if (BootstrapArgs.isCloudController().booleanValue()) {
                            activeDatabases.add(Internets.localHostIdentifier());
                        }
                        union.addAll(activeDatabases);
                        intersection.retainAll(activeDatabases);
                    }
                    catch (Exception exception) {}
                }
                Logs.extreme().debug((Object)("ActiveHostSet: union of activated db connections: " + union));
                Logs.extreme().debug((Object)("ActiveHostSet: intersection of db hosts and activated db connections: " + intersection));
                boolean dbVolatile = !hosts.equals(intersection);
                String msg = String.format("ActiveHostSet: %-14.14s %s%s%s", dbVolatile ? "volatile" : "synchronized", hosts, dbVolatile ? "!=" : "=", intersection);
                if (dbVolatile) {
                    if (last.compareAndSet(false, dbVolatile)) {
                        LOG.warn((Object)msg);
                    } else {
                        LOG.debug((Object)msg);
                    }
                } else if (last.compareAndSet(true, dbVolatile)) {
                    LOG.warn((Object)msg);
                } else {
                    Logs.extreme().info((Object)msg);
                }
                return intersection;
            }
        }
        ,
        DBHOSTS{

            @Override
            public Set<String> get() {
                return Sets.newHashSet((Iterable)Collections2.transform(Hosts.listDatabases(), (Function)Hosts.NameTransform.INSTANCE));
            }
        };

        private static final AtomicBoolean last;

        public abstract Set<String> get();

        static {
            last = new AtomicBoolean(false);
        }
    }

    static enum ActivateHostFunction implements Function<Host, Function<String, Runnable>>
    {
        INSTANCE;


        private static void prepareConnections(Host host, String contextName) throws NoSuchElementException {
            String dbUrl = "jdbc:" + ServiceUris.remote(Database.class, host.getBindAddress(), contextName);
            String hostName = host.getDisplayName();
            DriverDatabaseMBean database = Databases.lookupDatabase(contextName, hostName);
            database.setuser(Databases.getUserName());
            database.setpassword(Databases.getPassword());
            database.setweight(Hosts.isCoordinator(host) ? 100 : 1);
            database.setlocal(host.isLocalHost());
            database.setlocation(dbUrl);
        }

        public Function<String, Runnable> apply(final Host host) {
            return new Function<String, Runnable>(){

                public Runnable apply(final String database) {
                    final String hostName = host.getBindAddress().getHostAddress();
                    return new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String syncStrategy;
                                boolean passiveSync;
                                boolean fullSync = !Hosts.isCoordinator() && host.isLocalHost() && BootstrapArgs.isCloudController() != false && Databases.isSynchronized() == false;
                                boolean bl = passiveSync = !fullSync && host.hasSynced() != false;
                                if (!fullSync && !passiveSync) {
                                    throw Exceptions.toUndeclared((String)("Host is not ready to be activated: " + host), (Throwable[])new Throwable[0]);
                                }
                                DatabaseClusterMBean cluster = Databases.lookup(database, TimeUnit.SECONDS.toMillis(30L));
                                boolean activated = cluster.getactiveDatabases().contains(hostName);
                                boolean deactivated = cluster.getinactiveDatabases().contains(hostName);
                                String passiveStrategy = cluster.getdefaultSynchronizationStrategy();
                                String fullStrategy = (String)Iterables.getFirst((Iterable)Sets.difference(cluster.getsynchronizationStrategies(), Collections.singleton(passiveStrategy)), (Object)"full");
                                String string = syncStrategy = fullSync ? fullStrategy : passiveStrategy;
                                if (activated) {
                                    Databases.resetDatabaseWeights(database);
                                    return;
                                }
                                if (deactivated) {
                                    ActivateHostFunction.prepareConnections(host, database);
                                } else {
                                    block26: {
                                        LOG.info((Object)("Creating database " + database + " connections for: " + host));
                                        try {
                                            Databases.lookupDatabase(database, hostName);
                                        }
                                        catch (NoSuchElementException e) {
                                            try {
                                                cluster.add(hostName);
                                                Logs.extreme().debug((Object)("Added database " + database + " connections for host: " + hostName));
                                            }
                                            catch (IllegalArgumentException ex) {
                                                Logs.extreme().debug((Object)("Skipping addition of database " + database + " connections for host which already exists: " + hostName));
                                            }
                                            catch (IllegalStateException ex) {
                                                if (Exceptions.isCausedBy(ex, InstanceAlreadyExistsException.class)) {
                                                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(Databases.jdbcJmxDomain, new Hashtable<String, String>((Map<String, String>)ImmutableMap.of((Object)"cluster", (Object)database, (Object)"type", (Object)"Database", (Object)"database", (Object)hostName))));
                                                    cluster.add(hostName);
                                                    break block26;
                                                }
                                                throw ex;
                                            }
                                        }
                                    }
                                    ActivateHostFunction.prepareConnections(host, database);
                                }
                                if (Hosts.isCoordinator(host)) {
                                    for (Host secondaryHost : Hosts.listActiveDatabases()) {
                                        if (secondaryHost.equals(host)) continue;
                                        try {
                                            Databases.lookupDatabase(database, secondaryHost.getDisplayName()).setweight(1);
                                        }
                                        catch (NoSuchElementException noSuchElementException) {
                                        }
                                        catch (Exception e) {
                                            LOG.error((Object)("Error setting primary weight for host " + secondaryHost.getDisplayName() + " context " + database), (Throwable)e);
                                        }
                                    }
                                }
                                try {
                                    if (fullSync) {
                                        LOG.info((Object)("Full sync of database " + database + " on: " + host + " using: " + fullStrategy));
                                    } else {
                                        LOG.info((Object)("Passive activation of database " + database + " connections to: " + host));
                                    }
                                    cluster.activate(hostName, syncStrategy);
                                    if (fullSync) {
                                        LOG.info((Object)("Full sync of database " + database + " on: " + host + " using " + cluster.getactiveDatabases()));
                                    } else {
                                        LOG.info((Object)("Passive activation of database " + database + " on: " + host + " using " + cluster.getactiveDatabases()));
                                    }
                                }
                                catch (Exception ex) {
                                    throw Exceptions.toUndeclared(ex);
                                }
                                try {
                                    LOG.debug((Object)("Refreshing idle pooled connections for context: " + database));
                                    ProxoolFacade.killAllConnections((String)database, (String)"Database registered", (boolean)true);
                                    LOG.debug((Object)("Refreshed idle pooled connections for context: " + database));
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)("Error refreshing connections on activation of context: " + database), (Throwable)ex);
                                }
                            }
                            catch (IllegalStateException | NoSuchElementException ex1) {
                                LOG.error((Object)ex1);
                                Logs.extreme().error((Object)ex1, (Throwable)ex1);
                                return;
                            }
                            catch (Exception ex1) {
                                LOG.error((Object)ex1);
                                Logs.extreme().error((Object)ex1, (Throwable)ex1);
                                throw Exceptions.toUndeclared((String)("Failed to activate database " + database + " host " + host + " because of: " + ex1.getMessage()), (Throwable[])new Exception[]{ex1});
                            }
                        }

                        public String toString() {
                            return "Databases.enable(): " + host.getDisplayName() + " " + database;
                        }
                    };
                }

                public String toString() {
                    return "Databases.enable(): " + host;
                }
            };
        }

        public String toString() {
            return "Databases.enable()";
        }

        private static void rollback(Host host, Exception ex) {
            try {
                Databases.runDbStateChange((Function<String, Runnable>)DeactivateHostFunction.INSTANCE.apply(host.getDisplayName()));
            }
            catch (LockTimeoutException ex1) {
                LOG.error((Object)("Databases.enable(): failed because of: " + ex.getMessage()));
            }
            catch (Exception ex1) {
                LOG.error((Object)("Databases.enable(): failed because of: " + ex.getMessage()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
    }

    static enum DeactivateHostFunction implements Function<String, Function<String, Runnable>>
    {
        INSTANCE;


        public Function<String, Runnable> apply(final String hostName) {
            return new Function<String, Runnable>(){

                public Runnable apply(final String contextName) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            if (Internets.testLocal(hostName)) {
                                return;
                            }
                            try {
                                int i;
                                boolean wasPrimary;
                                try {
                                    wasPrimary = Databases.lookupDatabase(contextName, hostName).getweight() == 100;
                                }
                                catch (Exception ex1) {
                                    return;
                                }
                                LOG.info((Object)("Tearing down database connections for: " + hostName + " to context: " + contextName));
                                DatabaseClusterMBean cluster = Databases.lookup(contextName, TimeUnit.SECONDS.toMillis(5L));
                                for (i = 0; i < 10 && cluster.getactiveDatabases().contains(hostName); ++i) {
                                    try {
                                        LOG.debug((Object)("Deactivating database connections for: " + hostName + " to context: " + contextName));
                                        cluster.deactivate(hostName);
                                        LOG.debug((Object)("Deactived database connections for: " + hostName + " to context: " + contextName));
                                        break;
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)ex);
                                        Logs.extreme().error((Object)ex, (Throwable)ex);
                                        continue;
                                    }
                                }
                                for (i = 0; i < 10 && cluster.getinactiveDatabases().contains(hostName) && !Hosts.contains(hostName); ++i) {
                                    try {
                                        LOG.debug((Object)("Removing database registration for: " + hostName + " to context: " + contextName));
                                        cluster.remove(hostName);
                                        LOG.debug((Object)("Removed database registration for: " + hostName + " to context: " + contextName));
                                        break;
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)ex);
                                        Logs.extreme().error((Object)ex, (Throwable)ex);
                                        continue;
                                    }
                                }
                                Host coordinator = Hosts.getCoordinator();
                                if (wasPrimary && coordinator != null) {
                                    try {
                                        Databases.lookupDatabase(contextName, coordinator.getDisplayName()).setweight(100);
                                    }
                                    catch (NoSuchElementException ex) {
                                    }
                                    catch (Exception e) {
                                        LOG.error((Object)("Error setting primary weight for host " + coordinator.getDisplayName() + " context " + contextName), (Throwable)e);
                                    }
                                }
                                for (int i2 = 0; i2 < 10 && !cluster.getactiveDatabases().contains(hostName) && !cluster.getinactiveDatabases().contains(hostName); ++i2) {
                                    try {
                                        LOG.debug((Object)("Refreshing idle pooled connections for context: " + contextName));
                                        ProxoolFacade.killAllConnections((String)contextName, (String)"Database deregistered", (boolean)true);
                                        LOG.debug((Object)("Refreshed idle pooled connections for context: " + contextName));
                                        break;
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)ex);
                                        Logs.extreme().error((Object)ex, (Throwable)ex);
                                        continue;
                                    }
                                }
                            }
                            catch (Exception ex1) {
                                LOG.error((Object)ex1);
                                Logs.extreme().error((Object)ex1, (Throwable)ex1);
                            }
                        }

                        public String toString() {
                            return "Databases.disable(): " + hostName + " " + contextName;
                        }
                    };
                }

                public String toString() {
                    return "Databases.disable(): " + hostName;
                }
            };
        }

        public String toString() {
            return "Databases.disable()";
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.RemoteDbPoolInit)
    public static class DatabaseRemotePoolBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            try {
                Groovyness.run("setup_dbpool_remote.groovy");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.PoolInit)
    public static class DatabasePoolBootstrapper
    extends Bootstrapper.Simple {
        private static final int INITIAL_DB_SYNC_RETRY_WAIT = 5;

        @Override
        public boolean load() throws Exception {
            Hosts.awaitDatabases();
            Locks.DISABLED.isLocked();
            Locks.PARTITIONED.isLocked();
            Groovyness.run("setup_dbpool.groovy");
            OrderedShutdown.registerShutdownHook(Empyrean.class, new Runnable(){

                @Override
                public void run() {
                    try {
                        for (String database : Databases.databases()) {
                            try {
                                DatabaseClusterMBean db = Databases.lookup(database, TimeUnit.SECONDS.toMillis(5L));
                                for (String host : db.getinactiveDatabases()) {
                                    Databases.disable(host);
                                }
                                for (String host : db.getactiveDatabases()) {
                                    Databases.disable(host);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex);
                            }
                        }
                    }
                    catch (NoSuchElementException ex) {
                        LOG.error((Object)ex);
                    }
                }
            });
            TimeUnit.SECONDS.sleep(5L);
            if (!Hosts.isCoordinator() && Hosts.localHost().hasDatabase().booleanValue()) {
                while (!Databases.enable(Hosts.localHost())) {
                    LOG.warn((Object)LogUtil.subheader("Synchronization of the database failed: " + Hosts.localHost()));
                    if (counter.decrementAndGet() == 0) {
                        LOG.fatal((Object)"Restarting process to force re-synchronization.");
                        System.exit(123);
                        continue;
                    }
                    LOG.warn((Object)"Sleeping for 5 seconds before trying again.");
                    TimeUnit.SECONDS.sleep(5L);
                }
                Locks.DISABLED.create();
                Hosts.UpdateEntry.INSTANCE.apply(Hosts.localHost());
                LOG.info((Object)LogUtil.subheader("Database synchronization complete: " + Hosts.localHost()));
            }
            return true;
        }

        @Override
        public boolean check() throws Exception {
            if (Bootstrap.isOperational().booleanValue() && !Hosts.localHost().hasDatabase().booleanValue()) {
                ImmutableList<Host.DBStatus> statusList = Hosts.localHost().getDatabaseStatus();
                for (Host.DBStatus status : statusList) {
                    for (String error : status.getError().asSet()) {
                        LOG.error((Object)error);
                    }
                }
            }
            return super.check();
        }
    }

    static enum ExecuteRunnable implements Function<Runnable, Future<Runnable>>
    {
        INSTANCE;


        public Future<Runnable> apply(Runnable input) {
            Logs.extreme().debug((Object)("SUBMIT: " + input));
            return dbSyncExecutors.submit(input, input);
        }
    }

    static enum SyncState {
        IRRELEVANT,
        NOTSYNCED,
        SYNCING{

            @Override
            public boolean set() {
                return syncState.compareAndSet(NOTSYNCED, SYNCING);
            }
        }
        ,
        DESYNCING,
        SYNCED{

            @Override
            public boolean isCurrent() {
                if (Hosts.isCoordinator()) {
                    syncState.set(this);
                }
                return super.isCurrent();
            }
        };

        private static final AtomicReference<SyncState> syncState;

        public static SyncState get() {
            return syncState.get();
        }

        public boolean set() {
            syncState.set(this);
            return true;
        }

        public boolean isCurrent() {
            return this.equals((Object)syncState.get());
        }

        static {
            syncState = new AtomicReference<SyncState>(NOTSYNCED);
        }
    }

    public static enum Events {
        INSTANCE;


        public static Sql getConnection() throws Exception {
            return Databases.getBootstrapper().getConnection(INSTANCE.getName(), null);
        }

        public String getName() {
            return "database_events";
        }

        public static void create() {
            if (!Databases.getBootstrapper().listDatabases().contains(INSTANCE.getName())) {
                try {
                    Databases.getBootstrapper().createDatabase(INSTANCE.getName());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    public static enum Locks {
        DISABLED{

            @Override
            void isLocked() {
                File dbLockFile = this.getLockFile();
                if (dbLockFile.exists() && Hosts.isCoordinator()) {
                    this.failStop();
                }
            }

            @Override
            public void failStop() {
                Faults.forComponent(Eucalyptus.class).havingId(1010).withVar(Locks.DB_LOCK_FILE, this.getLockFile().getAbsolutePath()).log();
                LOG.error((Object)("WARNING : DISABLED CLC STARTED OUT OF ORDER, REMOVE THE " + this.getLockName() + "FILE TO PROCEED WITH RISK"));
                System.exit(1);
            }
        }
        ,
        PARTITIONED{

            @Override
            void isLocked() {
                if (this.getLockFile().exists()) {
                    this.failStop();
                }
            }

            @Override
            public void failStop() {
                Faults.forComponent(Eucalyptus.class).havingId(1011).withVar(Locks.DB_LOCK_FILE, this.getLockFile().getAbsolutePath()).log();
                LOG.error((Object)"PARTITION DETECTED -- FAIL-STOP TO AVOID POSSIBLE INCONSISTENCY.");
                LOG.error((Object)"PARTITION DETECTED -- Shutting down CLC after experiencing a possible split-brain partition.");
                LOG.error((Object)"PARTITION DETECTED -- See cloud-fault.log for guidance.");
                System.exit(1);
            }

            @Override
            public void create() {
                super.create();
                Faults.forComponent(Eucalyptus.class).havingId(1011).withVar(Locks.DB_LOCK_FILE, this.getLockFile().getAbsolutePath()).log();
            }
        };

        public static final String DB_LOCK_FILE = "DB_LOCK_FILE";

        public void delete() {
            this.getLockFile().delete();
            LOG.debug((Object)("The " + this.getLockFile().getAbsolutePath() + " file was deleted"));
        }

        protected String getLockName() {
            return this.name().toLowerCase() + ".lock";
        }

        abstract void isLocked();

        public abstract void failStop();

        protected File getLockFile() {
            return SubDirectory.DB.getChildFile("data", this.getLockName());
        }

        public void create(String reason) {
            LOG.error((Object)(this.getLockName() + ": Caused by: " + reason));
            this.create();
        }

        public void create() {
            try {
                if (this.getLockFile().createNewFile()) {
                    LOG.debug((Object)(this.getLockName() + ": The " + this.getLockFile().getAbsolutePath() + " file was created."));
                }
            }
            catch (IOException e) {
                LOG.debug((Object)("Unable to create the " + this.getLockFile().getAbsolutePath() + " file: " + e.getMessage()));
            }
        }
    }

    public static class DatabaseStateException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public DatabaseStateException(String string) {
            super(string);
        }
    }
}

