/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import groovy.sql.Sql;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;

public interface DatabaseBootstrapper {
    public static final String DB_USERNAME = "eucalyptus";

    public void init() throws Exception;

    public boolean load() throws Exception;

    public boolean start() throws Exception;

    public boolean stop() throws Exception;

    public void destroy() throws Exception;

    public boolean isRunning();

    public void hup();

    public List<String> listDatabases();

    public List<String> listDatabases(InetAddress var1);

    public List<String> listSchemas(String var1);

    public List<String> listSchemas(InetAddress var1, String var2);

    public List<String> listTables(String var1, String var2);

    public void createDatabase(String var1);

    public void deleteDatabase(String var1);

    public void renameDatabase(String var1, String var2);

    public void copyDatabase(String var1, String var2);

    public void copyDatabaseSchema(String var1, String var2, String var3, String var4);

    public Sql getConnection(String var1) throws Exception;

    public Sql getConnection(String var1, String var2) throws Exception;

    public String getDefaultSchemaName();

    public String getDriverName();

    public String getJdbcDialect();

    public String getHibernateDialect();

    public String getJdbcScheme();

    public String getServicePath(String ... var1);

    public Map<String, String> getJdbcUrlQueryParameters();

    public String getUserName();

    public String getPassword();
}

