/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.context.ServiceStateException;
import com.google.common.collect.Sets;
import java.util.Set;

public abstract class CloudControllerColocatingBootstrapper
extends Bootstrapper.Simple {
    private final Class<? extends ComponentId> component;

    protected CloudControllerColocatingBootstrapper(Class<? extends ComponentId> component) {
        this.component = component;
        EnablingBootstrap.colocatedComponents.add(component);
    }

    @Override
    public boolean check() throws Exception {
        this.enforceColocation(true);
        return super.check();
    }

    @Override
    public boolean enable() throws Exception {
        this.enforceColocation(false);
        return super.check();
    }

    private void enforceColocation(boolean requireEnabled) throws ServiceStateException {
        if (!(ComponentIds.lookup(this.component).isManyToOnePartition().booleanValue() || Topology.isEnabledLocally(Eucalyptus.class) || requireEnabled && !Topology.isEnabledLocally(this.component))) {
            throw new ServiceStateException("The " + ComponentIds.lookup(this.component).name() + " service depends upon a locally ENABLED " + ComponentIds.lookup(Eucalyptus.class).name());
        }
    }

    @RunDuring(value=Bootstrap.Stage.RemoteServicesInit)
    @Provides(value=Eucalyptus.class)
    public static class EnablingBootstrap
    extends Bootstrapper.Simple {
        private static final Set<Class<? extends ComponentId>> colocatedComponents = Sets.newHashSet();

        @Override
        public boolean enable() throws Exception {
            for (Class<? extends ComponentId> compId : colocatedComponents) {
                Components.lookup(compId).initService();
            }
            return super.enable();
        }
    }
}

