/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.bootstrap.SystemBootstrapper;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.system.Ats;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BootstrapperDiscovery
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(BootstrapperDiscovery.class);
    private static List<Class> bootstrappers = Lists.newArrayList();

    @Override
    public boolean processClass(Class candidate) throws Exception {
        String bc = candidate.getCanonicalName();
        if (Modifier.isAbstract(candidate.getModifiers()) || !Bootstrapper.class.isAssignableFrom(candidate)) {
            return false;
        }
        Class bootstrapper = this.getBootstrapper(candidate);
        if (!Ats.from(candidate).has(RunDuring.class)) {
            throw BootstrapException.throwFatal("Bootstrap class does not specify execution stage (RunDuring.value=Bootstrap.Stage): " + bc);
        }
        if (!Ats.from(candidate).has(Provides.class)) {
            throw BootstrapException.throwFatal("Bootstrap class does not specify provided component (Provides.value=Component): " + bc);
        }
        bootstrappers.add(bootstrapper);
        return true;
    }

    public static List<Bootstrapper> getBootstrappers() {
        ArrayList ret = Lists.newArrayList();
        for (Class c : bootstrappers) {
            if (c.equals(SystemBootstrapper.class)) continue;
            try {
                EventRecord.here(BootstrapperDiscovery.class, EventType.BOOTSTRAPPER_INIT, "<init>()V", c.getCanonicalName()).info();
                try {
                    ret.add((Bootstrapper)c.newInstance());
                }
                catch (Exception e) {
                    EventRecord.here(BootstrapperDiscovery.class, EventType.BOOTSTRAPPER_INIT, "getInstance()L", c.getCanonicalName()).info();
                    try {
                        Method m = c.getDeclaredMethod("getInstance", new Class[0]);
                        ret.add((Bootstrapper)m.invoke(null, new Object[0]));
                    }
                    catch (NoSuchMethodException ex) {
                        throw BootstrapException.throwFatal("Error in <init>()V in bootstrapper: " + c.getCanonicalName(), e);
                    }
                }
            }
            catch (Exception e) {
                throw BootstrapException.throwFatal("Error in <init>()V and getInstance()L; in bootstrapper: " + c.getCanonicalName(), e);
            }
        }
        return ret;
    }

    private Class getBootstrapper(Class candidate) throws Exception {
        Method factory;
        LOG.trace((Object)("Candidate bootstrapper: " + candidate.getName()));
        if (!(Modifier.isPublic(candidate.getDeclaredConstructor(new Class[0]).getModifiers()) || Modifier.isStatic((factory = candidate.getDeclaredMethod("getInstance", new Class[0])).getModifiers()) && Modifier.isPublic(factory.getModifiers()))) {
            throw BootstrapException.throwFatal(candidate.getCanonicalName() + " does not declare public <init>()V or public static getInstance()L;");
        }
        EventRecord.here(ServiceJarDiscovery.class, EventType.BOOTSTRAPPER_ADDED, candidate.getName()).info();
        return candidate;
    }

    @Override
    public Double getPriority() {
        return 0.0;
    }
}

