/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.bootstrap.CanBootstrap;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.DependsRemote;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Components;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public abstract class Bootstrapper
implements Comparable<Bootstrapper>,
CanBootstrap {
    private static Logger LOG = Logger.getLogger(Bootstrapper.class);
    private List<ComponentId> dependsLocal = this.getDependsLocal();
    private List<ComponentId> dependsRemote = this.getDependsRemote();

    @Override
    public abstract boolean check() throws Exception;

    public boolean checkLocal() {
        for (ComponentId c : this.getDependsLocal()) {
            try {
                if (Components.lookup(c).hasLocalService().booleanValue()) continue;
                return false;
            }
            catch (NoSuchElementException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean checkRemote() {
        for (ComponentId c : this.getDependsRemote()) {
            try {
                if (!Components.lookup(c).hasLocalService().booleanValue()) continue;
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        return true;
    }

    @Override
    public abstract void destroy() throws Exception;

    @Override
    public abstract boolean disable() throws Exception;

    @Override
    public abstract boolean enable() throws Exception;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }

    public Bootstrap.Stage getBootstrapStage() {
        if (!Ats.from(this.getClass()).has(RunDuring.class)) {
            throw BootstrapException.throwFatal("Bootstrap class does not specify execution stage (RunDuring.value=Bootstrap.Stage): " + this.getClass());
        }
        return Ats.from(this.getClass()).get(RunDuring.class).value();
    }

    public List<ComponentId> getDependsLocal() {
        if (this.dependsLocal != null) {
            return this.dependsLocal;
        }
        if (!Ats.from(this.getClass()).has(DependsLocal.class)) {
            this.dependsLocal = Lists.newArrayListWithExpectedSize((int)0);
        } else {
            this.dependsLocal = Lists.newArrayList();
            for (Class compIdClass : Ats.from(this.getClass()).get(DependsLocal.class).value()) {
                if (!ComponentId.class.isAssignableFrom(compIdClass)) {
                    LOG.error((Object)("Ignoring specified @Depends which does not extend ComponentId: " + compIdClass));
                    continue;
                }
                try {
                    LOG.trace((Object)("Adding @Depends to " + this.getClass() + ": " + compIdClass));
                    this.dependsLocal.add((ComponentId)compIdClass.newInstance());
                }
                catch (InstantiationException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        return this.dependsLocal;
    }

    public List<ComponentId> getDependsRemote() {
        if (this.dependsRemote != null) {
            return this.dependsRemote;
        }
        if (!Ats.from(this.getClass()).has(DependsRemote.class)) {
            this.dependsRemote = Lists.newArrayListWithExpectedSize((int)0);
        } else {
            this.dependsRemote = Lists.newArrayList();
            for (Class compIdClass : Ats.from(this.getClass()).get(DependsRemote.class).value()) {
                if (!ComponentId.class.isAssignableFrom(compIdClass)) {
                    LOG.error((Object)"Ignoring specified @Depends which does not use ComponentId");
                    continue;
                }
                try {
                    this.dependsRemote.add((ComponentId)compIdClass.newInstance());
                }
                catch (InstantiationException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        return this.dependsRemote;
    }

    public <T extends ComponentId> Class<T> getProvides() {
        if (!Ats.from(this.getClass()).has(Provides.class)) {
            Exceptions.trace("Bootstrap class does not specify the component which it @Provides.  Fine.  For now we pretend you had put @Provides(ComponentId.class): " + this.getClass());
            return ComponentId.class;
        }
        return Ats.from(this.getClass()).get(Provides.class).value();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    @Override
    public abstract boolean load() throws Exception;

    @Override
    public abstract boolean start() throws Exception;

    @Override
    public abstract boolean stop() throws Exception;

    public String toString() {
        return String.format("Bootstrapper %s runDuring=%s dependsLocal=%s dependsRemote=%s", new Object[]{this.getClass().getSimpleName(), this.getBootstrapStage(), this.dependsLocal, this.dependsRemote});
    }

    @Override
    public int compareTo(Bootstrapper o) {
        return this.getClass().toString().compareTo(o.getClass().toString());
    }

    public static abstract class Simple
    extends Bootstrapper {
        @Override
        public boolean check() throws Exception {
            return true;
        }

        @Override
        public void destroy() throws Exception {
        }

        @Override
        public boolean disable() throws Exception {
            return true;
        }

        @Override
        public boolean enable() throws Exception {
            return true;
        }

        @Override
        public boolean load() throws Exception {
            return true;
        }

        @Override
        public boolean start() throws Exception {
            return true;
        }

        @Override
        public boolean stop() throws Exception {
            return true;
        }
    }
}

