/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.util.Exceptions;
import org.apache.log4j.Logger;

public class BootstrapException
extends RuntimeException {
    private static Logger LOG = Logger.getLogger(BootstrapException.class);

    private BootstrapException(String message, Throwable cause) {
        super((Object)((Object)Bootstrap.getCurrentStage()) + ": " + message, cause);
    }

    public BootstrapException(String message) {
        super((Object)((Object)Bootstrap.getCurrentStage()) + ": " + message);
    }

    private BootstrapException(Throwable cause) {
        super((Object)((Object)Bootstrap.getCurrentStage()) + ": " + cause);
    }

    public static BootstrapException throwError(String message) {
        return BootstrapException.error(message, null);
    }

    public static BootstrapException throwError(String message, Throwable t) {
        return BootstrapException.error(message, t);
    }

    public static BootstrapException error(String message, Throwable t) {
        Bootstrap.Stage stage = Bootstrap.getCurrentStage();
        BootstrapException ex = new BootstrapException(message);
        StackTraceElement ste = Thread.currentThread().getStackTrace()[3];
        if (t == null) {
            Logger.getLogger((String)ste.getClassName()).error((Object)("Error occured during bootstrap: " + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber()), (Throwable)ex);
        } else {
            Logger.getLogger((String)ste.getClassName()).error((Object)("Error occured during bootstrap: " + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber()), t);
        }
        return ex;
    }

    public static BootstrapException throwFatal(String message) {
        return BootstrapException.fatal(message, null);
    }

    public static BootstrapException throwFatal(String message, Throwable t) {
        return BootstrapException.fatal(message, t);
    }

    private static BootstrapException fatal(String message, Throwable t) {
        Bootstrap.Stage stage = Bootstrap.getCurrentStage();
        BootstrapException ex = new BootstrapException(message, t);
        StackTraceElement ste = Thread.currentThread().getStackTrace()[3];
        if (t == null) {
            Logger.getLogger((String)ste.getClassName()).fatal((Object)("Fatal error occured during bootstrap: " + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber()), (Throwable)ex);
        } else {
            Logger.getLogger((String)ste.getClassName()).fatal((Object)("Fatal error occured during bootstrap: " + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber()), t);
        }
        Exceptions.error(message, t);
        return ex;
    }
}

