/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.system.SubDirectory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jibx.binding.Loader;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.util.ClasspathUrlExtender;

public class BootstrapClassLoader
extends URLClassLoader {
    private static Logger LOG = Logger.getLogger(BootstrapClassLoader.class);
    private static BootstrapClassLoader singleton = null;
    private final List<BindingDefinition> bindings = Lists.newArrayList();
    private boolean isBound;
    private final Map<String, ClassFile> classMap = Maps.newHashMap();

    public static BootstrapClassLoader init() {
        try {
            if (singleton == null) {
                if (SubDirectory.CLASSCACHE.getFile().exists()) {
                    try {
                        FileUtils.deleteDirectory((File)SubDirectory.CLASSCACHE.getFile());
                    }
                    catch (IOException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
                SubDirectory.CLASSCACHE.check();
                String[] paths = Utility.getClassPaths();
                URL[] urls = new URL[paths.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = new File(paths[i]).toURI().toURL();
                }
                singleton = new BootstrapClassLoader(urls);
            }
            Thread.currentThread().setContextClassLoader(singleton);
            return singleton;
        }
        catch (MalformedURLException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static BootstrapClassLoader getInstance() {
        return BootstrapClassLoader.init();
    }

    private BootstrapClassLoader(URL[] urls) throws MalformedURLException {
        super(urls, ClassLoader.getSystemClassLoader());
        ArrayList fpaths = Lists.newArrayList();
        for (URL path : Loader.getClassPaths()) {
            LOG.debug((Object)path);
            if (!"file".equals(path.getProtocol())) continue;
            fpaths.add(path.getPath());
        }
        String[] dirs = fpaths.toArray(new String[0]);
        ClassCache.setPaths((String[])dirs);
        ClassFile.setPaths((String[])dirs);
        ClasspathUrlExtender.setClassLoader((ClassLoader)ClassFile.getClassLoader());
        BoundClass.reset();
        MungedClass.reset();
        BindingDefinition.reset();
    }

    public void reset() {
        this.bindings.clear();
        this.classMap.clear();
        this.isBound = false;
        BoundClass.reset();
        MungedClass.reset();
        BindingDefinition.reset();
    }

    public static URL[] getClassPaths() throws MalformedURLException {
        String[] paths = Utility.getClassPaths();
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new File(paths[i]).toURI().toURL();
        }
        return urls;
    }

    public void loadBinding(String fname, String sname, InputStream is, URL url2) throws JiBXException, IOException {
        throw new IllegalStateException("Call not allowed: only resources can currently be loaded.");
    }

    public void loadFileBinding(String path) throws JiBXException, IOException {
        throw new IllegalStateException("Call not allowed: only resources can currently be loaded.");
    }

    public void loadResourceBinding(String path) throws JiBXException, IOException {
        if (this.isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        URL url2 = Resources.getResource((String)path);
        InputSupplier inSupplier = Resources.newInputStreamSupplier((URL)url2);
        if (inSupplier == null) {
            throw new IOException("Resource " + path + " not found");
        }
        String fname = path;
        int split = fname.lastIndexOf(47);
        if (split >= 0) {
            fname = fname.substring(split + 1);
        }
        String defaultBindingName = Utility.bindingFromFileName((String)fname);
        try {
            ValidationContext vctx = BindingElement.newValidationContext();
            BindingElement root = BindingElement.validateBinding((String)fname, (URL)url2, (InputStream)((InputStream)inSupplier.getInput()), (ValidationContext)vctx);
            if (vctx.getErrorCount() == 0 && vctx.getFatalCount() == 0) {
                ClassFile classFile = BootstrapClassLoader.findMappedClass(root);
                String tpack = root.getTargetPackage();
                if (tpack == null && classFile != null) {
                    tpack = classFile.getPackage();
                }
                String bindingName = root.getName();
                UnmarshallingContext uctx = new UnmarshallingContext();
                uctx.setDocument((InputStream)inSupplier.getInput(), fname, null);
                if (classFile != null) {
                    bindingName = bindingName == null ? defaultBindingName : bindingName;
                    BoundClass.setModify((File)classFile.getRoot(), (String)tpack, (String)bindingName);
                }
                BindingDefinition bindingDefinition = BindingBuilder.unmarshalBindingDefinition((UnmarshallingContext)uctx, (String)defaultBindingName, (URL)url2);
                File rootFile = null;
                if (tpack == null) {
                    tpack = bindingDefinition.getDefaultPackage();
                }
                if (classFile == null) {
                    rootFile = ClassCache.getModifiablePath();
                    if (root == null) {
                        throw new IllegalStateException("Need modifiable directory on classpath for storing generated factory class file");
                    }
                    if (tpack == null) {
                        tpack = "";
                    }
                } else {
                    rootFile = classFile.getRoot();
                    if (tpack == null) {
                        tpack = classFile.getPackage();
                    }
                }
                bindingDefinition.setFactoryLocation(tpack, rootFile);
            }
        }
        catch (JiBXException ex) {
            LOG.error((Object)("Unable to process binding " + url2), (Throwable)ex);
        }
    }

    private static ClassFile findMappedClass(BindingElement root) {
        ArrayList childs = root.topChildren();
        if (childs != null) {
            for (int i = childs.size() - 1; i >= 0; --i) {
                BindingElement bind;
                MappingElementBase map;
                ClassFile cf;
                Object child = childs.get(i);
                if (!(child instanceof MappingElement ? !(cf = (map = (MappingElementBase)child).getHandledClass().getClassFile()).isInterface() && cf.isModifiable() : child instanceof IncludeElement && (bind = ((IncludeElement)child).getBinding()) != null && (cf = BootstrapClassLoader.findMappedClass(bind)) != null)) continue;
                return cf;
            }
        }
        return null;
    }

    public void processBindings() throws JiBXException {
        if (!this.isBound) {
            for (BindingDefinition binding : this.bindings) {
                binding.generateCode(System.getProperty("euca.debug.binding.compile") != null, System.getProperty("euca.debug.binding.compile") != null);
            }
            ClassFile[][] lists = MungedClass.fixDispositions();
            for (BindingDefinition binding : this.bindings) {
                binding.addClassList(lists[0], lists[1]);
            }
            for (int i = 0; i < lists[0].length; ++i) {
                ClassFile clas = lists[0][i];
                this.classMap.put(clas.getName(), clas);
            }
            this.isBound = true;
        }
    }

    protected boolean isBoundClass(String name) {
        return this.classMap.containsKey(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.isBoundClass(name)) {
            try {
                ClassFile clas = this.classMap.get(name);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                clas.writeFile((OutputStream)bos);
                byte[] bytes = bos.toByteArray();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Unable to load modified class " + name);
            }
        }
        return super.findClass(name);
    }
}

