/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.ArgumentValidationError;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Internets;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BootstrapArgs {
    private static Logger LOG = Logger.getLogger(BootstrapArgs.class);
    private static final List<String> bindAddrs = Lists.newArrayList();
    private static final List<String> bootstrapHosts = Lists.newArrayList();
    private static boolean initSystem = false;
    private static boolean upgradeSystem = false;

    static void init() {
        bindAddrs.addAll(BootstrapArgs.parseMultipleArgs("euca.bind.addr", BindAddressValidator.INSTANCE));
        bootstrapHosts.addAll(BootstrapArgs.parseMultipleArgs("euca.bootstrap.host", BindAddressValidator.INSTANCE));
        initSystem = System.getProperty("euca.initialize") != null;
        upgradeSystem = System.getProperty("euca.upgrade") != null;
        try {
            InetAddress.getByName("eucalyptus.com").isReachable(NetworkInterface.getByInetAddress(Internets.localHostInetAddress()), 64, 10000);
        }
        catch (Exception ex2) {
            LOG.error((Object)ex2, (Throwable)ex2);
        }
    }

    public static boolean isInitializeSystem() {
        return initSystem;
    }

    public static boolean isUpgradeSystem() {
        return upgradeSystem;
    }

    public static List<String> parseBootstrapHosts() {
        return bootstrapHosts;
    }

    public static List<String> bindAddresses() {
        return bindAddrs;
    }

    private static List<String> parseMultipleArgs(String baseString, Predicate<String> argValidator) {
        ArrayList retList = Lists.newArrayList();
        String formatString = baseString + ".%d";
        String next = String.format(formatString, 0);
        int i = 0;
        while (i < 255) {
            String nextVal = System.getProperty(next);
            if (nextVal != null) {
                if (argValidator.apply((Object)nextVal)) {
                    retList.add(System.getProperty(next));
                } else {
                    ArgumentValidationError err = new ArgumentValidationError("Argument validation failed for " + next + " on value: " + nextVal);
                    LOG.error((Object)err, (Throwable)err);
                }
            }
            next = String.format(formatString, i++);
        }
        return retList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Boolean isCloudController() {
        boolean bl;
        if (SubDirectory.DB.hasChild("data", "ibdata1")) {
            if (!Boolean.valueOf(System.getProperty("euca.force.remote.bootstrap")).booleanValue()) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }

    public static String debugTopology() {
        return System.getProperty("euca.noha.cloud");
    }

    static enum BootstrapHostValidator implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String arg0) {
            try {
                InetAddress.getByName(arg0);
                return true;
            }
            catch (UnknownHostException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return false;
            }
        }
    }

    static enum BindAddressValidator implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String arg0) {
            try {
                InetAddress.getByName(arg0);
                return true;
            }
            catch (UnknownHostException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return false;
            }
        }
    }
}

