/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.binding.BindingCache;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.BootstrapperDiscovery;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.fsm.OrderlyTransitionException;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Bootstrap {
    static Logger LOG = Logger.getLogger(Bootstrap.class);
    static Boolean loading = false;
    private static Boolean starting = false;
    private static Boolean finished = false;
    private static Stage currentStage = Stage.SystemInit;
    static Boolean shutdown = false;

    public static Stage getCurrentStage() {
        return currentStage;
    }

    private static void doDiscovery() {
        ServiceJarDiscovery.processLibraries();
        ServiceJarDiscovery.runDiscovery();
    }

    public static void initBootstrappers() {
        for (Stage stage : Stage.values()) {
            stage.bootstrappers.clear();
            stage.disabledBootstrappers.clear();
        }
        for (Bootstrapper bootstrap : BootstrapperDiscovery.getBootstrappers()) {
            try {
                String bc = bootstrap.getClass().getCanonicalName();
                Stage stage = bootstrap.getBootstrapStage();
                Class compType = bootstrap.getProvides();
                EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_INIT, stage.name(), bc, "component=" + compType.getSimpleName()).info();
                if (ComponentId.class.isAssignableFrom(compType) && !Empyrean.class.equals(compType) && !ComponentId.class.equals(compType)) {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_ADDED, stage.name(), bc, "component=" + compType.getSimpleName()).info();
                    Components.lookup(compType).addBootstrapper(bootstrap);
                    continue;
                }
                if (Bootstrap.checkDepends(bootstrap)) {
                    if (Empyrean.class.equals(compType)) {
                        EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_ADDED, stage.name(), bc, "component=" + compType.getSimpleName()).info();
                        stage.addBootstrapper(bootstrap);
                        continue;
                    }
                    if (!ComponentId.class.equals(compType)) continue;
                    for (Component c : Components.list()) {
                        EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_ADDED, stage.name(), bc, "component=" + c.getName()).info();
                        c.addBootstrapper(bootstrap);
                    }
                    continue;
                }
                EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_SKIPPED, stage.name(), bc, "component=" + compType.getSimpleName(), "localDepends=" + bootstrap.checkLocal(), "remoteDepends=" + bootstrap.checkRemote()).info();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private static boolean checkDepends(Bootstrapper bootstrap) {
        String bc = bootstrap.getClass().getCanonicalName();
        if (bootstrap.checkLocal() && bootstrap.checkRemote()) {
            return true;
        }
        if (!bootstrap.checkLocal()) {
            EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_SKIPPED, currentStage.name(), bc, "DependsLocal", bootstrap.getDependsLocal().toString()).info();
        } else if (!bootstrap.checkRemote()) {
            EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_SKIPPED, currentStage.name(), bc, "DependsRemote", bootstrap.getDependsRemote().toString()).info();
        }
        return false;
    }

    public static synchronized Stage transition() {
        if (!(currentStage != Stage.SystemInit || loading.booleanValue() || starting.booleanValue() || finished.booleanValue())) {
            loading = true;
            starting = false;
            finished = false;
        } else if (currentStage != null) {
            LOG.info((Object)LogUtil.header("Bootstrap stage completed: " + currentStage.toString()));
            if (Stage.Final.equals((Object)currentStage)) {
                currentStage = null;
                if (loading.booleanValue() && !starting.booleanValue() && !finished.booleanValue()) {
                    loading = true;
                    starting = true;
                    finished = false;
                } else if (loading.booleanValue() && starting.booleanValue() && !finished.booleanValue()) {
                    loading = true;
                    starting = true;
                    finished = true;
                }
                return currentStage;
            }
        }
        int currOrdinal = currentStage != null ? currentStage.ordinal() : -1;
        for (int i = currOrdinal + 1; i <= Stage.Final.ordinal(); ++i) {
            currentStage = Stage.values()[i];
            if (!Bootstrap.currentStage.bootstrappers.isEmpty()) {
                return currentStage;
            }
            LOG.trace((Object)LogUtil.subheader("Bootstrap stage skipped: " + currentStage.toString()));
        }
        return currentStage;
    }

    public static Boolean isLoaded() {
        return starting;
    }

    public static Boolean isOperational() {
        return Bootstrap.isFinished() != false && Bootstrap.isShuttingDown() == false;
    }

    public static void awaitFinished() {
        Bootstrap.awaitFinished(Long.MAX_VALUE);
    }

    public static void awaitFinished(Long millis) {
        try {
            while (!finished.booleanValue() && (millis = Long.valueOf(millis - 50L)) > 0L) {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
        }
        catch (InterruptedException ex1) {
            Thread.currentThread().interrupt();
        }
    }

    public static Boolean isFinished() {
        return finished;
    }

    public static Boolean isShuttingDown() {
        return shutdown;
    }

    public static void init() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown = Boolean.TRUE;
            }
        });
        LOG.info((Object)LogUtil.header("Populating binding cache."));
        BindingCache.compileBindings();
        LOG.info((Object)LogUtil.header("Initializing discoverable bootstrap resources."));
        Bootstrap.doDiscovery();
        LOG.info((Object)LogUtil.header("Initializing component identifiers:"));
        for (ComponentId compId : ComponentIds.list()) {
            Components.create(compId);
        }
        LOG.info((Object)LogUtil.header("Building core local services: cloudLocal=" + BootstrapArgs.isCloudController()));
        for (Component comp : Components.whichCanLoad()) {
            try {
                comp.initService();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        LOG.info((Object)LogUtil.header("Initializing component resources:"));
        Bootstrap.applyTransition(Component.State.INITIALIZED, Components.whichCanLoad());
        LOG.info((Object)LogUtil.header("Initializing bootstrappers."));
        Bootstrap.initBootstrappers();
        LOG.info((Object)LogUtil.header("System ready: starting bootstrap."));
        for (Component c : Components.list()) {
            LOG.info((Object)c.toString());
        }
    }

    static void applyTransition(Component.State state, Iterable<Component> components) {
        Bootstrap.applyTransition(state, (Component[])Iterables.toArray(components, Component.class));
    }

    private static void applyTransition(Component.State state, Component ... components) {
        Threads.ThreadPool exec = Threads.lookup(Empyrean.class);
        for (Component component : components) {
            ServiceConfiguration config = component.getLocalServiceConfiguration();
            try {
                ((Future)Topology.transition(state).apply((Object)config)).get();
            }
            catch (Exception ex) {
                Exceptions.maybeInterrupted(ex);
                if (!Exceptions.isCausedBy(ex, OrderlyTransitionException.class)) {
                    LOG.error((Object)ex);
                }
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
    }

    public static void initializeSystem() throws Exception {
        Groovyness.run("initialize_cloud.groovy");
    }

    public static enum Stage {
        SystemInit{

            @Override
            public void start() {
                for (Bootstrapper b : this.bootstrappers) {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_SKIPPED, this.name(), "SKIPPING start()", b.getClass().getCanonicalName()).warn();
                }
            }
        }
        ,
        PrivilegedConfiguration{

            @Override
            public void start() {
                for (Bootstrapper b : this.bootstrappers) {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_SKIPPED, this.name(), "SKIPPING start()", b.getClass().getCanonicalName()).warn();
                }
            }
        }
        ,
        UnprivilegedConfiguration,
        SystemCredentialsInit,
        RemoteConfiguration,
        DatabaseInit,
        UpgradeDatabase,
        PoolInit,
        PersistenceInit,
        RemoteDbPoolInit,
        RemoteServicesInit,
        UserCredentialsInit,
        CloudServiceInit,
        Final;

        protected final Set<Bootstrapper> bootstrappers = new ConcurrentSkipListSet<Bootstrapper>();
        private final Set<Bootstrapper> disabledBootstrappers = new ConcurrentSkipListSet<Bootstrapper>();

        public static List<Stage> list() {
            return Arrays.asList(Stage.values());
        }

        void addBootstrapper(Bootstrapper b) {
            if (this.bootstrappers.contains(b)) {
                throw BootstrapException.throwFatal("Duplicate bootstrapper registration: " + b.getClass().toString());
            }
            this.bootstrappers.add(b);
        }

        void skipBootstrapper(Bootstrapper b) {
            if (this.disabledBootstrappers.contains(b)) {
                throw BootstrapException.throwFatal("Duplicate bootstrapper registration: " + b.getClass().toString());
            }
            this.disabledBootstrappers.add(b);
        }

        private void printAgenda() {
            if (!this.bootstrappers.isEmpty()) {
                LOG.info((Object)LogUtil.header("Bootstrap stage: " + this.name() + "." + (starting == false ? "load()" : "start()")));
                LOG.debug((Object)Joiner.on((String)" ").join((Object)(this.name() + " bootstrappers:  "), this.bootstrappers, new Object[0]));
            }
        }

        public void updateBootstrapDependencies() {
            Iterable currBootstrappers = Iterables.concat((Iterable)Lists.newArrayList(this.bootstrappers), (Iterable)Lists.newArrayList(this.disabledBootstrappers));
            this.bootstrappers.clear();
            this.disabledBootstrappers.clear();
            for (Bootstrapper bootstrapper : currBootstrappers) {
                try {
                    if (bootstrapper.checkLocal() && bootstrapper.checkRemote()) {
                        this.enableBootstrapper(bootstrapper);
                        continue;
                    }
                    this.disableBootstrapper(bootstrapper);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }

        private void enableBootstrapper(Bootstrapper bootstrapper) {
            Logs.exhaust().trace((Object)EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_MARK_ENABLED, "stage=" + this.toString(), bootstrapper.toString()));
            this.disabledBootstrappers.remove(bootstrapper);
            this.bootstrappers.add(bootstrapper);
        }

        private void disableBootstrapper(Bootstrapper bootstrapper) {
            Logs.exhaust().trace((Object)EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_MARK_DISABLED, "stage=" + this.toString(), bootstrapper.toString()));
            this.bootstrappers.remove(bootstrapper);
            this.disabledBootstrappers.add(bootstrapper);
        }

        public void load() {
            this.updateBootstrapDependencies();
            this.printAgenda();
            for (Bootstrapper b : this.bootstrappers) {
                try {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_LOAD, this.name(), b.getClass().getCanonicalName()).info();
                    boolean result = b.load();
                    if (result) continue;
                    throw BootstrapException.throwFatal(b.getClass().getSimpleName() + " returned 'false' from load( ): terminating bootstrap.");
                }
                catch (Exception e) {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_ERROR, this.name(), b.getClass().getCanonicalName()).info();
                    throw BootstrapException.throwFatal(b.getClass().getSimpleName() + " threw an error in load( ): " + e.getMessage(), e);
                }
            }
        }

        public void start() {
            this.updateBootstrapDependencies();
            this.printAgenda();
            for (Bootstrapper b : this.bootstrappers) {
                try {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_START, this.name(), b.getClass().getCanonicalName()).info();
                    boolean result = b.start();
                    if (result) continue;
                    throw BootstrapException.throwFatal(b.getClass().getSimpleName() + " returned 'false' from start( ): terminating bootstrap.");
                }
                catch (Exception e) {
                    EventRecord.here(Bootstrap.class, EventType.BOOTSTRAPPER_ERROR, this.name(), b.getClass().getCanonicalName()).info();
                    throw BootstrapException.throwFatal(b.getClass().getSimpleName() + " threw an error in start( ): " + e.getMessage(), e);
                }
            }
        }

        public String describe() {
            StringBuffer buf = new StringBuffer(this.name()).append(" ");
            for (Bootstrapper b : this.bootstrappers) {
                buf.append(b.getClass().getSimpleName()).append(" ");
            }
            return buf.append("\n").toString();
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Discovery {
        public Class[] value() default {};

        public double priority() default 0.99;

        public Class[] annotations();
    }
}

