/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BillOfMaterials {
    private static Logger LOG = Logger.getLogger(BillOfMaterials.class);
    private static Map<String, String> loadedProps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Map<String, String> loadProps() {
        if (loadedProps == null || loadedProps.isEmpty()) {
            loadedProps = Maps.newHashMap();
            try {
                ArrayList<URL> propFiles = Collections.list(ClassLoader.getSystemResources("version.properties"));
                for (URL u : propFiles) {
                    Properties temp = new Properties();
                    try (InputStream in = (InputStream)Resources.newInputStreamSupplier((URL)u).getInput();){
                        temp.load(in);
                    }
                    loadedProps.putAll((Map<String, String>)Maps.fromProperties((Properties)temp));
                }
            }
            catch (IOException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            return loadedProps;
        }
        return loadedProps;
    }

    public static String getRevisionDate() {
        return RequiredFields.DATE.getValue();
    }

    public static String getBuildDate() {
        return RequiredFields.BUILD.getValue();
    }

    public String getRevisionNumber() {
        return RequiredFields.REVNO.getValue();
    }

    public String getRevisionId() {
        return RequiredFields.REVISIONID.getValue();
    }

    public String getRevisionId(String fileName) {
        return RequiredFields.REVISIONID.getValue();
    }

    public String getBranchNick() {
        return RequiredFields.BRANCH.getValue();
    }

    public static String getVersion() {
        return RequiredFields.VERSION.getValue();
    }

    public static String getExtraVersion() {
        return RequiredFields.EXTRA_VERSION.getValue();
    }

    static enum RequiredFields {
        VERSION(""){

            @Override
            public String getValue() {
                return System.getProperty("euca.version", "ERROR: no version information available.");
            }
        }
        ,
        REVISIONID("revision-id"),
        DATE("date"),
        BUILD("build-date"),
        REVNO("revno"),
        BRANCH("branch-nick"),
        EXTRA_VERSION("extra-version");

        private final String key;

        private RequiredFields(String key) {
            this.key = key;
        }

        public String getValue() {
            if (!BillOfMaterials.loadProps().containsKey(this.key)) {
                return VERSION.getValue();
            }
            return BillOfMaterials.loadProps().get(this.key);
        }
    }
}

