/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.binding;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.bootstrap.BillOfMaterials;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.annotation.ComponentMessage;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class BindingManager {
    private static Logger LOG = Logger.getLogger(BindingManager.class);
    private static Map<BindingKey, Binding> bindingMap = Maps.newConcurrentMap();
    private static final String DEFAULT_BINDING_NAMESPACE = "http://msgs.eucalyptus.com/" + BillOfMaterials.getVersion();
    private static final String DEFAULT_BINDING_NAME = BindingManager.sanitizeNamespace(BindingManager.defaultBindingNamespace());
    private static Binding DEFAULT = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Binding getDefaultBinding() {
        if (DEFAULT != null) {
            return DEFAULT;
        }
        Class<BindingManager> clazz = BindingManager.class;
        synchronized (BindingManager.class) {
            if (DEFAULT != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return DEFAULT;
            }
            DEFAULT = BindingManager.getBinding(BindingManager.sanitizeNamespace(BindingManager.defaultBindingName()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT;
        }
    }

    public static String sanitizeNamespace(String namespace) {
        return namespace.replaceAll("(https?://)|(/$)", "").replaceAll("[./-]", "_");
    }

    public static boolean seedBinding(String bindingName, Class seedClass) {
        boolean seeded = BindingManager.trySeed(BindingManager.key(bindingName), seedClass);
        if (BaseMessage.class.isAssignableFrom(seedClass)) {
            for (Class messageClass = seedClass; messageClass != BaseMessage.class; messageClass = messageClass.getSuperclass()) {
                ComponentMessage componentMessage = messageClass.getAnnotation(ComponentMessage.class);
                if (componentMessage == null) continue;
                seeded = seeded || BindingManager.trySeed(BindingManager.key((Optional<Class<? extends ComponentId>>)Optional.fromNullable(componentMessage.value()), bindingName), seedClass);
                break;
            }
        }
        return seeded;
    }

    public static boolean isRegisteredBinding(String bindingName) {
        BindingKey key = BindingManager.key(bindingName);
        return bindingMap.containsKey(key);
    }

    public static Binding getBinding(String bindingName, Class<? extends ComponentId> component) {
        return BindingManager.getBinding(BindingManager.key((Optional<Class<? extends ComponentId>>)Optional.fromNullable(component), bindingName));
    }

    public static Binding getBinding(String bindingName) {
        return BindingManager.getBinding(BindingManager.key(bindingName));
    }

    public static String defaultBindingName() {
        return DEFAULT_BINDING_NAME;
    }

    public static String defaultBindingNamespace() {
        return DEFAULT_BINDING_NAMESPACE;
    }

    private static BindingKey key(String bindingName) {
        return BindingManager.key((Optional<Class<? extends ComponentId>>)Optional.absent(), bindingName);
    }

    private static BindingKey key(Optional<Class<? extends ComponentId>> component, String bindingName) {
        return new BindingKey(bindingName, component);
    }

    private static Binding getBinding(BindingKey key) {
        if (bindingMap.containsKey(key)) {
            return bindingMap.get(key);
        }
        BindingKey sanitizedKey = key.sanitized();
        if (bindingMap.containsKey(sanitizedKey)) {
            return bindingMap.get(sanitizedKey);
        }
        Binding newBinding = new Binding(key.getName());
        bindingMap.put(key, newBinding);
        return newBinding;
    }

    private static boolean trySeed(BindingKey key, Class seedClass) {
        boolean seeded = false;
        if (!bindingMap.containsKey(key)) {
            try {
                BindingManager.getBinding(key).seed(seedClass);
                Logs.exhaust().trace((Object)("Seeding binding " + key.getName() + " for class " + seedClass.getCanonicalName()));
                EventRecord.here(BindingManager.class, EventType.BINDING_SEEDED, key.getName(), seedClass.getName()).trace();
                seeded = true;
            }
            catch (BindingException e) {
                throw BootstrapException.error("Failed to seed binding " + key.getName() + " with class " + seedClass, e);
            }
        }
        return seeded;
    }

    private static final class BindingKey {
        private final String name;
        private final Optional<Class<? extends ComponentId>> component;

        private BindingKey(String name, Optional<Class<? extends ComponentId>> component) {
            Parameters.checkParam("name", name, Matchers.notNullValue());
            Parameters.checkParam("component", component, Matchers.notNullValue());
            this.name = name;
            this.component = component;
        }

        public String getName() {
            return this.name;
        }

        public BindingKey sanitized() {
            return new BindingKey(BindingManager.sanitizeNamespace(this.name), this.component);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingKey that = (BindingKey)o;
            if (!this.component.equals(that.component)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.component.hashCode();
            return result;
        }
    }
}

