/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.binding;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class BindingDiscovery
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(BindingDiscovery.class);

    @Override
    public Double getPriority() {
        return 0.9;
    }

    @Override
    public boolean processClass(Class candidate) throws Exception {
        String bindingList;
        try {
            Field f = candidate.getDeclaredField("JiBX_bindingList");
            bindingList = (String)f.get(null);
        }
        catch (Exception e) {
            return false;
        }
        List bindings = Lists.transform(Arrays.asList(bindingList.split("\\|")), (Function)new Function<String, String>(){

            public String apply(String arg0) {
                return BindingManager.sanitizeNamespace(arg0.replaceAll(".*JiBX_", "").replaceAll("Factory", ""));
            }
        });
        boolean seeded = false;
        for (String binding : bindings) {
            if (binding.length() <= 2) continue;
            try {
                seeded |= BindingManager.seedBinding(binding, candidate);
            }
            catch (Exception exception) {}
        }
        return seeded;
    }
}

