/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.binding;

import com.eucalyptus.bootstrap.BillOfMaterials;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.annotation.ComponentMessage;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import javax.persistence.Transient;
import org.apache.bcel.util.ClassPath;
import org.apache.log4j.Logger;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.runtime.JiBXException;
import org.jibx.util.ClasspathUrlExtender;

public class BindingCache {
    private static Logger LOG = Logger.getLogger(BindingCache.class);

    public static void compileBindings() {
        BindingFileSearch.compile();
    }

    private static class InternalSoapBindingGenerator {
        private final String ns = "http://msgs.eucalyptus.com/" + BillOfMaterials.getVersion();
        private static String INDENT = "";
        private final File outFile;
        private PrintWriter out;
        private String bindingName;
        private int indent = 0;
        private final Map<String, TypeBinding> typeBindings = ImmutableMap.builder().put((Object)Integer.class.getCanonicalName(), (Object)new IntegerTypeBinding()).put((Object)Boolean.class.getCanonicalName(), (Object)new BooleanTypeBinding()).put((Object)String.class.getCanonicalName(), (Object)new StringTypeBinding()).put((Object)Long.class.getCanonicalName(), (Object)new LongTypeBinding()).put((Object)Double.class.getCanonicalName(), (Object)new DoubleTypeBinding()).put((Object)"boolean", (Object)new BooleanTypeBinding()).put((Object)"int", (Object)new IntegerTypeBinding()).put((Object)"long", (Object)new LongTypeBinding()).put((Object)"double", (Object)new DoubleTypeBinding()).put((Object)Date.class.getCanonicalName(), (Object)new StringTypeBinding()).build();
        private static final List<String> badClasses = ImmutableList.of((Object)".*HttpResponseStatus", (Object)".*Closure", (Object)".*Channel", (Object)".*\\.JiBX_*");
        private static final List<String> badFields = ImmutableList.of((Object)"__.*", (Object)"\\w*\\$\\w*\\$*.*", (Object)"class\\$.*", (Object)"metaClass", (Object)"JiBX_.*", (Object)"serialVersionUID");
        private static Set<String> classNames = new TreeSet<String>();
        private Deque<ElemItem> elemStack = new LinkedList<ElemItem>();

        public InternalSoapBindingGenerator() {
            this.outFile = new File(SubDirectory.CLASSCACHE.getFile().getAbsolutePath() + "/msgs-binding.xml");
        }

        public void processClass(Class klass) {
            if (this.out == null) {
                if (this.outFile.exists() && !this.outFile.delete()) {
                    LOG.error((Object)("Error deleting binding file: " + this.outFile.getAbsolutePath()));
                }
                try {
                    this.out = new PrintWriter(this.outFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(System.err);
                    System.exit(-1);
                }
                this.bindingName = this.ns.replaceAll("(http://)|(/$)", "").replaceAll("[./-]", "_");
                this.out.write("<binding xmlns:euca=\"" + this.ns + "\" name=\"" + this.bindingName + "\">\n");
                this.out.write("  <namespace uri=\"" + this.ns + "\" default=\"elements\" prefix=\"euca\"/>\n");
                this.out.flush();
            }
            if (!classNames.contains(klass.getName())) {
                classNames.add(klass.getName());
                String mapping = new RootObjectTypeBinding(klass).process();
                this.out.write(mapping);
                this.out.flush();
            } else {
                Logs.extreme().debug((Object)("Skipping duplicate class: " + klass));
            }
        }

        public void close() {
            try {
                this.out.flush();
                this.out.write("</binding>");
                this.out.flush();
                this.out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public TypeBinding getTypeBinding(Field field) {
            Class<?> itsType = field.getType();
            if (this.isIgnored(field)) {
                return new NoopTypeBinding(field);
            }
            if (List.class.isAssignableFrom(itsType)) {
                Class listType = InternalSoapBindingGenerator.getTypeArgument(field);
                if (listType == null) {
                    Logs.extreme().debug((Object)String.format("IGNORE: %-70s [type=null] NO GENERIC TYPE FOR LIST\n", field.getDeclaringClass().getCanonicalName() + "." + field.getName()));
                    return new NoopTypeBinding(field);
                }
                if (this.typeBindings.containsKey(listType.getCanonicalName())) {
                    return new CollectionTypeBinding(field.getName(), this.typeBindings.get(listType.getCanonicalName()));
                }
                if (BindingFileSearch.INSTANCE.MSG_DATA_CLASS.isAssignableFrom(listType)) {
                    return new CollectionTypeBinding(field.getName(), new ObjectTypeBinding(field.getName(), listType));
                }
                if (Enum.class.isAssignableFrom(listType)) {
                    return new CollectionTypeBinding(field.getName(), new EnumTypeBinding(field.getName(), listType));
                }
                Logs.extreme().debug((Object)String.format("IGNORE: %-70s [type=%s] LIST'S GENERIC TYPE DOES NOT CONFORM TO EucalyptusData\n", field.getDeclaringClass().getCanonicalName() + "." + field.getName(), listType.getCanonicalName()));
                return new NoopTypeBinding(field);
            }
            if (this.typeBindings.containsKey(itsType.getCanonicalName())) {
                TypeBinding t = this.typeBindings.get(itsType.getCanonicalName());
                try {
                    t = (TypeBinding)this.typeBindings.get(itsType.getCanonicalName()).getClass().newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return t.value(field.getName());
            }
            if (BindingFileSearch.INSTANCE.MSG_DATA_CLASS.isAssignableFrom(field.getType())) {
                return new ObjectTypeBinding(field);
            }
            if (Enum.class.isAssignableFrom(field.getType())) {
                return new EnumTypeBinding(field.getName(), field.getType());
            }
            Logs.extreme().debug((Object)String.format("IGNORE: %-70s [type=%s] TYPE DOES NOT CONFORM TO EucalyptusData\n", field.getDeclaringClass().getCanonicalName() + "." + field.getName(), field.getType().getCanonicalName()));
            return new NoopTypeBinding(field);
        }

        public static Class getTypeArgument(Field f) {
            Type tv;
            Type t = f.getGenericType();
            if (t != null && t instanceof ParameterizedType && (tv = ((ParameterizedType)t).getActualTypeArguments()[0]) instanceof Class) {
                return (Class)tv;
            }
            return null;
        }

        public boolean isIgnored(final Field field) {
            int mods = field.getModifiers();
            final String name = field.getName();
            final String type = field.getType().getSimpleName();
            if (Modifier.isFinal(mods)) {
                Logs.extreme().debug((Object)("Ignoring field with bad type: " + field.getDeclaringClass().getCanonicalName() + "." + name + " of type " + type + " due to: final modifier"));
            } else if (Modifier.isStatic(mods)) {
                Logs.extreme().debug((Object)("Ignoring field with bad type: " + field.getDeclaringClass().getCanonicalName() + "." + name + " of type " + type + " due to: static modifier"));
            }
            boolean ret = Iterables.any(badClasses, (Predicate)new Predicate<String>(){

                public boolean apply(String arg0) {
                    if (type.matches(arg0)) {
                        Logs.extreme().debug((Object)("Ignoring field with bad type: " + field.getDeclaringClass().getCanonicalName() + "." + name + " of type " + type + " due to: " + arg0));
                        return true;
                    }
                    return false;
                }
            });
            return ret |= Iterables.any(badFields, (Predicate)new Predicate<String>(){

                public boolean apply(String arg0) {
                    if (name.matches(arg0)) {
                        Logs.extreme().debug((Object)("Ignoring field with bad name: " + field.getDeclaringClass().getCanonicalName() + "." + name + " of type " + type + " due to: " + arg0));
                        return true;
                    }
                    return false;
                }
            });
        }

        public File getOutFile() {
            return this.outFile;
        }

        class BooleanTypeBinding
        extends TypeBinding {
            BooleanTypeBinding() {
            }

            @Override
            public String getTypeName() {
                return Boolean.class.getCanonicalName();
            }
        }

        class StringTypeBinding
        extends TypeBinding {
            StringTypeBinding() {
            }

            @Override
            public String getTypeName() {
                return String.class.getCanonicalName();
            }
        }

        class DoubleTypeBinding
        extends TypeBinding {
            DoubleTypeBinding() {
            }

            @Override
            public String getTypeName() {
                return Double.class.getCanonicalName();
            }
        }

        class LongTypeBinding
        extends TypeBinding {
            LongTypeBinding() {
            }

            @Override
            public String getTypeName() {
                return Long.class.getCanonicalName();
            }
        }

        class IntegerTypeBinding
        extends TypeBinding {
            IntegerTypeBinding() {
            }

            @Override
            public String getTypeName() {
                return Integer.class.getCanonicalName();
            }
        }

        class CollectionTypeBinding
        extends TypeBinding {
            private TypeBinding type;
            private String name;

            public CollectionTypeBinding(String name, TypeBinding type) {
                this.name = name;
                this.type = type;
                Logs.extreme().debug((Object)("Found list type: " + type.getClass().getCanonicalName()));
            }

            @Override
            public String getTypeName() {
                return this.type.getTypeName();
            }

            @Override
            public String toString() {
                Logs.extreme().debug((Object)("Found list type: " + this.type.getTypeName() + " for name: " + this.name));
                String ret = this.type.collection(this.name).buf.toString();
                this.type.collection(this.name).buf = new StringBuilder();
                return ret;
            }
        }

        class EnumTypeBinding
        extends TypeBinding {
            private final String name;
            private final Class<?> enumType;

            EnumTypeBinding(String name, Class<?> enumType) {
                this.name = name;
                this.enumType = enumType;
            }

            @Override
            public String getTypeName() {
                return this.enumType.getCanonicalName();
            }

            @Override
            public String toString() {
                this.value(this.name);
                return super.toString();
            }
        }

        class ObjectTypeBinding
        extends TypeBinding {
            private String name;
            private Class type;

            public ObjectTypeBinding(String name, Class type) {
                this.name = name;
                this.type = type;
            }

            public ObjectTypeBinding(Field field) {
                this.name = field.getName();
                this.type = field.getType();
            }

            @Override
            protected TypeBinding collection(String name) {
                this.elem(Elem.structure).attr("name", name).attr("usage", "optional");
                this.elem(Elem.collection).attr("factory", "com.eucalyptus.binding.Binding.listFactory").attr("field", name).attr("usage", "required");
                this.elem(Elem.structure).attr("name", "item").attr("map-as", this.type.getCanonicalName());
                this.end().end().end();
                return this;
            }

            @Override
            public String getTypeName() {
                return this.type.getCanonicalName();
            }

            @Override
            public String toString() {
                this.elem(Elem.structure).attr("name", this.name).attr("field", this.name).attr("map-as", this.type.getCanonicalName()).attr("usage", "optional").end();
                return super.toString();
            }
        }

        class NoopTypeBinding
        extends TypeBinding {
            public NoopTypeBinding(Field field) {
            }

            @Override
            public String toString() {
                return "";
            }

            @Override
            public String getTypeName() {
                return "NOOP";
            }
        }

        static enum Elem {
            structure,
            collection,
            value,
            mapping,
            binding,
            namespace;

        }

        private class ElemItem {
            Elem name;
            int indentCount;
            boolean children;

            public ElemItem(Elem name, int indent, boolean children) {
                this.name = name;
                this.indentCount = indent;
                this.children = children;
            }

            public String toString() {
                return String.format("ElemItem [name=%s, indent=%s, children=%s]", new Object[]{this.name, this.indentCount, this.children});
            }
        }

        abstract class TypeBinding {
            private StringBuilder buf = new StringBuilder();

            TypeBinding() {
            }

            public abstract String getTypeName();

            private TypeBinding reindent(int delta) {
                InternalSoapBindingGenerator.this.indent += delta;
                INDENT = "";
                for (int i = 0; i < InternalSoapBindingGenerator.this.indent; ++i) {
                    INDENT = INDENT + "  ";
                }
                return this;
            }

            private TypeBinding indent(String addMe) {
                this.reindent(1).append(INDENT).append(addMe);
                return this;
            }

            private TypeBinding outdent(String addMe) {
                this.reindent(-1).append(INDENT).append(addMe);
                return this;
            }

            protected TypeBinding append(Object o) {
                this.buf.append("" + o);
                return this;
            }

            protected TypeBinding eolIn() {
                this.append("\n").indent(INDENT);
                return this;
            }

            protected TypeBinding eolOut() {
                this.append("\n").outdent(INDENT);
                return this;
            }

            protected TypeBinding eol() {
                this.append("\n").append(INDENT);
                return this;
            }

            protected TypeBinding value(String name) {
                this.elem(Elem.value).attr("name", name).attr("field", name).attr("usage", "optional").attr("style", "element").end();
                return this;
            }

            private TypeBinding begin() {
                ElemItem top = (ElemItem)InternalSoapBindingGenerator.this.elemStack.peek();
                if (top != null && top.children) {
                    this.eol();
                } else if (top != null && !top.children) {
                    this.append(">").eolIn();
                    top.children = true;
                } else {
                    this.eolIn();
                }
                return this;
            }

            protected TypeBinding elem(Elem name) {
                this.begin().append("<").append(name.toString()).append(" ");
                InternalSoapBindingGenerator.this.elemStack.push(new ElemItem(name, InternalSoapBindingGenerator.this.indent, false));
                return this;
            }

            protected TypeBinding end() {
                ElemItem top = (ElemItem)InternalSoapBindingGenerator.this.elemStack.pop();
                if (top != null && top.children) {
                    this.eolOut().append("</").append(top.name.toString()).append(">");
                } else if (top != null && !top.children) {
                    this.append("/>");
                } else {
                    this.append("/>");
                }
                return this;
            }

            protected TypeBinding attr(String name, String value) {
                this.append(name).append("=\"").append(value).append("\" ");
                return this;
            }

            public String toString() {
                String s = this.buf.toString();
                this.buf = new StringBuilder(this.buf.capacity());
                return s;
            }

            protected TypeBinding collection(String name) {
                this.elem(Elem.structure).attr("name", name).attr("usage", "optional");
                this.elem(Elem.collection).attr("factory", "com.eucalyptus.binding.Binding.listFactory").attr("field", name).attr("item-type", this.getTypeName()).attr("usage", "required");
                this.elem(Elem.structure).attr("name", "item");
                this.elem(Elem.value).attr("name", "entry").end().end().end().end();
                return this;
            }
        }

        class RootObjectTypeBinding
        extends TypeBinding {
            private Class type;
            private boolean abs;

            public RootObjectTypeBinding(Class type) {
                InternalSoapBindingGenerator.this.indent = 2;
                this.type = type;
                this.abs = Object.class.equals(type.getSuperclass()) || type.getSuperclass().getSimpleName().equals("EucalyptusData");
            }

            @Override
            public String getTypeName() {
                return this.type.getCanonicalName();
            }

            public String process() {
                if (this.type.getCanonicalName() != null) {
                    this.elem(Elem.mapping);
                    if (this.abs) {
                        this.attr("abstract", "true");
                    } else {
                        String elementName = this.type.getSimpleName();
                        if (BindingFileSearch.BINDING_CLASS_ELEMENT_MAP.get((Object)elementName).size() > 1) {
                            if (Ats.inClassHierarchy(this.type).has(ComponentMessage.class)) {
                                ComponentMessage compMsg = Ats.inClassHierarchy(this.type).get(ComponentMessage.class);
                                elementName = compMsg.value().getSimpleName() + "." + elementName;
                                LOG.debug((Object)("Binding generation encountered an element naming conflict.  Using " + elementName + " for " + this.type.getCanonicalName()));
                            } else {
                                elementName = this.type.getCanonicalName();
                                LOG.error((Object)("BUG: Fix your message type definitions for " + this.type));
                                LOG.error((Object)("BUG: Binding generation encountered an element naming conflict.  Using " + elementName + " for " + this.type.getCanonicalName()));
                            }
                        }
                        this.attr("name", elementName);
                        this.attr("extends", this.type.getSuperclass().getCanonicalName());
                    }
                    this.attr("class", this.type.getCanonicalName());
                    if (BindingFileSearch.INSTANCE.MSG_BASE_CLASS.isAssignableFrom(this.type.getSuperclass()) || BindingFileSearch.INSTANCE.MSG_DATA_CLASS.isAssignableFrom(this.type.getSuperclass())) {
                        this.elem(Elem.structure).attr("map-as", this.type.getSuperclass().getCanonicalName()).end();
                    }
                    for (Field f : this.type.getDeclaredFields()) {
                        TypeBinding tb;
                        if (Ats.from(f).has(Transient.class) && !Modifier.isTransient(f.getModifiers()) || (tb = InternalSoapBindingGenerator.this.getTypeBinding(f)) instanceof NoopTypeBinding) continue;
                        this.append(tb.toString());
                    }
                    this.end();
                }
                return this.toString();
            }
        }
    }

    static enum BindingFileSearch implements Predicate<URI>
    {
        INSTANCE;

        private static final String BINDING_EMPTY = "<binding>\n</binding>";
        private static final Boolean BINDING_DEBUG;
        private static final Boolean BINDING_DEBUG_EXTREME;
        private static List<URI> BINDING_LIST;
        private static ConcurrentMap<String, Class> BINDING_CLASS_MAP;
        private static Multimap<String, Class> BINDING_CLASS_ELEMENT_MAP;
        private static final String BINDING_CACHE_JAR_PREFIX = "jar.";
        private static final String BINDING_CACHE_BINDING_PREFIX = "binding.";
        private static final String BINDING_CACHE_DIGEST_LIST = "classcache.properties";
        private static final File CACHE_LIST;
        private final Class<?> MSG_BASE_CLASS;
        private final Class<?> MSG_DATA_CLASS;
        private static final String FILE_PATTERN;
        private static final Properties CURRENT_PROPS;

        private BindingFileSearch() {
            try {
                this.MSG_BASE_CLASS = Class.forName("edu.ucsb.eucalyptus.msgs.BaseMessage");
                this.MSG_DATA_CLASS = Class.forName("edu.ucsb.eucalyptus.msgs.EucalyptusData");
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw Exceptions.toUndeclared(ex);
            }
        }

        public boolean check() {
            ImmutableMap newBindings;
            ImmutableMap oldBindings;
            Properties oldProps = new Properties();
            if (CACHE_LIST.exists()) {
                try {
                    BufferedReader propIn = Files.newReader((File)CACHE_LIST, (Charset)Charset.defaultCharset());
                    oldProps.load(propIn);
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex, (Throwable)ex);
                }
            }
            if ((oldBindings = Maps.fromProperties((Properties)oldProps)).equals(newBindings = Maps.fromProperties((Properties)CURRENT_PROPS))) {
                LOG.info((Object)"Found up-to-date binding class cache: skipping message binding.");
                return true;
            }
            LOG.info((Object)"Binding class cache expired, rebuilding.");
            DeleteRecursively.PREDICATE.apply(SubDirectory.CLASSCACHE.getFile());
            if (!SubDirectory.CLASSCACHE.getFile().mkdirs() && !SubDirectory.CLASSCACHE.getFile().exists()) {
                LOG.error((Object)("Error creating class cache directory: " + SubDirectory.CLASSCACHE.getFile().getAbsolutePath()));
            }
            return false;
        }

        public void store() throws IOException {
            FileWriter propOut = new FileWriter(CACHE_LIST);
            try {
                try {
                    CURRENT_PROPS.store(propOut, "Binding class cache generated on: ");
                    ((Writer)propOut).close();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    ((Writer)propOut).close();
                }
            }
            catch (IOException ex) {
                DeleteRecursively.PREDICATE.apply(SubDirectory.CLASSCACHE.getFile());
                if (!SubDirectory.CLASSCACHE.getFile().mkdirs() && !SubDirectory.CLASSCACHE.getFile().exists()) {
                    LOG.error((Object)("Error creating class cache directory: " + SubDirectory.CLASSCACHE.getFile().getAbsolutePath()));
                }
                throw ex;
            }
        }

        public void process(File f) throws Exception {
            if (f.isDirectory()) {
                File[] files;
                for (File ff : files = f.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.matches(FILE_PATTERN);
                    }
                })) {
                    byte[] bindingBytes = Files.toByteArray((File)ff);
                    this.addCurrentBinding(bindingBytes, ff.getName(), "file:" + ff.getAbsolutePath());
                }
            } else {
                byte[] digestBytes = Files.hash((File)f, (HashFunction)Hashing.md5()).asBytes();
                String digest = new BigInteger(digestBytes).abs().toString(16);
                CURRENT_PROPS.put(BINDING_CACHE_JAR_PREFIX + f.getName(), digest);
                JarFile jar = new JarFile(f);
                ArrayList<JarEntry> jarList = Collections.list(jar.entries());
                for (JarEntry j : jarList) {
                    try {
                        if (j.getName().matches(FILE_PATTERN)) {
                            byte[] bindingBytes = ByteStreams.toByteArray((InputStream)jar.getInputStream(j));
                            String bindingName = j.getName();
                            String bindingFullPath = "jar:file:" + f.getAbsolutePath() + "!/" + bindingName;
                            this.addCurrentBinding(bindingBytes, bindingName, bindingFullPath);
                            continue;
                        }
                        if (!j.getName().matches(".*\\.class.{0,1}")) continue;
                        String classGuess = j.getName().replaceAll("/", ".").replaceAll("\\.class.{0,1}", "");
                        Class<?> candidate = ClassLoader.getSystemClassLoader().loadClass(classGuess);
                        if (!this.MSG_BASE_CLASS.isAssignableFrom(candidate) && !this.MSG_DATA_CLASS.isAssignableFrom(candidate)) continue;
                        InputSupplier classSupplier = Resources.newInputStreamSupplier((URL)ClassLoader.getSystemResource(j.getName()));
                        File destClassFile = SubDirectory.CLASSCACHE.getChildFile(j.getName());
                        if (!destClassFile.exists()) {
                            Files.createParentDirs((File)destClassFile);
                            Files.copy((InputSupplier)classSupplier, (File)destClassFile);
                            Logs.extreme().debug((Object)("Caching: " + j.getName() + " => " + destClassFile.getAbsolutePath()));
                        }
                        BINDING_CLASS_MAP.putIfAbsent(classGuess, candidate);
                        BINDING_CLASS_ELEMENT_MAP.put((Object)candidate.getSimpleName(), candidate);
                    }
                    catch (RuntimeException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        jar.close();
                        throw ex;
                    }
                }
                jar.close();
            }
        }

        private void addCurrentBinding(byte[] bindingBytes, String bindingName, String bindingFullPath) {
            LOG.debug((Object)("Binding cache: loading binding from: " + bindingFullPath));
            BINDING_LIST.add(URI.create(bindingFullPath));
            String digest = new BigInteger(Digest.MD5.get().digest(bindingBytes)).abs().toString(16);
            String entryName = BINDING_CACHE_BINDING_PREFIX + bindingName;
            if (!CURRENT_PROPS.containsKey(entryName)) {
                CURRENT_PROPS.put(entryName, digest);
            } else {
                LOG.info((Object)("Duplicate binding entry: " + CURRENT_PROPS.getProperty(entryName)));
            }
        }

        public boolean apply(URI input) {
            try {
                ValidationContext vctx = BindingElement.newValidationContext();
                BindingElement root = BindingElement.validateBinding((String)input.toASCIIString(), (URL)input.toURL(), (InputStream)input.toURL().openStream(), (ValidationContext)vctx);
                Predicate<BindingElement> writeFile = new Predicate<BindingElement>(){

                    public boolean apply(BindingElement input) {
                        for (ElementBase child : input.topChildren()) {
                            try {
                                if (child instanceof MappingElement) {
                                    MappingElementBase mapping = (MappingElementBase)child;
                                    ClassFile classFile = mapping.getHandledClass().getClassFile();
                                    String classFileName = classFile.getName().replace(".", "/") + ".class";
                                    InputSupplier classSupplier = Resources.newInputStreamSupplier((URL)ClassLoader.getSystemResource(classFileName));
                                    File destClassFile = SubDirectory.CLASSCACHE.getChildFile(classFileName);
                                    if (!destClassFile.exists()) {
                                        Files.createParentDirs((File)destClassFile);
                                        Files.copy((InputSupplier)classSupplier, (File)destClassFile);
                                    }
                                    ClassFile.getClassFile((String)classFile.getName());
                                    Logs.extreme().debug((Object)("Caching: " + classFile.getName() + " => " + destClassFile.getAbsolutePath()));
                                    continue;
                                }
                                if (!(child instanceof IncludeElement)) continue;
                                IncludeElement includeElement = (IncludeElement)child;
                                BindingElement bind = includeElement.getBinding();
                                if (bind != null) {
                                    this.apply(bind);
                                    continue;
                                }
                                Files.write((byte[])BindingFileSearch.BINDING_EMPTY.getBytes(), (File)SubDirectory.CLASSCACHE.getChildFile(includeElement.getIncludePath().replace("classpath:", "")));
                            }
                            catch (Exception ex) {
                                LOG.error((Object)("Failed in caching message class for mapping element: " + ((MappingElementBase)child).getClassName() + " because of: " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        return true;
                    }
                };
                if (!writeFile.apply((Object)root)) {
                    writeFile.apply((Object)root);
                }
                return true;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        public static void compile() {
            LOG.info((Object)"Binding cache: processing message and binding files.");
            BindingFileSearch.processFiles();
            if (INSTANCE.check()) {
                LOG.info((Object)"Binding cache: nothing to do.");
            } else {
                LOG.info((Object)"Binding cache: regenerating cache.");
                try {
                    LOG.info((Object)"Binding cache: generating internal bindings.");
                    InternalSoapBindingGenerator gen = new InternalSoapBindingGenerator();
                    for (Class genBindClass : BINDING_CLASS_MAP.values()) {
                        Logs.extreme().debug((Object)("Generating binding: " + genBindClass));
                        gen.processClass(genBindClass);
                    }
                    gen.close();
                    BINDING_LIST.add(gen.getOutFile().toURI());
                    byte[] digestBytes = Files.hash((File)gen.getOutFile(), (HashFunction)Hashing.md5()).asBytes();
                    String digest = new BigInteger(digestBytes).abs().toString(16);
                    CURRENT_PROPS.put(BINDING_CACHE_BINDING_PREFIX + gen.getOutFile().getName(), digest);
                    LOG.info((Object)"Binding cache: populating cache from transitive closure of bindings.");
                    BindingFileSearch.reset(Utility.getClassPaths());
                    Iterables.all(BINDING_LIST, (Predicate)INSTANCE);
                    BindingFileSearch.reset(Utility.getClassPaths());
                    LOG.info((Object)"Binding cache: loading and validating bindings.");
                    TreeMap bindingDefs = Maps.newTreeMap();
                    for (URI uRI : BINDING_LIST) {
                        String shortPath = uRI.toURL().getPath().replaceAll(".*!/", "");
                        String sname = Utility.bindingFromFileName((String)shortPath);
                        BindingDefinition def = Utility.loadBinding((String)uRI.toASCIIString(), (String)sname, (InputStream)uRI.toURL().openStream(), (URL)uRI.toURL(), (boolean)true);
                        bindingDefs.put(uRI, def);
                        def.print();
                    }
                    LOG.info((Object)"Binding cache: compiling bindings.");
                    for (Map.Entry entry : bindingDefs.entrySet()) {
                        try {
                            LOG.info((Object)("Binding cache: " + entry.getKey()));
                            ((BindingDefinition)entry.getValue()).generateCode(BINDING_DEBUG.booleanValue(), BINDING_DEBUG_EXTREME.booleanValue());
                        }
                        catch (RuntimeException e) {
                            throw new JiBXException("\n*** Error during code generation for file '" + entry.getKey() + "' -\n this may be due to an error in " + "your binding or classpath, or to an error in the " + "JiBX code ***\n", (Throwable)e);
                        }
                    }
                    ClassFile[][] lists = MungedClass.fixDispositions();
                    for (BindingDefinition def : bindingDefs.values()) {
                        def.addClassList(lists[0], lists[1]);
                    }
                    MungedClass.writeChanges();
                    LOG.info((Object)("Binding cache: wrote " + lists[0].length + " files"));
                    LOG.info((Object)("Binding cache: kept " + lists[1].length + " files unchanged:"));
                    LOG.info((Object)("Binding cache: deleted " + lists[2].length + " files:"));
                    INSTANCE.store();
                    System.exit(123);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    System.exit(1);
                    throw new Error("Failed to prepare the system while trying to compile bindings: " + ex.getMessage(), ex);
                }
            }
        }

        public static void processFiles() {
            File libDir = new File(BaseDirectory.LIB.toString());
            for (File f : libDir.listFiles()) {
                if (!f.getName().startsWith("eucalyptus") || !f.getName().endsWith(".jar") || f.getName().matches(".*-ext-.*")) continue;
                EventRecord.here(ServiceJarDiscovery.class, EventType.BOOTSTRAP_INIT_SERVICE_JAR, f.getName()).info();
                try {
                    INSTANCE.process(f);
                }
                catch (Throwable e) {
                    LOG.error((Object)e.getMessage());
                }
            }
            for (String pathName : ClassPath.getClassPath().split(File.pathSeparator)) {
                File pathFile = new File(pathName);
                if (!pathFile.isDirectory()) continue;
                try {
                    INSTANCE.process(pathFile);
                }
                catch (Throwable e) {
                    LOG.error((Object)e.getMessage());
                }
            }
        }

        public static String[] reset(String[] paths) {
            ClassCache.setPaths((String[])paths);
            ClassFile.setPaths((String[])paths);
            ClasspathUrlExtender.setClassLoader((ClassLoader)ClassFile.getClassLoader());
            BoundClass.reset();
            MungedClass.reset();
            BindingDefinition.reset();
            BranchWrapper.setTracking((boolean)false);
            BranchWrapper.setErrorOverride((boolean)false);
            return paths;
        }

        static {
            BINDING_DEBUG = System.getProperty("euca.binding.debug") != null;
            BINDING_DEBUG_EXTREME = System.getProperty("euca.binding.debug.extreme") != null;
            BINDING_LIST = Lists.newArrayList();
            BINDING_CLASS_MAP = Maps.newConcurrentMap();
            BINDING_CLASS_ELEMENT_MAP = HashMultimap.create();
            CACHE_LIST = SubDirectory.CLASSCACHE.getChildFile(BINDING_CACHE_DIGEST_LIST);
            FILE_PATTERN = System.getProperty("euca.binding.pattern", ".*\\-binding.xml");
            CURRENT_PROPS = new Properties();
        }

        static enum DeleteRecursively implements Predicate<File>
        {
            PREDICATE;


            public boolean apply(@Nullable File input) {
                if (input != null) {
                    try {
                        if (input.isDirectory()) {
                            LOG.info((Object)("Cleaning up class cache: " + input.getCanonicalPath()));
                            Iterables.all(Arrays.asList(input.listFiles()), (Predicate)PREDICATE);
                            if (!input.delete()) {
                                LOG.error((Object)("Unable to delete directory: " + input.getAbsolutePath()));
                            }
                        } else if (!input.delete()) {
                            LOG.error((Object)("Unable to delete file: " + input.getAbsolutePath()));
                        }
                    }
                    catch (SecurityException ex) {
                        LOG.error((Object)ex);
                        throw ex;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                    }
                }
                return true;
            }
        }
    }
}

