/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.binding;

import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.util.NamespaceMappingXMLStreamWriter;
import com.eucalyptus.ws.WebServicesException;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StAXReaderWrapper;
import org.jibx.runtime.impl.StAXWriter;
import org.jibx.runtime.impl.UnmarshallingContext;

public class Binding {
    private static Logger LOG = Logger.getLogger(Binding.class);
    private final String name;
    private IBindingFactory bindingFactory;
    private Map<String, Class> elementToClassMap = Maps.newHashMap();
    private Map<String, String> classToElementMap = Maps.newHashMap();
    private Map<String, String> classToNamespaceMap = Maps.newHashMap();

    protected Binding(String name) {
        this.name = name;
    }

    public boolean hasElementClass(String elementName) throws BindingException {
        return this.elementToClassMap.containsKey(elementName);
    }

    public Class getElementClass(String elementName) throws BindingException {
        if (!this.elementToClassMap.containsKey(elementName)) {
            throw new BindingException("Failed to find corresponding class mapping for element: " + elementName + " in namespace: " + this.name);
        }
        return this.elementToClassMap.get(elementName);
    }

    public IBindingFactory seed(Class seed) throws BindingException {
        try {
            this.bindingFactory = BindingDirectory.getFactory((String)this.name, (Class)seed);
            String[] mappedClasses = this.bindingFactory.getMappedClasses();
            for (int i = 0; i < mappedClasses.length; ++i) {
                if (this.bindingFactory.getElementNames()[i] == null) continue;
                try {
                    this.elementToClassMap.put(this.bindingFactory.getElementNames()[i], ClassLoader.getSystemClassLoader().loadClass(mappedClasses[i]));
                    this.classToElementMap.put(mappedClasses[i], this.bindingFactory.getElementNames()[i]);
                    this.classToNamespaceMap.put(mappedClasses[i], this.bindingFactory.getElementNamespaces()[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LOG.trace((Object)e, (Throwable)e);
                }
            }
        }
        catch (JiBXException e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new BindingException("Failed to build binding factory for " + this.name + " with seed class " + seed.getCanonicalName());
        }
        return this.bindingFactory;
    }

    public String toString(Object param) {
        StringWriter out = new StringWriter();
        try {
            IBindingFactory bindingFactory = BindingDirectory.getFactory((String)BindingManager.defaultBindingName(), param.getClass());
            IMarshallingContext mctx = bindingFactory.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument((Object)this, "UTF-8", null, (Writer)out);
        }
        catch (JiBXException e) {
            Logger.getLogger(BaseMessage.class).debug((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            Logger.getLogger(BaseMessage.class).error((Object)e, (Throwable)e);
        }
        return out.toString();
    }

    public String toStream(OutputStream outputStream, Object param) throws BindingException {
        return this.toStream(outputStream, param, null);
    }

    public String toStream(OutputStream outputStream, Object param, String altNs) throws BindingException {
        String useNs;
        if (param == null) {
            throw new BindingException("Cannot bind null value");
        }
        if (!(param instanceof IMarshallable)) {
            throw new BindingException("No JiBX <mapping> defined for class " + param.getClass());
        }
        IMarshallable mrshable = (IMarshallable)param;
        String fqName = mrshable.JiBX_getName();
        String origNs = this.classToNamespaceMap.get(fqName);
        String string = useNs = altNs != null ? altNs : origNs;
        if (this.bindingFactory == null) {
            throw new BindingException("Failed to prepare binding factory (unset) for message: " + param.getClass().getCanonicalName() + " with namespace: " + useNs);
        }
        if (this.bindingFactory.getElementNamespaces() == null) {
            LOG.error((Object)"Binding factory's element namespace is empty");
            throw new BindingException("Failed to prepare binding factory for message: " + param.getClass().getCanonicalName() + " with namespace: " + useNs);
        }
        HoldMe.canHas.lock();
        try {
            IMarshallingContext mctx = this.bindingFactory.createMarshallingContext();
            NamespaceMappingXMLStreamWriter wrtr = new NamespaceMappingXMLStreamWriter(HoldMe.getXMLOutputFactory().createXMLStreamWriter(outputStream, null), Collections.singletonMap(origNs, useNs));
            StAXWriter staxWriter = new StAXWriter(this.bindingFactory.getNamespaces(), (XMLStreamWriter)wrtr);
            mctx.setXmlWriter((IXMLWriter)staxWriter);
            mctx.marshalDocument(param);
            mctx.getXmlWriter().flush();
        }
        catch (IOException | XMLStreamException | JiBXException e) {
            throw new BindingException(this.name + " failed to marshall type " + param.getClass().getCanonicalName() + " with ns:" + useNs + " caused by: " + e.getMessage(), e);
        }
        finally {
            HoldMe.canHas.unlock();
        }
        return useNs;
    }

    public OMElement toOM(Object param) throws BindingException {
        return this.toOM(param, null);
    }

    public OMElement toOM(Object param, String altNs) throws BindingException {
        OMElement retVal;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String useNs = this.toStream(bos, param, altNs);
        HoldMe.canHas.lock();
        try {
            StAXOMBuilder stAXOMBuilder = HoldMe.getStAXOMBuilder(HoldMe.getXMLStreamReader(bos.toString()));
            retVal = stAXOMBuilder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new BindingException(this.name + " failed to marshall type " + param.getClass().getCanonicalName() + " with ns:" + useNs + " caused by: " + e.getMessage(), e);
        }
        finally {
            HoldMe.canHas.unlock();
        }
        return retVal;
    }

    public UnmarshallingContext getNewUnmarshalContext(OMElement param) throws JiBXException {
        if (this.bindingFactory == null) {
            throw new RuntimeException("Binding bootstrap failed to construct the binding factory for " + this.name);
        }
        UnmarshallingContext ctx = (UnmarshallingContext)this.bindingFactory.createUnmarshallingContext();
        StAXReaderWrapper reader = new StAXReaderWrapper(param.getXMLStreamReader(), "SOAP-message", true);
        ctx.setDocument((IXMLReader)reader);
        ctx.toTag();
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromOM(String text) throws Exception {
        HoldMe.canHas.lock();
        try {
            StAXOMBuilder builder = HoldMe.getStAXOMBuilder(HoldMe.getXMLStreamReader(text));
            Object object = this.fromOM(builder.getDocumentElement());
            return object;
        }
        finally {
            HoldMe.canHas.unlock();
        }
    }

    public static <T> List<T> listFactory() {
        return new ArrayList();
    }

    public Object fromOM(OMElement param, Class type) throws WebServicesException {
        try {
            UnmarshallingContext ctx = this.getNewUnmarshalContext(param);
            return ctx.unmarshalElement(type);
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
            throw new WebServicesException(e.getMessage());
        }
    }

    public Object fromOM(OMElement param, String namespace) throws WebServicesException {
        StringWriter out = new StringWriter();
        try {
            param.serialize((Writer)out);
            return this.fromOM(out.toString().replace(param.getNamespace().getNamespaceURI(), namespace));
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
            throw new WebServicesException(e.getMessage());
        }
    }

    public Object fromOM(OMElement param) throws WebServicesException {
        try {
            UnmarshallingContext ctx = this.getNewUnmarshalContext(param);
            return ctx.unmarshalElement();
        }
        catch (Exception e) {
            LOG.warn((Object)e, (Throwable)e);
            throw new WebServicesException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromStream(Class<T> type, InputStream in) throws Exception {
        HoldMe.canHas.lock();
        try {
            if (this.bindingFactory == null) {
                throw new RuntimeException("Binding bootstrap failed to construct the binding factory for " + this.name);
            }
            UnmarshallingContext ctx = (UnmarshallingContext)this.bindingFactory.createUnmarshallingContext();
            StAXReaderWrapper reader = new StAXReaderWrapper(HoldMe.getXMLStreamReader(in), type.getSimpleName(), true);
            ctx.setDocument((IXMLReader)reader);
            Object object = ctx.unmarshalElement(type);
            return (T)object;
        }
        finally {
            HoldMe.canHas.unlock();
        }
    }

    public static String createRestFault(String faultCode, String faultReason, String faultDetails) {
        faultCode = faultCode != null ? faultCode : HttpResponseStatus.INTERNAL_SERVER_ERROR.toString();
        faultReason = faultReason != null ? faultReason : "unknown";
        faultDetails = faultDetails != null ? faultDetails : "unknown";
        return "<?xml version=\"1.0\"?><Response><Errors><Error><Code>" + faultCode.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</Code><Message>" + faultReason.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</Message></Error></Errors><RequestID>" + faultDetails.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</RequestID></Response>";
    }

    public static SOAPEnvelope createFault(String faultCode, String faultReason, String faultDetails) {
        SOAPFactory soapFactory = HoldMe.getOMSOAP11Factory();
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
        soapFaultCode.setText(faultCode);
        SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
        soapFaultReason.setText(faultReason);
        SOAPFaultDetail soapFaultDetail = soapFactory.createSOAPFaultDetail();
        soapFaultDetail.setText(faultDetails);
        SOAPEnvelope soapEnv = soapFactory.getDefaultEnvelope();
        SOAPFault soapFault = soapFactory.createSOAPFault();
        soapFault.setCode(soapFaultCode);
        soapFault.setDetail(soapFaultDetail);
        soapFault.setReason(soapFaultReason);
        soapEnv.getBody().addFault(soapFault);
        return soapEnv;
    }
}

