/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.util;

import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class X509CertHelper {
    public static String fromCertificate(X509Certificate x509) {
        return B64.url.encString(PEMFiles.getBytes(x509));
    }

    public static X509Certificate toCertificate(String x509PemString) {
        return PEMFiles.getCert(B64.url.dec(x509PemString));
    }

    public static String certificateToPem(X509Certificate x509) {
        try {
            return new String(PEMFiles.getBytes(x509), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(PEMFiles.getBytes(x509));
        }
    }

    public static X509Certificate pemToCertificate(String pem) {
        return PEMFiles.getCert(pem.getBytes(Charsets.UTF_8));
    }

    public static String privateKeyToPem(PrivateKey pk) {
        return new String(PEMFiles.getBytes("RSA PRIVATE KEY", Crypto.getCertificateProvider().getEncoded(pk)), Charsets.UTF_8);
    }

    public static String calcFingerprint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return X509CertHelper.hexify(digest);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String hexify(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(Integer.toHexString((b & 0xF0) >> 4));
            builder.append(Integer.toHexString(b & 0xF));
        }
        return builder.toString();
    }
}

