/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.tokens;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.InvalidAccessKeyAuthException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.tokens.SecurityToken;
import com.eucalyptus.auth.tokens.SecurityTokenValidationException;
import com.eucalyptus.bootstrap.SystemIds;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class SecurityTokenManager {
    private static final Logger log = Logger.getLogger(SecurityTokenManager.class);
    private static final Supplier<SecureRandom> randomSupplier = Crypto.getSecureRandomSupplier();
    private static final SecurityTokenManager instance = new SecurityTokenManager();
    private static final long creationSkewMillis = (Long)Objects.firstNonNull((Object)Longs.tryParse((String)System.getProperty("com.eucalyptus.auth.tokens.creationSkewMillis", "5000")), (Object)5000L);
    private static final int tokenCacheSize = (Integer)Objects.firstNonNull((Object)Ints.tryParse((String)System.getProperty("com.eucalyptus.auth.tokens.cache.maximumSize", "500")), (Object)500);
    private static final Cache<Pair<String, String>, EncryptedSecurityToken> tokenCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize((long)tokenCacheSize).build();

    @Nonnull
    public static SecurityToken issueSecurityToken(@Nonnull User user, @Nullable AccessKey accessKey, int durationTruncationSeconds, int durationSeconds) throws AuthException {
        return instance.doIssueSecurityToken(user, accessKey, durationTruncationSeconds, durationSeconds);
    }

    @Nonnull
    public static SecurityToken issueSecurityToken(@Nonnull User user, int durationSeconds) throws AuthException {
        return instance.doIssueSecurityToken(user, 0, durationSeconds);
    }

    @Nonnull
    public static SecurityToken issueSecurityToken(@Nonnull User user, int durationTruncationSeconds, int durationSeconds) throws AuthException {
        return instance.doIssueSecurityToken(user, durationTruncationSeconds, durationSeconds);
    }

    @Nonnull
    public static SecurityToken issueSecurityToken(@Nonnull Role role, int durationSeconds) throws AuthException {
        return instance.doIssueSecurityToken(role, durationSeconds);
    }

    @Nonnull
    public static TemporaryAccessKey lookupAccessKey(@Nonnull String accessKeyId, @Nonnull String token) throws AuthException {
        return instance.doLookupAccessKey(accessKeyId, token);
    }

    @Nonnull
    protected SecurityToken doIssueSecurityToken(@Nonnull User user, @Nullable AccessKey accessKey, int durationTruncationSeconds, int durationSeconds) throws AuthException {
        AccessKey key;
        Preconditions.checkNotNull((Object)user, (Object)"User is required");
        AccessKey accessKey2 = key = accessKey != null ? accessKey : (AccessKey)Iterables.find((Iterable)((Iterable)Objects.firstNonNull(user.getKeys(), Collections.emptyList())), AccessKeys.isActive(), null);
        if (key == null) {
            throw new AuthException("Key not found for user");
        }
        long restrictedDurationMillis = this.restrictDuration(36, durationTruncationSeconds, durationSeconds);
        if (!key.getUser().getUserId().equals(user.getUserId())) {
            throw new AuthException("Key not valid for user");
        }
        EncryptedSecurityToken encryptedToken = new EncryptedSecurityToken(key.getAccessKey(), user.getUserId(), this.getCurrentTimeMillis(), restrictedDurationMillis);
        return new SecurityToken(encryptedToken.getAccessKeyId(), encryptedToken.getSecretKey(key.getSecretKey()), encryptedToken.encrypt(this.getEncryptionKey(encryptedToken.getAccessKeyId())), encryptedToken.getExpires());
    }

    @Nonnull
    protected SecurityToken doIssueSecurityToken(@Nonnull User user, int durationTruncationSeconds, int durationSeconds) throws AuthException {
        Preconditions.checkNotNull((Object)user, (Object)"User is required");
        String userToken = user.getToken();
        if (userToken == null || userToken.length() < 30) {
            throw new AuthException("Cannot generate token for user");
        }
        long restrictedDurationMillis = this.restrictDuration(36, durationTruncationSeconds, durationSeconds);
        EncryptedSecurityToken encryptedToken = new EncryptedSecurityToken(null, user.getUserId(), this.getCurrentTimeMillis(), restrictedDurationMillis);
        return new SecurityToken(encryptedToken.getAccessKeyId(), encryptedToken.getSecretKey(userToken), encryptedToken.encrypt(this.getEncryptionKey(encryptedToken.getAccessKeyId())), encryptedToken.getExpires());
    }

    @Nonnull
    protected SecurityToken doIssueSecurityToken(@Nonnull Role role, int durationSeconds) throws AuthException {
        Preconditions.checkNotNull((Object)role, (Object)"Role is required");
        long restrictedDurationMillis = this.restrictDuration(1, 0, durationSeconds);
        if (role.getSecret() == null || role.getSecret().length() < 30) {
            throw new AuthException("Cannot generate token for role");
        }
        EncryptedSecurityToken encryptedToken = new EncryptedSecurityToken(role, this.getCurrentTimeMillis(), restrictedDurationMillis);
        return new SecurityToken(encryptedToken.getAccessKeyId(), encryptedToken.getSecretKey(role.getSecret()), encryptedToken.encrypt(this.getEncryptionKey(encryptedToken.getAccessKeyId())), encryptedToken.getExpires());
    }

    @Nonnull
    protected TemporaryAccessKey doLookupAccessKey(final @Nonnull String accessKeyId, final @Nonnull String token) throws AuthException {
        TemporaryAccessKey.TemporaryKeyType type;
        User user;
        String secretKey;
        boolean active;
        EncryptedSecurityToken encryptedToken;
        Preconditions.checkNotNull((Object)accessKeyId, (Object)"Access key identifier is required");
        Preconditions.checkNotNull((Object)token, (Object)"Token is required");
        try {
            Pair<String, String> tokenKey = Pair.pair(accessKeyId, token);
            encryptedToken = (EncryptedSecurityToken)tokenCache.get(tokenKey, (Callable)new Callable<EncryptedSecurityToken>(){

                @Override
                public EncryptedSecurityToken call() throws Exception {
                    return EncryptedSecurityToken.decrypt(accessKeyId, SecurityTokenManager.this.getEncryptionKey(accessKeyId), token);
                }
            });
        }
        catch (ExecutionException e) {
            log.debug((Object)e, (Throwable)e);
            throw new InvalidAccessKeyAuthException("Invalid security token");
        }
        String originatingAccessKeyId = encryptedToken.getOriginatingAccessKeyId();
        String userId = encryptedToken.getUserId();
        if (originatingAccessKeyId != null) {
            AccessKey key = this.lookupAccessKeyById(originatingAccessKeyId);
            active = key.isActive();
            secretKey = encryptedToken.getSecretKey(key.getSecretKey());
            user = key.getUser();
            type = TemporaryAccessKey.TemporaryKeyType.Session;
        } else if (userId != null) {
            user = this.lookupUserById(encryptedToken.getUserId());
            active = user.isEnabled();
            secretKey = encryptedToken.getSecretKey((String)Objects.firstNonNull((Object)user.getToken(), (Object)""));
            type = TemporaryAccessKey.TemporaryKeyType.Access;
        } else {
            Role role = this.lookupRoleById(encryptedToken.getRoleId());
            user = this.roleAsUser(role);
            active = true;
            secretKey = encryptedToken.getSecretKey(role.getSecret());
            type = TemporaryAccessKey.TemporaryKeyType.Role;
        }
        return new TemporaryAccessKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public Boolean isActive() {
                return active && encryptedToken.isValid();
            }

            @Override
            public String getAccessKey() {
                return encryptedToken.getAccessKeyId();
            }

            @Override
            public String getSecurityToken() {
                return token;
            }

            @Override
            public String getSecretKey() {
                return secretKey;
            }

            @Override
            public TemporaryAccessKey.TemporaryKeyType getType() {
                return type;
            }

            @Override
            public Date getCreateDate() {
                return new Date(encryptedToken.getCreated());
            }

            @Override
            public Date getExpiryDate() {
                return new Date(encryptedToken.getExpires());
            }

            @Override
            public User getUser() throws AuthException {
                return user;
            }

            @Override
            public void setActive(Boolean active2) throws AuthException {
            }
        };
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected AccessKey lookupAccessKeyById(String accessKeyId) throws AuthException {
        return Accounts.lookupAccessKeyById(accessKeyId);
    }

    protected User lookupUserById(String userId) throws AuthException {
        return Accounts.lookupUserById(userId);
    }

    protected Role lookupRoleById(String roleId) throws AuthException {
        return Accounts.lookupRoleById(roleId);
    }

    protected User roleAsUser(Role role) throws AuthException {
        return Accounts.roleAsUser(role);
    }

    protected String getSecurityTokenPassword() {
        return SystemIds.securityTokenPassword();
    }

    private long restrictDuration(int maximumDurationHours, int durationTruncationSeconds, int durationSeconds) throws SecurityTokenValidationException {
        long durationMillis;
        long l = durationMillis = durationSeconds == 0 ? TimeUnit.HOURS.toMillis(12L) : TimeUnit.SECONDS.toMillis(durationSeconds);
        if (durationMillis > TimeUnit.HOURS.toMillis(maximumDurationHours)) {
            this.validationFailure(String.format("Invalid duration requested, maximum permitted duration is %s seconds.", TimeUnit.HOURS.toSeconds(maximumDurationHours)));
        }
        if (durationMillis < TimeUnit.MINUTES.toMillis(15L)) {
            this.validationFailure("Invalid duration requested, minimum permitted duration is 900 seconds.");
        }
        if (durationTruncationSeconds > 0 && durationMillis > TimeUnit.SECONDS.toMillis(durationTruncationSeconds)) {
            durationMillis = TimeUnit.SECONDS.toMillis(durationTruncationSeconds);
        }
        return durationMillis;
    }

    private void validationFailure(String message) throws SecurityTokenValidationException {
        throw new SecurityTokenValidationException(message);
    }

    private SecretKey getEncryptionKey(String salt) {
        MessageDigest digest = Digest.SHA256.get();
        digest.update(salt.getBytes(Charsets.UTF_8));
        digest.update(this.getSecurityTokenPassword().getBytes(Charsets.UTF_8));
        return new SecretKeySpec(digest.digest(), "AES");
    }

    private static final class SecurityTokenInput {
        private final InputStream in;

        private SecurityTokenInput(byte[] data) {
            this.in = new InflaterInputStream(new ByteArrayInputStream(data));
        }

        private String readString() throws IOException {
            byte[] data = new byte[this.readInt()];
            if (this.in.read(data) != data.length) {
                throw new IOException();
            }
            return new String(data, Charsets.UTF_8);
        }

        private int readInt() throws IOException {
            byte[] data = new byte[4];
            if (this.in.read(data) != 4) {
                throw new IOException();
            }
            return Ints.fromByteArray((byte[])data);
        }

        private long readLong() throws IOException {
            byte[] data = new byte[8];
            if (this.in.read(data) != 8) {
                throw new IOException();
            }
            return Longs.fromByteArray((byte[])data);
        }
    }

    private static final class SecurityTokenOutput {
        private final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        private final Deflater deflater = new Deflater(9);
        private final DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)this.byteStream, this.deflater);

        private SecurityTokenOutput() {
        }

        private void writeString(String value) throws IOException {
            byte[] data = value.getBytes(Charsets.UTF_8);
            this.writeInt(data.length);
            this.out.write(data);
        }

        private void writeInt(int value) throws IOException {
            this.out.write(Ints.toByteArray((int)value));
        }

        private void writeLong(long value) throws IOException {
            this.out.write(Longs.toByteArray((long)value));
        }

        private byte[] toByteArray() throws IOException {
            this.out.flush();
            this.out.close();
            return this.byteStream.toByteArray();
        }
    }

    private static final class EncryptedSecurityToken {
        private static final byte[] TOKEN_PREFIX = new byte[]{101, 117, 99, 97, 0, 1};
        private final String accessKeyId;
        private final String originatingId;
        private final String nonce;
        private final long created;
        private final long expires;

        private EncryptedSecurityToken(String originatingAccessKeyId, String userId, long created, long durationMillis) {
            this(originatingAccessKeyId != null ? "$a$" + originatingAccessKeyId : "$u$" + userId, created, durationMillis);
        }

        private EncryptedSecurityToken(Role role, long created, long durationMillis) {
            this("$r$" + role.getRoleId(), created, durationMillis);
        }

        private EncryptedSecurityToken(String originatingId, long created, long durationMillis) {
            this.accessKeyId = Crypto.generateAlphanumericId(20, "AKI");
            this.originatingId = originatingId;
            this.nonce = Crypto.generateSessionToken();
            this.created = created;
            this.expires = created + durationMillis;
        }

        private EncryptedSecurityToken(String accessKeyId, String originatingId, String nonce, long created, long expires) {
            this.accessKeyId = accessKeyId;
            this.originatingId = originatingId;
            this.nonce = nonce;
            this.created = created;
            this.expires = expires;
        }

        private String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getOriginatingAccessKeyId() {
            return this.getTrimmedIfPrefixed("$a$", this.originatingId);
        }

        public String getUserId() {
            return this.getTrimmedIfPrefixed("$u$", this.originatingId);
        }

        public String getRoleId() {
            return this.getTrimmedIfPrefixed("$r$", this.originatingId);
        }

        private String getTrimmedIfPrefixed(String prefix, String value) {
            return value.startsWith(prefix) ? value.substring(prefix.length()) : null;
        }

        public long getCreated() {
            return this.created;
        }

        private long getExpires() {
            return this.expires;
        }

        private boolean isValid() {
            long now = System.currentTimeMillis();
            return now + creationSkewMillis >= this.created && now < this.expires;
        }

        private String getSecretKey(String secret) {
            MessageDigest digest = Digest.SHA256.get();
            digest.update(secret.getBytes(Charsets.UTF_8));
            StringBuilder keyBuilder = new StringBuilder(128);
            while (keyBuilder.length() < 40) {
                if (keyBuilder.length() > 0) {
                    digest.update(keyBuilder.toString().getBytes(Charsets.UTF_8));
                }
                digest.update(this.nonce.getBytes(Charsets.UTF_8));
                keyBuilder.append(B64.standard.encString(digest.digest()).replaceAll("\\p{Punct}", ""));
            }
            return keyBuilder.substring(0, 40);
        }

        private byte[] toBytes() {
            try {
                SecurityTokenOutput out = new SecurityTokenOutput();
                out.writeInt(2);
                out.writeString(this.originatingId);
                out.writeString(this.nonce);
                out.writeLong(this.created);
                out.writeLong(this.expires);
                return out.toByteArray();
            }
            catch (IOException e) {
                throw Exceptions.toUndeclared(e);
            }
        }

        private String encrypt(SecretKey key) {
            try {
                Cipher cipher = Ciphers.AES_GCM.get();
                byte[] iv = new byte[32];
                ((SecureRandom)randomSupplier.get()).nextBytes(iv);
                cipher.init(1, (Key)key, new IvParameterSpec(iv), (SecureRandom)randomSupplier.get());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(TOKEN_PREFIX);
                out.write(iv);
                out.write(cipher.doFinal(this.toBytes()));
                return B64.standard.encString(out.toByteArray());
            }
            catch (IOException | GeneralSecurityException e) {
                throw Exceptions.toUndeclared(e);
            }
        }

        private static EncryptedSecurityToken decrypt(String accessKeyId, SecretKey key, String securityToken) throws GeneralSecurityException {
            try {
                Cipher cipher = Ciphers.AES_GCM.get();
                byte[] securityTokenBytes = B64.standard.dec(securityToken);
                if (securityTokenBytes.length < 64 + TOKEN_PREFIX.length || !Arrays.equals(TOKEN_PREFIX, Arrays.copyOf(securityTokenBytes, TOKEN_PREFIX.length))) {
                    throw new GeneralSecurityException("Invalid token format");
                }
                cipher.init(2, (Key)key, new IvParameterSpec(securityTokenBytes, TOKEN_PREFIX.length, 32), (SecureRandom)randomSupplier.get());
                int offset = TOKEN_PREFIX.length + 32;
                SecurityTokenInput in = new SecurityTokenInput(cipher.doFinal(securityTokenBytes, offset, securityTokenBytes.length - offset));
                if (in.readInt() != 2) {
                    throw new GeneralSecurityException("Invalid token format");
                }
                String originatingAccessKeyIdOrUserId = in.readString();
                String nonce = in.readString();
                long created = in.readLong();
                long expires = in.readLong();
                return new EncryptedSecurityToken(accessKeyId, originatingAccessKeyIdOrUserId, nonce, created, expires);
            }
            catch (IOException e) {
                throw Exceptions.toUndeclared(e);
            }
        }
    }
}

