/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.tokens;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.tokens.SecurityToken;
import com.eucalyptus.auth.tokens.SecurityTokenManager;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class SecurityTokenAWSCredentialsProvider
implements AWSCredentialsProvider {
    private static final int EXPIRATION_SECS = 900;
    private static final int PRE_EXPIRY = 60;
    private final AtomicReference<Supplier<AWSCredentials>> credentialsSupplier = new AtomicReference();
    private final Supplier<User> user;

    public SecurityTokenAWSCredentialsProvider(User user) {
        this((Supplier<User>)Suppliers.ofInstance((Object)user));
    }

    public SecurityTokenAWSCredentialsProvider(Supplier<User> user) {
        this.user = user;
        this.refresh();
    }

    public AWSCredentials getCredentials() {
        return (AWSCredentials)this.credentialsSupplier.get().get();
    }

    public void refresh() {
        this.credentialsSupplier.set(this.refreshCredentialsSupplier());
    }

    private Supplier<AWSCredentials> refreshCredentialsSupplier() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<AWSCredentials>(){

            public AWSCredentials get() {
                try {
                    SecurityToken securityToken = SecurityTokenManager.issueSecurityToken((User)SecurityTokenAWSCredentialsProvider.this.user.get(), 900);
                    return new BasicSessionCredentials(securityToken.getAccessKeyId(), securityToken.getSecretKey(), securityToken.getToken());
                }
                catch (AuthException e) {
                    throw Exceptions.toUndeclared(e);
                }
            }
        }, (long)840L, (TimeUnit)TimeUnit.SECONDS);
    }
}

