/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.principal;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class UserFullName
implements OwnerFullName {
    private static final long serialVersionUID = 1L;
    private static Cache<String, UserFullName> userIdMap = CacheBuilder.newBuilder().softValues().build();
    private static Logger LOG = Logger.getLogger(UserFullName.class);
    private static final String VENDOR = "euare";
    private final String userId;
    private final String userName;
    private final String accountNumber;
    private final String accountName;
    private final String authority;
    private final String relativeId;
    String qName;

    private UserFullName(User user) throws AuthException {
        this.userId = user.getUserId();
        Parameters.checkParam(this.userId, Matchers.notNullValue());
        this.userName = user.getName();
        Account account = user.getAccount();
        this.accountNumber = account.getAccountNumber();
        Parameters.checkParam(this.accountNumber, Matchers.notNullValue());
        this.accountName = account.getName();
        this.authority = "arn:aws" + ":" + VENDOR + ":" + ":" + this.accountNumber + ":";
        this.relativeId = (String)FullName.ASSEMBLE_PATH_PARTS.apply((Object)new String[]{"user", user.getName()});
        this.qName = this.authority + this.relativeId;
    }

    public static UserFullName getInstance(String userId, String ... relativePath) {
        if (userIdMap.asMap().containsKey(userId)) {
            return (UserFullName)userIdMap.getIfPresent((Object)userId);
        }
        try {
            userIdMap.put((Object)userId, (Object)UserFullName.getInstance(Accounts.lookupUserById(userId), relativePath));
            return (UserFullName)userIdMap.getIfPresent((Object)userId);
        }
        catch (AuthException ex) {
            userIdMap.put((Object)userId, (Object)UserFullName.getInstance(Principals.systemUser(), relativePath));
            return (UserFullName)userIdMap.getIfPresent((Object)userId);
        }
    }

    public static UserFullName getInstance(User user, String ... relativePath) {
        try {
            if (user != null && !Principals.isFakeIdentify(user.getUserId())) {
                if (!userIdMap.asMap().containsKey(user.getUserId())) {
                    userIdMap.put((Object)user.getUserId(), (Object)new UserFullName(user));
                }
                return (UserFullName)userIdMap.getIfPresent((Object)user.getUserId());
            }
            if (Principals.systemUser().equals(user)) {
                return new UserFullName(Principals.systemUser());
            }
            return new UserFullName(Principals.nobodyUser());
        }
        catch (AuthException ex) {
            LOG.error((Object)ex.getMessage());
            try {
                return new UserFullName(Principals.nobodyUser());
            }
            catch (AuthException ex1) {
                LOG.error((Object)ex1, (Throwable)ex1);
                throw Exceptions.toUndeclared(ex);
            }
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared(ex);
        }
    }

    @Override
    public String getUniqueId() {
        return this.userId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof UserFullName) {
            UserFullName other = (UserFullName)obj;
            if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
                return false;
            }
        } else if (obj instanceof OwnerFullName) {
            OwnerFullName that = (OwnerFullName)obj;
            if (this.getAccountNumber() != null) {
                if (this.getUserId() != null) {
                    return this.getAccountNumber().equals(that.getAccountNumber()) && this.getUserId().equals(that.getUserId());
                }
                if (this.getUserName() != null) {
                    return this.getAccountNumber().equals(that.getAccountNumber()) && this.getUserName().equals(that.getUserName());
                }
            } else {
                if (this.getUserId() != null) {
                    return this.getAccountNumber().equals(that.getAccountNumber()) && this.getUserId().equals(that.getUserId());
                }
                if (this.getUserName() != null) {
                    return this.getAccountNumber().equals(that.getAccountNumber()) && this.getUserName().equals(that.getUserName());
                }
            }
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return this.accountNumber;
    }

    @Override
    public String toString() {
        return this.qName;
    }

    @Override
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public final String getRelativeId() {
        return this.relativeId;
    }

    @Override
    public final String getPartition() {
        return this.accountNumber;
    }

    @Override
    public final String getVendor() {
        return VENDOR;
    }

    @Override
    public final String getRegion() {
        return "";
    }

    @Override
    public boolean isOwner(String ownerId) {
        return this.userId.equals(ownerId) || this.accountNumber.equals(ownerId);
    }

    @Override
    public boolean isOwner(OwnerFullName ownerFullName) {
        return this.userId.equals(ownerFullName.getAccountNumber()) || this.accountNumber.equals(ownerFullName.getAccountNumber());
    }

    public AccountFullName asAccountFullName() {
        return new AccountFullName(this, new String[0]);
    }
}

