/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.principal;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.ServerCertificate;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Principals {
    private static final String SYSTEM_ID = "eucalyptus";
    private static final String NOBODY_ID = "nobody";
    private static final User SYSTEM_USER = new User(){
        private final Certificate cert = new Certificate(){

            @Override
            public Boolean isActive() {
                return true;
            }

            @Override
            public void setActive(Boolean active) throws AuthException {
            }

            @Override
            public Boolean isRevoked() {
                return false;
            }

            @Override
            public void setRevoked(Boolean revoked) throws AuthException {
            }

            @Override
            public String getPem() {
                return B64.url.encString(PEMFiles.getBytes(this.getX509Certificate()));
            }

            @Override
            public X509Certificate getX509Certificate() {
                return SystemCredentials.lookup(Eucalyptus.class).getCertificate();
            }

            @Override
            public void setX509Certificate(X509Certificate x509) throws AuthException {
            }

            @Override
            public Date getCreateDate() {
                return SystemCredentials.lookup(Eucalyptus.class).getCertificate().getNotBefore();
            }

            @Override
            public void setCreateDate(Date createDate) throws AuthException {
            }

            @Override
            public User getUser() throws AuthException {
                return Principals.systemUser();
            }

            @Override
            public String getCertificateId() {
                return Principals.SYSTEM_ID;
            }
        };
        private final List<Certificate> certs = new ArrayList<Certificate>(){
            {
                this.add(cert);
            }
        };

        @Override
        public String getUserId() {
            return Principals.SYSTEM_ID;
        }

        @Override
        public String getName() {
            return Principals.SYSTEM_ID;
        }

        @Override
        public String getPath() {
            return "/";
        }

        @Override
        public Date getCreateDate() {
            return null;
        }

        @Override
        public User.RegistrationStatus getRegistrationStatus() {
            return null;
        }

        @Override
        public Boolean isEnabled() {
            return true;
        }

        @Override
        public String getToken() {
            return null;
        }

        @Override
        public String getConfirmationCode() {
            return null;
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public Long getPasswordExpires() {
            return null;
        }

        @Override
        public String getInfo(String key) throws AuthException {
            return null;
        }

        @Override
        public Map<String, String> getInfo() throws AuthException {
            return null;
        }

        @Override
        public List<AccessKey> getKeys() throws AuthException {
            return null;
        }

        @Override
        public AccessKey getKey(String keyId) throws AuthException {
            return null;
        }

        @Override
        public AccessKey createKey() throws AuthException {
            return null;
        }

        @Override
        public List<Certificate> getCertificates() throws AuthException {
            return this.certs;
        }

        @Override
        public Certificate getCertificate(String certificateId) throws AuthException {
            return this.cert;
        }

        @Override
        public Certificate addCertificate(X509Certificate certificate) throws AuthException {
            return this.cert;
        }

        @Override
        public List<Group> getGroups() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public String getAccountNumber() throws AuthException {
            return this.getAccount().getAccountNumber();
        }

        @Override
        public Account getAccount() throws AuthException {
            return Principals.systemAccount();
        }

        @Override
        public boolean isSystemAdmin() {
            return true;
        }

        @Override
        public boolean isSystemUser() {
            return true;
        }

        @Override
        public boolean isAccountAdmin() {
            return true;
        }

        @Override
        public List<Policy> getPolicies() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public Policy addPolicy(String name, String policy) throws AuthException, PolicyParseException {
            return null;
        }

        @Override
        public Policy putPolicy(String name, String policy) throws AuthException, PolicyParseException {
            return null;
        }

        @Override
        public List<Authorization> lookupAuthorizations(String resourceType) throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public List<Authorization> lookupQuotas(String resourceType) throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public void setName(String name) throws AuthException {
        }

        @Override
        public void setPath(String path) throws AuthException {
        }

        @Override
        public void setRegistrationStatus(User.RegistrationStatus stat) throws AuthException {
        }

        @Override
        public void setEnabled(Boolean enabled) throws AuthException {
        }

        @Override
        public void setToken(String token) throws AuthException {
        }

        @Override
        public String resetToken() throws AuthException {
            return null;
        }

        @Override
        public void setConfirmationCode(String code) throws AuthException {
        }

        @Override
        public void createConfirmationCode() throws AuthException {
        }

        @Override
        public void setPassword(String password) throws AuthException {
        }

        @Override
        public void setPasswordExpires(Long time) throws AuthException {
        }

        @Override
        public void setInfo(String key, String value) throws AuthException {
        }

        @Override
        public void setInfo(Map<String, String> newInfo) throws AuthException {
        }

        @Override
        public void removeKey(String keyId) throws AuthException {
        }

        @Override
        public void removeCertificate(String certficateId) throws AuthException {
        }

        @Override
        public void removePolicy(String name) throws AuthException {
        }

        @Override
        public void removeInfo(String key) throws AuthException {
        }
    };
    private static final User NOBODY_USER = new User(){
        private final Certificate cert = new Certificate(){

            @Override
            public Boolean isActive() {
                return true;
            }

            @Override
            public void setActive(Boolean active) throws AuthException {
            }

            @Override
            public Boolean isRevoked() {
                return null;
            }

            @Override
            public void setRevoked(Boolean revoked) throws AuthException {
            }

            @Override
            public String getPem() {
                return B64.url.encString(PEMFiles.getBytes(this.getX509Certificate()));
            }

            @Override
            public X509Certificate getX509Certificate() {
                return SystemCredentials.lookup(Eucalyptus.class).getCertificate();
            }

            @Override
            public void setX509Certificate(X509Certificate x509) throws AuthException {
            }

            @Override
            public Date getCreateDate() {
                return null;
            }

            @Override
            public void setCreateDate(Date createDate) throws AuthException {
            }

            @Override
            public User getUser() throws AuthException {
                return Principals.nobodyUser();
            }

            @Override
            public String getCertificateId() {
                return Principals.NOBODY_ID;
            }
        };
        private final List<Certificate> certs = new ArrayList<Certificate>(){
            {
                this.add(cert);
            }
        };

        @Override
        public String getUserId() {
            return Principals.NOBODY_ID;
        }

        @Override
        public String getName() {
            return Principals.NOBODY_ID;
        }

        @Override
        public String getPath() {
            return "/";
        }

        @Override
        public Date getCreateDate() {
            return null;
        }

        @Override
        public User.RegistrationStatus getRegistrationStatus() {
            return null;
        }

        @Override
        public Boolean isEnabled() {
            return true;
        }

        @Override
        public String getToken() {
            return null;
        }

        @Override
        public String getConfirmationCode() {
            return null;
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public Long getPasswordExpires() {
            return null;
        }

        @Override
        public String getInfo(String key) throws AuthException {
            return null;
        }

        @Override
        public Map<String, String> getInfo() throws AuthException {
            return null;
        }

        @Override
        public List<AccessKey> getKeys() throws AuthException {
            return null;
        }

        @Override
        public AccessKey getKey(String keyId) throws AuthException {
            return null;
        }

        @Override
        public AccessKey createKey() throws AuthException {
            return null;
        }

        @Override
        public List<Certificate> getCertificates() throws AuthException {
            return this.certs;
        }

        @Override
        public Certificate getCertificate(String certificateId) throws AuthException {
            return this.cert;
        }

        @Override
        public Certificate addCertificate(X509Certificate certificate) throws AuthException {
            return this.cert;
        }

        @Override
        public List<Group> getGroups() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public String getAccountNumber() throws AuthException {
            return this.getAccount().getAccountNumber();
        }

        @Override
        public Account getAccount() throws AuthException {
            return NOBODY_ACCOUNT;
        }

        @Override
        public boolean isSystemAdmin() {
            return false;
        }

        @Override
        public boolean isSystemUser() {
            return false;
        }

        @Override
        public boolean isAccountAdmin() {
            return false;
        }

        @Override
        public List<Policy> getPolicies() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public Policy addPolicy(String name, String policy) throws AuthException, PolicyParseException {
            return null;
        }

        @Override
        public Policy putPolicy(String name, String policy) throws AuthException, PolicyParseException {
            return null;
        }

        @Override
        public List<Authorization> lookupAuthorizations(String resourceType) throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public List<Authorization> lookupQuotas(String resourceType) throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public void setName(String name) throws AuthException {
        }

        @Override
        public void setPath(String path) throws AuthException {
        }

        @Override
        public void setRegistrationStatus(User.RegistrationStatus stat) throws AuthException {
        }

        @Override
        public void setEnabled(Boolean enabled) throws AuthException {
        }

        @Override
        public void setToken(String token) throws AuthException {
        }

        @Override
        public String resetToken() throws AuthException {
            return null;
        }

        @Override
        public void setConfirmationCode(String code) throws AuthException {
        }

        @Override
        public void createConfirmationCode() throws AuthException {
        }

        @Override
        public void setPassword(String password) throws AuthException {
        }

        @Override
        public void setPasswordExpires(Long time) throws AuthException {
        }

        @Override
        public void setInfo(String key, String value) throws AuthException {
        }

        @Override
        public void setInfo(Map<String, String> newInfo) throws AuthException {
        }

        @Override
        public void removeKey(String keyId) throws AuthException {
        }

        @Override
        public void removeCertificate(String certficateId) throws AuthException {
        }

        @Override
        public void removePolicy(String name) throws AuthException {
        }

        @Override
        public void removeInfo(String key) throws AuthException {
        }
    };
    private static final Account NOBODY_ACCOUNT = new SystemAccount(Account.NOBODY_ACCOUNT_ID, "nobody", Principals.nobodyUser());
    private static final Account SYSTEM_ACCOUNT = new SystemAccount(Account.SYSTEM_ACCOUNT_ID, "eucalyptus", Principals.systemUser());
    private static final Set<Account> FAKE_ACCOUNTS = ImmutableSet.of((Object)Principals.systemAccount(), (Object)Principals.nobodyAccount());
    private static final Set<String> FAKE_ACCOUNT_NUMBERS = ImmutableSet.copyOf((Iterable)Iterables.transform(FAKE_ACCOUNTS, Accounts.toAccountNumber()));
    private static final Set<User> FAKE_USERS = ImmutableSet.of((Object)Principals.systemUser(), (Object)Principals.nobodyUser());
    private static final Set<String> FAKE_USER_IDS = ImmutableSet.copyOf((Iterable)Iterables.transform(FAKE_USERS, Accounts.toUserId()));
    private static final UserFullName SYSTEM_USER_ERN = UserFullName.getInstance(Principals.systemUser(), new String[0]);
    private static final UserFullName NOBODY_USER_ERN = UserFullName.getInstance(Principals.nobodyUser(), new String[0]);

    public static User systemUser() {
        return SYSTEM_USER;
    }

    public static User nobodyUser() {
        return NOBODY_USER;
    }

    public static Account nobodyAccount() {
        return NOBODY_ACCOUNT;
    }

    public static Account systemAccount() {
        return SYSTEM_ACCOUNT;
    }

    public static OwnerFullName nobodyFullName() {
        return NOBODY_USER_ERN;
    }

    public static OwnerFullName systemFullName() {
        return SYSTEM_USER_ERN;
    }

    public static boolean isFakeIdentityAccountNumber(String id) {
        return FAKE_ACCOUNT_NUMBERS.contains(id);
    }

    public static boolean isFakeIdentityUserId(String id) {
        return FAKE_USER_IDS.contains(id);
    }

    public static boolean isFakeIdentify(String id) {
        return Principals.isFakeIdentityAccountNumber(id) || Principals.isFakeIdentityUserId(id);
    }

    public static boolean isSameUser(User user1, User user2) {
        return user1 != null && user2 != null && !Strings.isNullOrEmpty((String)user1.getUserId()) && !Strings.isNullOrEmpty((String)user2.getUserId()) && user1.getUserId().equals(user2.getUserId());
    }

    private static class SystemAccount
    implements Account {
        private static final long serialVersionUID = 1L;
        private final Long accountId;
        private final String accountName;
        private final User systemUser;

        private SystemAccount(Long accountId, String accountName, User systemUser) {
            this.accountId = accountId;
            this.accountName = accountName;
            this.systemUser = systemUser;
        }

        @Override
        public String getCanonicalId() {
            return "";
        }

        @Override
        public String getAccountNumber() {
            return String.format("%012d", this.accountId);
        }

        @Override
        public String getName() {
            return this.accountName;
        }

        @Override
        public void setName(String name) throws AuthException {
        }

        @Override
        public String getDisplayName() {
            return Accounts.getAccountFullName(this);
        }

        @Override
        public OwnerFullName getOwner() {
            return AccountFullName.getInstance(this, new String[0]);
        }

        @Override
        public List<User> getUsers() throws AuthException {
            return Lists.newArrayList((Object[])new User[]{this.systemUser});
        }

        @Override
        public List<Group> getGroups() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public List<Role> getRoles() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public List<InstanceProfile> getInstanceProfiles() throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public InstanceProfile addInstanceProfile(String instanceProfileName, String path) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public void deleteInstanceProfile(String instanceProfileName) throws AuthException {
        }

        @Override
        public InstanceProfile lookupInstanceProfileByName(String instanceProfileName) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public User addUser(String userName, String path, boolean enabled, Map<String, String> info) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public void deleteUser(String userName, boolean forceDeleteAdmin, boolean recursive) throws AuthException {
        }

        @Override
        public Role addRole(String roleName, String path, String assumeRolePolicy) throws AuthException, PolicyParseException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public void deleteRole(String roleName) throws AuthException {
        }

        @Override
        public Group addGroup(String groupName, String path) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public void deleteGroup(String groupName, boolean recursive) throws AuthException {
        }

        @Override
        public Group lookupGroupByName(String groupName) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public Role lookupRoleByName(String roleName) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public User lookupUserByName(String userName) throws AuthException {
            if (this.systemUser.getName().equals(userName)) {
                return this.systemUser;
            }
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public User lookupAdmin() throws AuthException {
            return this.systemUser;
        }

        @Override
        public List<Authorization> lookupAccountGlobalAuthorizations(String resourceType) throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public List<Authorization> lookupAccountGlobalQuotas(String resourceType) throws AuthException {
            return Lists.newArrayList();
        }

        @Override
        public ServerCertificate addServerCertificate(String certName, String certBody, String certChain, String path, String pk) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public ServerCertificate deleteServerCertificate(String certName) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public ServerCertificate lookupServerCertificate(String certName) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public List<ServerCertificate> listServerCertificates(String pathPrefix) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }

        @Override
        public void updateServerCeritificate(String certName, String newCertName, String newPath) throws AuthException {
            throw new AuthException("It is not possible to modify the SYSTEM user or account.");
        }
    }
}

