/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.principal;

import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Principal
extends Serializable {
    public Boolean isNotPrincipal();

    public PrincipalType getType();

    public Set<String> getValues();

    public static enum PrincipalType {
        AWS{

            @Override
            public String convertForUserMatching(String principal) {
                if ("*".equals(principal)) {
                    return principal;
                }
                Matcher accountIdMatcher = accountIdPattern.matcher(principal);
                if (accountIdMatcher.matches()) {
                    String accountId = (String)Objects.firstNonNull((Object)accountIdMatcher.group(1), (Object)accountIdMatcher.group(2));
                    return new EuareResourceName(accountId, "user", "/", "*").toString();
                }
                Ern ern = Ern.parse(principal);
                if (IAM_USER.equals(ern.getResourceType())) {
                    return principal;
                }
                return null;
            }
        }
        ,
        Service{

            @Override
            public String convertForUserMatching(String principal) {
                return principal;
            }
        };

        private static final String IAM_USER;
        private static final Pattern accountIdPattern;

        public Set<String> convertForUserMatching(Set<String> values) {
            HashSet converted = Sets.newHashSet();
            for (String value : values) {
                String convertedValue = this.convertForUserMatching(value);
                if (convertedValue == null) continue;
                converted.add(convertedValue);
            }
            return converted;
        }

        public abstract String convertForUserMatching(String var1);

        static {
            IAM_USER = PolicySpec.qualifiedName("iam", "user");
            accountIdPattern = Pattern.compile("([0-9]{12})|arn:aws:iam::([0-9]{12}):root");
        }
    }
}

