/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.principal;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.google.common.base.Function;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.annotation.Nullable;

public interface Certificate
extends Serializable {
    public String getCertificateId();

    public Boolean isActive();

    public void setActive(Boolean var1) throws AuthException;

    public Boolean isRevoked();

    public void setRevoked(Boolean var1) throws AuthException;

    public String getPem();

    public X509Certificate getX509Certificate();

    public void setX509Certificate(X509Certificate var1) throws AuthException;

    public Date getCreateDate();

    public void setCreateDate(Date var1) throws AuthException;

    public User getUser() throws AuthException;

    public static class Util {
        public static Function<Certificate, Boolean> revoked() {
            return CertificateToRevokedFlag.INSTANCE;
        }

        private static enum CertificateToRevokedFlag implements Function<Certificate, Boolean>
        {
            INSTANCE;


            @Nullable
            public Boolean apply(@Nullable Certificate certificate) {
                return certificate == null ? null : certificate.isRevoked();
            }
        }
    }
}

