/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.principal;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class AccountFullName
implements OwnerFullName {
    private static Logger LOG = Logger.getLogger(UserFullName.class);
    private static final String VENDOR = "euare";
    private final String accountNumber;
    private final String accountName;
    private final String authority;
    private final String relativeId;
    private final String qName;

    protected AccountFullName(OwnerFullName ownerFn, String ... relativePath) {
        Parameters.checkParam(ownerFn, Matchers.notNullValue());
        this.accountNumber = ownerFn.getAccountNumber();
        Parameters.checkParam(this.accountNumber, Matchers.notNullValue());
        this.accountName = null;
        this.authority = ownerFn.getAuthority();
        this.relativeId = (String)FullName.ASSEMBLE_PATH_PARTS.apply((Object)relativePath);
        this.qName = this.authority + this.relativeId;
    }

    protected AccountFullName(Account account, String ... relativePath) {
        this.accountNumber = account.getAccountNumber();
        Parameters.checkParam(this.accountNumber, Matchers.notNullValue());
        this.accountName = null;
        this.authority = "arn:aws" + ":" + VENDOR + ":" + ":" + this.accountNumber + ":";
        this.relativeId = (String)FullName.ASSEMBLE_PATH_PARTS.apply((Object)relativePath);
        this.qName = this.authority + this.relativeId;
    }

    @Override
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @Override
    public final String getVendor() {
        return VENDOR;
    }

    @Override
    public final String getRegion() {
        return "";
    }

    @Override
    public final String getNamespace() {
        return this.accountNumber;
    }

    @Override
    public final String getRelativeId() {
        return this.relativeId;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public final String getPartition() {
        return this.accountNumber;
    }

    @Override
    public String toString() {
        return this.qName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountNumber == null ? 0 : this.accountNumber.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof OwnerFullName) {
            OwnerFullName that = (OwnerFullName)obj;
            return this.getAccountNumber().equals(that.getAccountNumber());
        }
        return false;
    }

    @Override
    public String getUniqueId() {
        return this.accountNumber;
    }

    public static AccountFullName getInstance(String accountId, String ... relativePath) {
        Account account = null;
        try {
            account = Accounts.lookupAccountById(accountId);
        }
        catch (AuthException ex) {
            account = Principals.systemAccount();
        }
        return AccountFullName.getInstance(account, relativePath);
    }

    public static AccountFullName getInstance(Account account, String ... relativePath) {
        if (account == null) {
            return new AccountFullName(Principals.nobodyAccount(), relativePath);
        }
        if (account == Principals.systemAccount()) {
            return new AccountFullName(Principals.systemAccount(), relativePath);
        }
        return new AccountFullName(account, relativePath);
    }

    @Override
    public String getUserId() {
        return null;
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public boolean isOwner(String ownerId) {
        return this.getAccountNumber() != null && this.getAccountNumber().equals(ownerId);
    }

    @Override
    public boolean isOwner(OwnerFullName ownerFullName) {
        return false;
    }
}

