/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Keys {
    public static final String AWS_CURRENTTIME = "aws:currenttime";
    public static final String AWS_SOURCEIP = "aws:sourceip";
    public static final String S3_MAX_KEYS = "s3:max-keys";
    public static final String EC2_KEEPALIVE = "ec2:keepalive";
    public static final String EC2_EXPIRATIONTIME = "ec2:expirationtime";
    public static final String EC2_QUOTA_VM_INSTANCE_NUMBER = "ec2:quota-vminstancenumber";
    public static final String EC2_QUOTA_IMAGE_NUMBER = "ec2:quota-imagenumber";
    public static final String EC2_QUOTA_VOLUME_NUMBER = "ec2:quota-volumenumber";
    public static final String EC2_QUOTA_VOLUME_TOTAL_SIZE = "ec2:quota-volumetotalsize";
    public static final String EC2_QUOTA_SNAPSHOT_NUMBER = "ec2:quota-snapshotnumber";
    public static final String EC2_QUOTA_ADDRESS_NUMBER = "ec2:quota-addressnumber";
    public static final String EC2_QUOTA_SECURITYGROUP_NUMBER = "ec2:quota-securitygroupnumber";
    public static final String EC2_QUOTA_VPC_NUMBER = "ec2:quota-vpcnumber";
    public static final String EC2_QUOTA_INTERNETGATEWAY_NUMBER = "ec2:quota-internetgatewaynumber";
    public static final String S3_QUOTA_BUCKET_NUMBER = "s3:quota-bucketnumber";
    public static final String S3_QUOTA_BUCKET_TOTAL_SIZE = "s3:quota-buckettotalsize";
    public static final String S3_QUOTA_BUCKET_SIZE = "s3:quota-bucketsize";
    public static final String S3_QUOTA_BUCKET_OBJECT_NUMBER = "s3:quota-bucketobjectnumber";
    public static final String S3_QUOTA_BUCKET_NUMBER_FAKE = "s3:quota-bucketnumber";
    public static final String S3_QUOTA_BUCKET_TOTAL_SIZE_FAKE = "s3:quota-buckettotalsize";
    public static final String S3_QUOTA_BUCKET_SIZE_FAKE = "s3:quota-bucketsize";
    public static final String S3_QUOTA_BUCKET_OBJECT_NUMBER_FAKE = "s3:quota-bucketobjectnumber";
    public static final String IAM_QUOTA_USER_NUMBER = "iam:quota-usernumber";
    public static final String IAM_QUOTA_GROUP_NUMBER = "iam:quota-groupnumber";
    public static final String IAM_QUOTA_ROLE_NUMBER = "iam:quota-rolenumber";
    public static final String IAM_QUOTA_INSTANCE_PROFILE_NUMBER = "iam:quota-instanceprofilenumber";
    public static final String IAM_QUOTA_SERVER_CERTIFICATE_NUMBER = "iam:quota-servercertificatenumber";
    public static final String IAM_QUOTA_ACCESS_KEY_NUMBER_PER_USER = "iam:quota-accesskeynumberperuser";
    public static final String IAM_QUOTA_SIGNING_CERTIFICATE_NUMBER_PER_USER = "iam:quota-signingcertificatenumberperuser";
    private static final Map<String, Class<? extends Key>> KEY_MAP = Maps.newHashMap();

    public static Key getKeyInstance(Class<? extends Key> keyClass) {
        try {
            Key key = keyClass.newInstance();
            return key;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can not find key class " + keyClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can not find key class " + keyClass.getName(), e);
        }
        catch (ExceptionInInitializerError e) {
            throw new RuntimeException("Can not find key class " + keyClass.getName(), e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Can not find key class " + keyClass.getName(), e);
        }
    }

    public static Class<? extends Key> getKeyClass(String name) {
        return KEY_MAP.get(name);
    }

    public static Map<String, Key> getKeyInstances(Key.EvaluationConstraint constraint) {
        return Maps.transformValues((Map)Maps.filterValues(KEY_MAP, CollectionUtils.propertyContainsPredicate(constraint, Functions.compose((Function)PolicyKeyToEvaluationConstraints.INSTANCE, (Function)KeyClassToPolicyKey.INSTANCE))), (Function)KeyClassToKeyInstance.INSTANCE);
    }

    public static synchronized boolean registerKey(String keyName, Class<? extends Key> keyClass) {
        if (KEY_MAP.containsKey(keyName)) {
            return false;
        }
        KEY_MAP.put(keyName, keyClass);
        return true;
    }

    public static Function<Key, String> value() {
        return KeyToKeyValue.INSTANCE;
    }

    static enum PolicyKeyToEvaluationConstraints implements Function<PolicyKey, List<Key.EvaluationConstraint>>
    {
        INSTANCE;


        public List<Key.EvaluationConstraint> apply(PolicyKey policyKey) {
            return Arrays.asList(policyKey.evaluationConstraints());
        }
    }

    static enum KeyClassToPolicyKey implements Function<Class<? extends Key>, PolicyKey>
    {
        INSTANCE;


        public PolicyKey apply(Class<? extends Key> keyClass) {
            return Ats.from(keyClass).get(PolicyKey.class);
        }
    }

    static enum KeyClassToKeyInstance implements Function<Class<? extends Key>, Key>
    {
        INSTANCE;


        public Key apply(Class<? extends Key> keyClass) {
            return Keys.getKeyInstance(keyClass);
        }
    }

    static enum KeyToKeyValue implements Function<Key, String>
    {
        INSTANCE;


        public String apply(Key key) {
            try {
                return key.value();
            }
            catch (AuthException e) {
                throw Exceptions.toUndeclared(e);
            }
        }
    }
}

