/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.ern;

import com.eucalyptus.auth.policy.ern.Ern;

public class EuareResourceName
extends Ern {
    private String userOrGroup;
    private String path;
    private String name;

    public EuareResourceName(String namespace, String userOrGroup, String path, String name) {
        this.namespace = namespace;
        this.userOrGroup = userOrGroup;
        this.path = path;
        this.name = name;
        this.vendor = "iam";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("arn:aws:").append(this.getVendor()).append("::").append(this.getNamespace()).append(':').append(this.userOrGroup).append(this.path);
        if (!"/".equals(this.path) && !this.path.endsWith("/")) {
            sb.append('/');
        }
        sb.append(this.name);
        return sb.toString();
    }

    public void setUserOrGroup(String userOrGroup) {
        this.userOrGroup = userOrGroup;
    }

    public String getUserOrGroup() {
        return this.userOrGroup;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getResourceType() {
        return this.vendor + ":" + this.userOrGroup;
    }

    @Override
    public String getResourceName() {
        if ("/".equals(this.path) || this.path.endsWith("/")) {
            return this.path + this.name;
        }
        return this.path + "/" + this.name;
    }
}

